/***************************************************************************
                          About.cpp  -  description
                             -------------------
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-99 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qstring.h>
#include <qpushbt.h>
#include <qlayout.h>
#include <qvbox.h>

#include <kurllabel.h>
#include <kiconloader.h>
#include <kapp.h>
#include <kaboutdata.h>
#include <kglobalsettings.h>
#include <kdebug.h>
#include <klocale.h>

#include "About.h"
#include "ksv_core.h"

#include "version.h"

#define MIN_SIZE(A) A->setMinimumSize(A->sizeHint())

AboutDlg::AboutDlg (QWidget* parent)
  : KDialogBase (parent, "AboutDialog", false, i18n("About %1").arg(kapp->aboutData()->programName()),
				 Help|Close, Close, true),
  mAppName (kapp->aboutData()->programName())
{
  QWidget* page = new QWidget (this);
  setMainWidget (page);
  
  QBoxLayout* topLayout = new QVBoxLayout(page, 0, spacingHint());

  QFont normal_bold_font = KGlobalSettings::generalFont();
  normal_bold_font.setBold(true);

  QFont large_bold_font = normal_bold_font;
  large_bold_font.setPointSize (large_bold_font.pointSize() * 2);

  QFont small_bold_font = normal_bold_font;
  small_bold_font.setPointSize (small_bold_font.pointSize() - 2);

  QLabel* title = new QLabel (mAppName, page);
  title->setFont(large_bold_font);
  MIN_SIZE(title);
  topLayout->addWidget(title, 0, AlignCenter);

  int max_min_width = title->minimumWidth();

  QBoxLayout* picLayout = new QHBoxLayout(0);
  topLayout->addLayout(picLayout);
  QLabel* pic = new QLabel(page);
  pic->setPixmap(DesktopIcon("ksysv", 48));
  MIN_SIZE(pic);
  picLayout->addWidget(pic, 0, AlignLeft|AlignBottom);
  picLayout->addSpacing(KDialog::spacingHint());

  QBoxLayout* versionLayout = new QVBoxLayout(0);
  picLayout->addLayout(versionLayout);
  picLayout->addStretch (5);
  versionLayout->addStretch(5);

  QLabel* version = new QLabel (i18n("Version %1").arg(KSYSV_VERSION_STRING), page);
  version->setFont(normal_bold_font);
  MIN_SIZE(version);
  versionLayout->addWidget(version, 0, AlignLeft|AlignBottom);

  QBoxLayout* copyLayout = new QHBoxLayout(0);
  versionLayout->addLayout(copyLayout);

  QBoxLayout* c1l = new QVBoxLayout (0);
  copyLayout->addLayout (c1l);

  QLabel* copyright1 = new QLabel( i18n("Copyright %1 1997-2000 ").arg(ksv::copyrightSymbol()), page);
  copyright1->setFont(normal_bold_font);
  copyright1->setAlignment (AlignLeft);
  MIN_SIZE(copyright1);
  c1l->addWidget(copyright1, 0, AlignLeft|AlignBottom);

  QBoxLayout* authorLayout = new QVBoxLayout(0);
  copyLayout->addLayout(authorLayout);

  KURLLabel* copyright2 = new KURLLabel ("mailto:putzer@kde.org", "Peter Putzer", page);
  copyright2->setFloat(true);
  copyright2->setUnderline(false);
  copyright2->setTipText(i18n("Mail bug report/success story/lots of money/..."));
  copyright2->setUseTips(true);
  copyright2->setFont(normal_bold_font);
  copyright2->setAlignment (AlignLeft);
  
  // react on click
  connect(copyright2, SIGNAL(leftClickedURL(const QString&)), this, SLOT(callMailer(const QString&)));

  // insert into layout
  MIN_SIZE(copyright2);
  authorLayout->addWidget (copyright2, 0, AlignLeft|AlignBottom);
  //copyLayout->addWidget(copyright2, 0, AlignLeft|AlignBottom);

  QLabel* additionalCopyright =
    new QLabel (i18n(/*"Printing taken from kedit. Copyright %1 1997 Bernd Johannes Wuebben.\n" \ */
					 "Uses the KDE %2 libraries. Copyright %3 1997-2000 The KDE Team.\n" \
					 "Uses the Qt %4 library. Copyright %5 1992-2000 Troll Tech AS.")
                     /*				.arg(ksv::copyrightSymbol()) */
				.arg(KDE_VERSION_STRING).arg(ksv::copyrightSymbol())
				.arg(QT_VERSION_STR).arg(ksv::copyrightSymbol()), page);

  additionalCopyright->setFont(small_bold_font);
  MIN_SIZE(additionalCopyright);
  topLayout->addWidget(additionalCopyright);

  max_min_width = kMax (topLayout->minimumSize().width(),
                       kapp->desktop()->width() / 3);

  QLabel* description
    = new QLabel (i18n("An editor for SysV-style init configuration, similar "\
                       "to Red Hat's <em>tksysv</em>, but <em>SysV-Init Editor</em>" \
                       " allows drag-and-drop, as well as keyboard use."),
                  page);

  description->setAlignment( AlignLeft | WordBreak );
  description->setMargin(KDialog::spacingHint());
  description->setFrameStyle( QFrame::Box | QFrame::Sunken );
  description->setMinimumWidth(max_min_width);
//   description->setMinimumHeight (description->heightForWidth(max_min_width));
  topLayout->addWidget (description);
//   topLayout->addStretch (0);
  //  max_min_width = kMax (max_min_width, description->minimumWidth());

  QLabel* license
    = new QLabel (i18n ("This program is free software; you can redistribute it and/or modify it under the " \
                        " terms of version 2 of the GNU General Public License as published by the Free " \
                        "Software Foundation." \
                        "\n\n" \
                        "This program is distributed in the hope that it will be useful, but WITHOUT ANY " \
                        "WARRANTY; without even the implied warranty of MERCHANTABILITY or " \
                        "FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License " \
                        "for more details."), page);
  
  license->setAlignment( AlignLeft | WordBreak );
  license->setFont(small_bold_font);
  license->setFrameStyle(QFrame::Box | QFrame::Sunken);
  license->setMargin(KDialog::spacingHint());

  max_min_width = topLayout->minimumSize().width();

  license->setMinimumWidth(max_min_width);
  license->adjustSize();
//   license->setMinimumHeight (license->heightForWidth(max_min_width));// + license->margin());

  topLayout->addWidget(license);
 
  // link to homepage
  QBoxLayout* c3l = new QVBoxLayout (0);
  copyLayout->addLayout (c3l);

  QLabel* copyright3 = new QLabel( i18n(". All rights reserved."), page);
  copyright3->setFont(normal_bold_font);
  copyright3->setAlignment (AlignLeft);
  MIN_SIZE(copyright3);
  c3l->addWidget(copyright3, 0, AlignLeft|AlignBottom);
  copyLayout->addStretch (5);

  QBoxLayout* homePageLayout = new QHBoxLayout (0);

  QLabel* homePage1 = new QLabel (i18n ("Visit %1's homepage at ").arg (mAppName), page);
  homePage1->setFixedHeight (homePage1->fontMetrics().lineSpacing());
  MIN_SIZE (homePage1);
  homePageLayout->addWidget (homePage1, 0, AlignLeft|AlignBottom);

  KURLLabel* homePage2 = new KURLLabel ("http://eclipt.uni-klu.ac.at/projects/ksysv",
                                          QString::null, page, "HomePageLabel");
  homePage2->setAlignment (AlignLeft);
  homePage2->setFloat (true);
  homePage2->setUnderline(false);
  MIN_SIZE (homePage2);
  QLabel* homePage3 = new QLabel (".", page);
  MIN_SIZE (homePage3);
  homePageLayout->addWidget (homePage2, 0, AlignLeft|AlignBottom);
  homePageLayout->addWidget (homePage3, 0, AlignLeft|AlignBottom);
  homePageLayout->addStretch (5);

  connect (homePage2, SIGNAL (leftClickedURL (const QString&)),
           this, SLOT (openHomePage (const QString&)));

  topLayout->addStretch (-1);
  topLayout->addLayout (homePageLayout);

  license->setMinimumHeight (license->heightForWidth(max_min_width));
  //   description->setMinimumHeight (description->heightForWidth(max_min_width));
  setFixedSize (minimumSize());
}

AboutDlg::~AboutDlg()
{
  // nothing
}

void AboutDlg::callMailer (const QString& url)
{
  kapp->invokeMailer (url, "KSysV");
}

void AboutDlg::openHomePage (const QString& url)
{
  kdDebug(3000) << "open browser for " << url << endl;
  kapp->invokeBrowser (url);
}

AboutDlg* AboutDlg::self ()
{
  static AboutDlg* dlg = new AboutDlg (kapp->mainWidget());

  return dlg;
}

#include "About.moc"
