/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <qdir.h>

#include "dmaport.h"
#include "interrupt.h"
#include "ioaddress.h"
#include "serportscanner.h"


SerialPortScanner::SerialPortScanner() 
{
  serfhd = 0;
}


/*
 * Public methods
 *****************/
 
Device  *SerialPortScanner::firstDevice()
{
  char buffer[256];

  if (serfhd != 0)
    fclose(serfhd);

  if (!(serfhd = fopen("/proc/tty/driver/serial", "r")))
    return 0;

  // skip first line containing driver info
  fgets(buffer, sizeof(buffer), serfhd);                                              

  return nextDevice();
}

 
Device  *SerialPortScanner::nextDevice()
{
  SerialPort  *dev;

  dev = device();
  
  return dev;
}

 
/* 
 * Private methods
 ******************/
 
SerialPort *SerialPortScanner::device()
{
  char          buffer[256], uart[40];
  int           port, base, irq;
  SerialPort    *serport = 0L;

  if (serfhd < 0)
    return 0;

  while (fgets(buffer, sizeof(buffer), serfhd))
    {
      sscanf(buffer, "%d: uart:%s port:%X irq:%d", &port, uart, &base, &irq);

      // let's assume that "unknown" means "no hardware support present"
      if (strcmp(uart, "unknown") == 0)
	continue;

      serport = new SerialPort(port, uart);
				    
      serport->addResource(new IOAddress(base, ioRange(base)));
      serport->addResource(new Interrupt(irq));

      return serport;
  }

  fclose(serfhd);
  serfhd = 0;
  return 0;
}
 
 
 
