/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <qfile.h>
#include <qtextstream.h>

#include "interrupt.h"
#include "ioaddress.h"
#include "memaddress.h"
#include "pccardscanner.h"


PCCardScanner::PCCardScanner()
{
  // test if we have PCMCIA support
  hasPCMCIA = QFile::exists("/proc/bus/pccard");
  socket = 0;
}


PCCardScanner::~PCCardScanner()
{  
}


/*
 * Public methods
 *****************/

Device  *PCCardScanner::firstDevice()
{
  socket = 0;

  if (hasPCMCIA)
    {
      QString ident = runCardCtl("ident", socket);      
      socket++;

      if (ident.isNull())
	{
	  hasPCMCIA = FALSE;
	  return 0L;
	}
      else
	return new PCCardDevice(ident, socket-1);
    }

  return 0L;
}


Device  *PCCardScanner::nextDevice()
{
  if (hasPCMCIA)
    {
      QString ident = runCardCtl("ident", socket);
      socket++;

      if (ident.isNull())
	{
	  hasPCMCIA = FALSE;
	  return 0L;
	}
      else
	return new PCCardDevice(ident, socket-1);
    }

  return 0L;
}
