
/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <kcmodule.h>
#include <klocale.h>
#include <kglobal.h>
#include <kdialog.h>
#include <kcmdlineargs.h>
#include <qlayout.h> 

#include <qtabwidget.h>

#include <kaboutdata.h>

#include "version.h"
#include "devicelist.h"
#include "isapnpdb.h"
#include "isapnpvendors.h"
#include "mainwindow.h"
#include "main.h"
#include <kdebug.h>

static const char *description =
	I18N_NOOP("KDE System Control Tool");


ISAPnPDataBase          isapnpdb;	// Ugly; execution success depends
ISAPnPVendorDictionary  isapnpvendors;	// on correct order of declarations...
DeviceList              *devicelist;


KSysctrlModule::KSysctrlModule(QWidget *parent, const char *name)
	: KCModule(parent, name)
{

	 QVBoxLayout *top = new QVBoxLayout(this, KDialog::marginHint(), KDialog::spacingHint());
         
  	 KAboutData aboutData( "ksysctrl", I18N_NOOP("KSysControl"),
    					   KSYSCTRL_VERSION,
    					   description,
    					   KAboutData::License_GPL,
    					   "(c) 1999-2000, Thorsten Westheider");

	 devicelist = new DeviceList;


	 KSystemControlMainWindow  *mainwindow;
  	 mainwindow = new KSystemControlMainWindow(this,"mainwindow");

 	 top->addWidget(mainwindow);


}


//int  main(int argc, char *argv[])
extern "C"
{

  	/*KAboutData aboutData( "ksysctrl", I18N_NOOP("KSysControl"),
    					   KSYSCTRL_VERSION,
    					   description,
    					   KAboutData::License_GPL,
    					   "(c) 1999-2000, Thorsten Westheider");

  KCmdLineArgs::init( argc, argv, &aboutData );*/
//  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
//KApplication ksysctrl;

  KCModule *create_ksysctrl(QWidget *parent, const char * name)
  {
    KGlobal::locale()->insertCatalogue("ksysctrl");
	return new KSysctrlModule(parent, name);
  }

/*KSystemControlMainWindow  *mainwindow;
  mainwindow = new KSystemControlMainWindow("mainwindow");
  
  ksysctrl.setTopWidget(mainwindow);
  mainwindow->show();
  
  return ksysctrl.exec();*/
}

#include "main.moc"
