/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <qlayout.h>
#include <qpixmap.h>

#include <kglobal.h>
#include <kiconloader.h>

#include "devtitle.h"


DeviceTitle::DeviceTitle(const QString& xpmfile, const QString& info,
			 QWidget *parent, const char *name) : QWidget(parent, name)
{
  QPixmap  devxpm = BarIcon(xpmfile);
  
  _xpmlabel = new QLabel(this, "xpmlabel", WNorthWestGravity);
  _xpmlabel->setPixmap(devxpm);
  _xpmlabel->adjustSize();
  _xpmlabel->move(0, 0);
  
  _infolabel = new QLabel(this, "infolabel");
  _infolabel->setText(info);
  _infolabel->setAlignment(WordBreak);
  _infolabel->move(_xpmlabel->width()+32, 0);
}


QSize  DeviceTitle::minimumSizeHint() const
{
  QSize  minlabelsize = _infolabel->minimumSizeHint();
  int    minw, minh;
  
  minw = _xpmlabel->width()+32+minlabelsize.width();
  minh = QMAX(_xpmlabel->height(), minlabelsize.height());
  
  return QSize(minw, minh);
}


QSize  DeviceTitle::sizeHint() const
{
  QSize  labelsizehint = _infolabel->sizeHint();
  int    hintw, hinth;
  
  hintw = _xpmlabel->width()+32+labelsizehint.width();
  hinth = QMAX(_xpmlabel->height(), labelsizehint.height());
  
  return QSize(hintw, hinth);
}


/*
 * Protected methods
 ********************/
 
void  DeviceTitle::resizeEvent(QResizeEvent *)
{
  uint  w = width();
  
  _infolabel->resize(w-_xpmlabel->width()-32, 50);
}

