/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <kdebug.h>

#include "devicelist.h"
#include "idedrvscanner.h"
#include "isapnpscanner.h"
#include "parportscanner.h"
#include "serportscanner.h"
#include "pciscanner.h"
#include "scsiscanner.h"
#include "pccardscanner.h"
#include "cputypescanner.h"
#include "memorytypescanner.h"


DeviceList::DeviceList() : _firstscan(true)
{
  setAutoDelete(true);
  clear();

  scanDevices(false);
}


/*
 * Public methods
 *****************/

QList<Conflict>  DeviceList::conflicts(Device *device, QList<Resource> reslist, bool test)
{
  QList<Conflict>  conflictlist;
  Device           *dev;
  Resource         *res, *devres;
  uint             cnt = count();
  uint             i;

  for (dev = at(i = 0); i < cnt-1; dev = at(++i))
    if (dev != device)	// Well...
      for (res = reslist.first(); res; res = reslist.next())
	for (devres = dev->firstResource(); devres; devres = dev->nextResource())
	  if (*res == *devres && (dev->deviceBaseClass() > Device::BaseClassPCISerial) ) conflictlist.append(new Conflict(dev, res));

  if (!test) device->setConflict(!conflictlist.isEmpty());

  return conflictlist;
}


void  DeviceList::rescan(bool scsiscan)
{
  _firstscan = false;

  clear();
  scanDevices(scsiscan);
}


/*
 * Private methods
 ******************/

void  DeviceList::scanDevices(bool scsiscan)
{
  QList<DeviceScanner>  scanlist;
  QList<Conflict>       conflictlist;
  QList<Resource>       reslist;
  DeviceScanner         *scanner;
  Device                *dev;
  Resource              *res;
  uint			cnt;
  uint                  i;
  
  scanlist.setAutoDelete(true);
  scanlist.clear();
  scanlist.append(new PCIScanner());
  scanlist.append(new ISAPnPScanner());
  scanlist.append(new SCSIScanner(!_firstscan && scsiscan));
  scanlist.append(new IDEDriveScanner());
  scanlist.append(new ParallelPortScanner());
  scanlist.append(new SerialPortScanner());
  scanlist.append(new PCCardScanner());
  scanlist.append(new CpuTypeScanner());
  scanlist.append(new MemoryTypeScanner());

  for (scanner = scanlist.first(); scanner; scanner = scanlist.next())  
    for (dev = scanner->firstDevice(); dev; dev = scanner->nextDevice())
	  append(dev);  
  
  cnt = count();    
      
  kdDebug() << "scan" << endl; 
  for (dev = at(i = 0); i < cnt-1; dev = at(++i))
  {
    reslist.clear();
    
    for (res = dev->firstResource(); res; res = dev->nextResource())
      reslist.append(res);
  
    (void) conflicts(dev, reslist, false);
  }
   
}






