/* 	$Id: rpmInstall.h,v 1.7 2001/01/01 05:54:05 toivo Exp $	 */
#ifndef _H_INSTALL
#define _H_INSTALL

#include <stdio.h>
#include "../config.h"

class QString;

#include <fcntl.h>
#include <rpm/rpmlib.h>
#include "rpmVerify.h"
#include "rpmMessages.h"
 
#define INSTALL_PERCENT         (1 << 0)
#define INSTALL_HASH            (1 << 1)
#define INSTALL_NODEPS          (1 << 2)
#define INSTALL_NOORDER         (1 << 3)
#define INSTALL_LABEL           (1 << 4)  /* set if we're being verbose */
#define INSTALL_UPGRADE         (1 << 5)
 
#define UNINSTALL_NODEPS        (1 << 0)
#define UNINSTALL_ALLMATCHES    (1 << 1)

extern QString *rpmEBuf;
int doInstal(const char * rootdir, const QStringList &argv, int installFlags,
	     int interfaceFlags, int probFilter, rpmRelocation * relocations,
	     QString &errs);
int doUninstal(const char * rootdir, const QStringList &argv, int uninstallFlags,
	       int interfaceFlags, QString &errs);
int doSourceInstall(const char * prefix, const char * arg, const char ** specFile,
                    char ** cookie);

void printDepFlags(FILE * f,  QString s, const char * version, int flags);
QString KprintDepProblems(FILE * f, struct rpmDependencyConflict * conflicts,
                             int numConflicts);
#define FREE(x) { if (x) free((void *)x); x = NULL; }       

#endif

