//////////////////////////////////////////////////////////////
//      $Id: cache.h,v 1.4 2000/07/14 15:58:15 toivo Exp $ 
//
// Author: Toivo Pedaste
//

#ifndef CACHE_H
#define CACHE_H

#include <qdir.h>
#include <qlist.h>

#include <kurl.h>

#include "../config.h"
#include "packageInfo.h"

class Locations;
class LcacheObj;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class cacheObj
{
public:
  QString base;
  QString location;
  QString cacheFile;
  QString option;
  bool    subdirs;

  cacheObj(QString Pbase, QString Plocation, QString PcacheFile, QString Poption = QString::null, bool Psubdirs = FALSE);
  ~cacheObj();

  static QString PDir();
  // return path of kpackage cache directory

  static QString CDir();
  // return path of kpackage directory cache

  static  int newDCache(QString url, QString fn, QString &fname);
  // Checks directory cache
  //  -1  Cann't get cache file name
  //   0  Cache file exists
  //   1  Cache file doesn't exit
  // fname return  file name

  static  void rmDCache(QString fn);

  static void clearDCache();
  static void clearPCache();
};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class LcacheObj: public QList<cacheObj>
{
public:
  LcacheObj();
  ~LcacheObj();
};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#endif
