/*
 *  Copyright (C) 2000 Nate Case 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Galeon CORBA interface implementation code */

#include "galeon.h"
#include "Galeon.h"
#include "embed.h"
#include "bookmarks.h"

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>

typedef struct
{
	POA_Galeon_Browser servant;
	PortableServer_POA poa;
} impl_POA_Galeon_Browser;


Galeon_Browser impl_Galeon_Browser__create(	PortableServer_POA poa,
						CORBA_Environment * ev);


/* interface method prototypes */

static CORBA_boolean
impl_Galeon_Browser_loadurl(impl_POA_Galeon_Browser * servant,
		 	     CORBA_char * url,
			     Galeon_ViewState viewstate,
			     CORBA_Environment * ev);

static CORBA_boolean
impl_Galeon_Browser_configure(impl_POA_Galeon_Browser * servant,
				CORBA_Environment * ev);

static CORBA_boolean
impl_Galeon_Browser_addTempBookmark (impl_POA_Galeon_Browser * servant,
				     CORBA_char * name,
				     CORBA_char * url,
				     CORBA_Environment * ev);

/*** epv structures ***/
static PortableServer_ServantBase__epv impl_Galeon_Browser_base_epv =
{
	NULL,		/* _private data */
	NULL,		/* finalize routine */
	NULL,		/* default_POA routine */
};

static POA_Galeon_Browser__epv impl_Galeon_Browser_epv =
{
	NULL,		/* _private */
	(gpointer) & impl_Galeon_Browser_loadurl,
	(gpointer) & impl_Galeon_Browser_configure,
	(gpointer) & impl_Galeon_Browser_addTempBookmark
};

/*** vepv structures ***/
static POA_Galeon_Browser__vepv impl_Galeon_Browser_vepv =
{
	&impl_Galeon_Browser_base_epv,
	&impl_Galeon_Browser_epv,
};


/*** Stub implementations ***/
Galeon_Browser 
impl_Galeon_Browser__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	Galeon_Browser retval;
	impl_POA_Galeon_Browser *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_Galeon_Browser, 1);
	newservant->servant.vepv = &impl_Galeon_Browser_vepv;
	newservant->poa = poa;

	POA_Galeon_Browser__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);

	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

static CORBA_boolean
impl_Galeon_Browser_loadurl(impl_POA_Galeon_Browser * servant,
			  CORBA_char * url,
			  Galeon_ViewState viewstate,
			  CORBA_Environment * ev)
{
	CORBA_boolean retval = TRUE;
	gboolean tabbed_mode;  /* user pref              */
	gboolean new_win;      /* for embed_create_*()   */
	GaleonEmbed *ge;

	tabbed_mode = gnome_config_get_bool (CONF_APPEARANCE_TABBED);

#ifdef DEBUG_CORBA	
	g_print("CORBA: loadurl(%s, %d)\n", url, viewstate);
#endif
	
	/* FIXME: this logic of using the last embed is not ideal - Nate */
	ge = (all_embeds == NULL ? NULL : g_list_last (all_embeds)->data);

	new_win = (viewstate == Galeon_WINDOW) || (viewstate == Galeon_DEFAULT && !tabbed_mode);
	
	switch (viewstate)
	{
		case Galeon_NONE: if (ge != NULL) embed_load_url(ge, url);
				  break;
		case Galeon_DEFAULT:
		case Galeon_WINDOW:
		case Galeon_TAB:  if (strlen(url))
					 embed_create_from_url (ge, url, TRUE,
								new_win);
		    		  else
					 embed_create_default (ge, new_win);
				  break;
	}	 
	
	return retval;
}

static CORBA_boolean
impl_Galeon_Browser_configure(impl_POA_Galeon_Browser * servant,
				CORBA_Environment * ev)
{
	CORBA_boolean retval = TRUE;

#ifdef DEBUG_CORBA
	g_print("CORBA: configure()\n");
#endif

	return retval;
}

static CORBA_boolean
impl_Galeon_Browser_addTempBookmark (impl_POA_Galeon_Browser * servant,
				     CORBA_char * name,
				     CORBA_char * url,
				     CORBA_Environment * ev)
{
	CORBA_boolean retval = TRUE;

	add_bookmark_default (BM_SITE, name, url, NULL);
	
	return retval;
}
