/*****************************************************************************/
/*  options.h - the global variables for the program                         */
/*  Copyright (C) 1998-2001 Brian Masney <masneyb@seul.org>                  */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#include "gftp.h"

supported_gftp_protocols gftp_protocols[] =
{
  {"FTP", 	rfc959_init, 	"ftp"},
  {"HTTP", 	rfc2068_init, 	"http"},
  {"Local", 	local_init, 	"file"},
  {"SSH", 	ssh_init, 	"ssh"},
  {NULL, 	NULL, 		NULL}
};

gftp_proxy_type proxy_type[] = {
  {N_("none"), ""},
  {N_("SITE command"), "USER %pu\nPASS %pp\nSITE %hh\nUSER %hu\nPASS %hp\n"},
  {N_("user@host"), "USER %pu\nPASS %pp\nUSER %hu@%hh\nPASS %hp\n"},
  {N_("user@host:port"), "USER %hu@%hh:%ho\nPASS %hp\n"},
  {N_("AUTHENTICATE"), "USER %hu@%hh\nPASS %hp\nSITE AUTHENTICATE %pu\nSITE RESPONSE %pp\n"},
  {N_("user@host port"), "USER %hu@%hh %ho\nPASS %hp\n"},
  {N_("user@host NOAUTH"), "USER %hu@%hh\nPASS %hp\n"},
  {N_("HTTP Proxy"), "http"},
  {N_("Custom"), ""},
  {NULL, NULL}
};

/* Most of these should be self explanatory */
char version[] = "gFTP " VERSION,
     *emailaddr = NULL,			/* Email address for logging in
                                           anonymously */
     *logfile = NULL,
     *edit_program = NULL,
     *view_program = NULL,
     *firewall_host = NULL,
     *firewall_username = NULL,
     *firewall_password = NULL,
     *firewall_account = NULL,
     *proxy_config = NULL, 		/* The way to log into the proxy */
     *http_proxy_host = NULL,
     *http_proxy_username = NULL, 
     *http_proxy_password = NULL,
     *tmp_directory = NULL,
     *startup_directory = NULL;

FILE * logfd = NULL;			/* Our fd to write logs to */

double maxkbs = 0.00;			/* Bandwidth throttling */
GList * proxy_hosts = NULL, 		/* Our local hosts that won't need to 
                                           use the proxy */
      * registered_exts = NULL,		/* Registered file extensions */
      * viewedit_processes = NULL,      /* View/Edit processes that are 
                                           running */
      * file_transfers = NULL,		/* File transfers in progress */
      * file_transfer_logs = NULL;	/* Logs generated by other threads */

gftp_bookmarks * bookmarks = NULL;
GHashTable * bookmarks_htable = NULL,
           * config_htable = NULL;

int do_one_transfer_at_a_time = 1, 	/* Only allow one transfer at a time. 
                                           The other transfers will be queued */
    start_file_transfers = 1, 		/* Shall we start the file transfers? */
    transfer_in_progress = 0, 		/* Any transfers transferring files? */
    use_cache = 1, 			/* Shall we use the cache? */
    passive_transfer = 1, 		/* Are we sending PASV or PORT to the 
					   server */
    preserve_permissions = 1, 		/* Save the permissions of the 
                                           transfered files */
    sort_dirs_first = 1, 		/* Put the dirs first when sorting */
    confirm_delete = 1, 		/* Confirm to delete files */
    use_default_dl_types = 1, 		/* If this is set, then files will use 
                                           their default dl type. For example, 
                                           if you set in the config file .txt 
                                           files to have a default option of 
                                           ASCII, and if this setting is set, 
                                           it will use ASCII. Otherwise, it 
                                           would use the setting in the FTP 
                                           menu */
    show_hidden_files = 1, 		/* Show hidden files */
    reconnect_diag = 1, 		/* Bring up the reconnect dialog */
    refresh_files = 0, 			/* Refresh the listbox after each file 
                                           is done */
    save_geometry = 1, 			/* Shall we use geometry management? */
    listbox_local_width = 302, 		/* Width of the local listbox */
    listbox_remote_width = 302, 	/* Width of the remote listbox */
    listbox_file_height = 265, 		/* Height of the local/remote listbox */
    transfer_height = 80, 		/* Height of the transfer window */
    log_height = 105, 			/* Height of the logging window */
    connect_timeout = 0, 		/* Timeout for the connection */
    retries = 3, 			/* Number of auto-retries */
    sleep_time = 30, 			/* Number of seconds to wait between 
					   retries */
    read_timeout = 120, 		/* Timeout on the read()s and write()s */
    use_http11 = 1, 			/* Use HTTP/1.1 or HTTP/1.0 */
    listbox_dblclick_action = 0, 	/* What happens when you double click in the
					   file listboxes. 0 = View, 1 = Edit,
					   2 = Download */
    file_trans_column = 100, 		/* The width of the File column in the 
					   listbox */
    local_columns[6] = {100, 85, 75, 76, 120, 75}, /* The width of the local
    	file, size, user, group, date and attribs column */
    remote_columns[6] = {100, 85, 75, 76, 120, 75}, /* The width of the remote
    	file, size, user, group, date and attribs column */
    resolve_symlinks = 1, 		/* Send LIST -L or LIST to the remote ftp 
					   server */
    firewall_port = 21, 		/* What port to connect to for ftp? */
    http_proxy_port = 80,		/* What port to connect to for http? */
    overwrite_by_default = 0;		/* Resume file transfers or set to
                                           overwrite by default */

GList * host_history = NULL,
      * port_history = NULL,
      * user_history = NULL,
      * localhistory = NULL,
      * remotehistory = NULL;
      
unsigned int host_len = 0, 
             port_len = 0, 
             user_len = 0,
             localhistlen = 0,
             remotehistlen = 0;

volatile sig_atomic_t viewedit_process_done = 0;

sigjmp_buf envir;

