/*
*   $Id: vim.c,v 9.1 2001/04/11 05:14:18 darren Exp $
*
*   Copyright (c) 2000-2001, Darren Hiebert
*
*   This source code is released for free distribution under the terms of the
*   GNU General Public License.
*
*   This module contains functions for generating tags for user-defined
*   functions for the Vim editor.
*/

/*
*   INCLUDE FILES
*/
#include "general.h"	/* must always come first */

#include <string.h>

#include "parse.h"
#include "read.h"
#include "vstring.h"

/*
*   DATA DEFINITIONS
*/
typedef enum {
    K_FUNCTION
} vimKind;

static kindOption VimKinds [] = {
    { TRUE, 'f', "function", "functions" }
};

/*
*   FUNCTION DEFINITIONS
*/

static void findVimTags (void)
{
    vString *name = vStringNew ();
    const unsigned char *line;

    while ((line = fileReadLine ()) != NULL)
    {
	if (strncmp ((const char*) line, "fu", (size_t) 2) == 0)
	{
	    const unsigned char *cp = line + 1;
	    if ((int) *++cp == 'n'  &&  (int) *++cp == 'c'  &&
		(int) *++cp == 't'  &&  (int) *++cp == 'i'  &&
		(int) *++cp == 'o'  &&  (int) *++cp == 'n')
		    ++cp;
	    if ((int) *cp == '!')
		++cp;
	    if (isspace ((int) *cp))
	    {
		while (isspace ((int) *cp))
		    ++cp;
		if (isupper ((int) *cp))
		{
		    do
		    {
			vStringPut (name, (int) *cp);
			++cp;
		    } while (isalnum ((int) *cp)  ||  *cp == '_');
		    vStringTerminate (name);
		    makeSimpleTag (name, VimKinds, K_FUNCTION);
		    vStringClear (name);
		}
	    }
	}
    }
    vStringDelete (name);
}

extern parserDefinition* VimParser (void)
{
    static const char *const extensions [] = { "vim", NULL };
    parserDefinition* def = parserNew ("Vim");
    def->kinds      = VimKinds;
    def->kindCount  = KIND_COUNT (VimKinds);
    def->extensions = extensions;
    def->parser     = findVimTags;
    return def;
}

/* vi:set tabstop=8 shiftwidth=4: */
