#if !defined(__sparc__) || defined(__sparc_v9__)
#define ondisk_dqblk dqblk
#define CONVERT_TO_USER_DQUOT(__d, __s) memcpy((__d), (__s), sizeof(*(__d)))
#define CONVERT_TO_KERNEL_DQUOT(__d, __s) memcpy((__d), (__s), sizeof(*(__d)))
#define DQUOT_CONVERT_INIT() do { } while(0)
#define ondisk_dqblk_size sizeof(struct dqblk)
/* Leave dqoff as is... */
#else

#include <sys/utsname.h>

extern int need_dquot_convert;

#define DQUOT_CONVERT_INIT() \
do {	struct utsname name; \
	int ret; \
	need_dquot_convert = 0; \
	ret = uname(&name); \
	if(ret == 0) { \
		if(name.machine[5] != '\0') \
			need_dquot_convert = 1; \
	} \
} while(0)

struct ondisk_dqblk {
	u_int32_t dqb_bhardlimit;	/* absolute limit on disk blks alloc */
	u_int32_t dqb_bsoftlimit;	/* preferred limit on disk blks */
	u_int32_t dqb_curblocks;	/* current block count */
	u_int32_t dqb_ihardlimit;	/* maximum # allocated inodes */
	u_int32_t dqb_isoftlimit;	/* preferred inode limit */
	u_int32_t dqb_curinodes;	/* current # allocated inodes */
	u_int64_t dqb_btime;		/* time limit for excessive disk use */
	u_int64_t dqb_itime;		/* time limit for excessive files */
};

#define ondisk_dqblk_size \
	(need_dquot_convert ? \
	 sizeof(struct ondisk_dqblk) : \
         sizeof(struct dqblk))

#undef dqoff
#define dqoff(__id)	((loff_t) ((__id) * ondisk_dqblk_size))

#define CONVERT_TO_USER_DQUOT(__d, __s) \
do {	memcpy((__d), (__s), sizeof(struct dqblk)); \
	if(need_dquot_convert != 0) { \
		(__d)->dqb_btime = (time_t) (__s)->dqb_btime; \
		(__d)->dqb_itime = (time_t) (__s)->dqb_itime; \
	} \
} while(0)

#define CONVERT_TO_KERNEL_DQUOT(__d, __s) \
do {	memcpy((__d), (__s), ondisk_dqblk_size); \
	if(need_dquot_convert != 0) { \
		(__d)->dqb_btime = (u_int64_t) (__s)->dqb_btime; \
		(__d)->dqb_itime = (u_int64_t) (__s)->dqb_itime; \
	} \
} while(0)

#endif
