/*
 * generic.h -- generic include stuff for new PCCTS ANTLR.
 *
 * SOFTWARE RIGHTS
 *
 * We reserve no LEGAL rights to the Purdue Compiler Construction Tool
 * Set (PCCTS) -- PCCTS is in the public domain.  An individual or
 * company may do whatever they wish with source code distributed with
 * PCCTS or the code generated by PCCTS, including the incorporation of
 * PCCTS, or its output, into commerical software.
 *
 * We encourage users to develop software with PCCTS.  However, we do ask
 * that credit is given to us for developing PCCTS.  By "credit",
 * we mean that if you incorporate our source code into one of your
 * programs (commercial product, research project, or otherwise) that you
 * acknowledge this fact somewhere in the documentation, research report,
 * etc...  If you like PCCTS and have developed a nice tool with the
 * output, please mention that you developed it using PCCTS.  In
 * addition, we ask that this header remain intact in our source code.
 * As long as these guidelines are kept, we expect to continue enhancing
 * this system and expect to make other tools available as they are
 * completed.
 *
 * ANTLR 1.33
 * Terence Parr
 * Parr Research Corporation
 * with Purdue University and AHPCRC, University of Minnesota
 * 1989-1998
 */

#define StrSame			0

#define DefaultParserName	"zzparser"

/* MR9  JVincent@novell.com     Allow user to override default ZZLEXBUFSIZE  */
/* MR11 thm                     Raise antlr's own default ZZLEXBUFSIZE to 8k */
/* MR22 thm                     Raise antlr's own default ZZLEXBUFSIZE to 32k */

#ifndef ZZLEXBUFSIZE
#define ZZLEXBUFSIZE 32000
#endif

/* Tree/FIRST/FOLLOW defines -- valid only after all grammar has been read */
#define ALT			TokenNum+1
#define SET			TokenNum+2
#define TREE_REF	TokenNum+3

					/* E r r o r  M a c r o s */

#define fatal(err)	fatalFL(err, __FILE__, __LINE__)
#define fatal_internal(err)	fatal_intern(err, __FILE__, __LINE__)


#define eMsg1(s,a)	eMsg3(s,a,NULL,NULL)
#define eMsg2(s,a,b)	eMsg3(s,a,b,NULL)

				/* S a n i t y  C h e c k i n g */

#ifndef require
#define require(expr, err) {if ( !(expr) ) fatal_internal(err);}
#endif

					/* L i s t  N o d e s */

typedef struct _ListNode {
			void *elem;			/* pointer to any kind of element */
			struct _ListNode *next;
		} ListNode;

/* Define a Cycle node which is used to track lists of cycles for later
 * reconciliation by ResolveFoCycles().
 */
typedef struct _c {
			int croot;			/* cycle root */
			set cyclicDep;		/* cyclic dependents */
			unsigned deg;		/* degree of FOLLOW set of croot */
		} Cycle;

typedef struct _e {
			int tok;			/* error class name == TokenStr[tok] */
			ListNode *elist;	/* linked list of elements in error set */
			set eset;
			int setdeg;			/* how big is the set */
			int lexclass;		/* which lex class is it in? */
		} ECnode;

typedef struct _TCnode {
			int tok;			/* token class name */
			ListNode *tlist;	/* linked list of elements in token set */
			set tset;
			int lexclass;		/* which lex class is it in? */
			unsigned char dumped; /* this def has been been dumped */
			unsigned setnum;	/* which set number is this guy? (if dumped) */
		} TCnode;

typedef struct _ft {
			char *token;		/* id of token type to remap */
			int tnum;			/* move token type to which token position */
		} ForcedToken;

typedef struct _ContextGuardPredicates {    /* MR13 */
            Predicate *pred;                /* MR13 */
        } ContextGuardPredicates;           /* MR13 */

#define newListNode	(ListNode *) calloc(1, sizeof(ListNode));
#define newCycle	(Cycle *) calloc(1, sizeof(Cycle));
#define newECnode	(ECnode *) calloc(1, sizeof(ECnode));
#define newTCnode	(TCnode *) calloc(1, sizeof(TCnode));


				/* H a s h  T a b l e  E n t r i e s */

typedef struct _t {				/* Token name or expression */
			char *str;
			struct _t *next;
			int token;			/* token number */
			unsigned char classname;	/* is it a err/tok class name or token */
			TCnode *tclass;		/* ptr to token class */
			char *action;
            char *akaString;
		} TermEntry;

typedef struct _r {				/* Rule name and ptr to start of rule */
			char *str;
			struct _t *next;
			int rulenum;		/* RulePtr[rulenum]== ptr to RuleBlk junction */
			unsigned char noAST;/* gen AST construction code? (def==gen code) */
			char *egroup;		/* which error group (err reporting stuff) */
			ListNode *el_labels;/* list of element labels ref in all of rule */
            unsigned char has_rule_exception;
            char dontComputeErrorSet;    /* MR14 - don't compute error set
                                          special for rule in alpha part of
                                          (alpha)? beta block */
		} RuleEntry;

typedef struct _f {				/* cache Fi/Fo set */
			char *str;			/* key == (rulename, computation, k) */
			struct _f *next;
			set fset;			/* First/Follow of rule */
			set rk;				/* set of k's remaining to be done after ruleref */
			int incomplete;		/* only w/FOLLOW sets.  Use only if complete */
		} CacheEntry;

typedef struct _LabelEntry {	/* element labels */
			char *str;
			struct _f *next;
			Node *elem;			/* which element does it point to? */
			ExceptionGroup *ex_group;
								/* Is there an exception attached to label? */
            ExceptionGroup *outerEG;                                 /* MR7 */
                                /* next EG if ex_group doesn't catch it MR7 */
            struct _LabelEntry  *pendingLink;                        /* MR7 */
                                /* too lazy to use ListNode ?           MR7 */
            int     curAltNum;                                       /* MR7 */
		} LabelEntry;

typedef struct _SignalEntry {
			char *str;
			struct _f *next;
			int signum;			/* unique signal number */
		} SignalEntry;

typedef struct _PredEntry {				/* MR11 predicate name and ptr to string */
			char              *str;
            struct _PredEntry *next;
            int               file;
            int               line;
            Predicate         *pred;
            char              *predLiteral;
		} PredEntry;

typedef struct _PointerStack {      /* MR10 */
        int     count;
        int     size;
        void    **data;
        } PointerStack;

#define newTermEntry(s)		(TermEntry *) newEntry(s, sizeof(TermEntry))
#define newRuleEntry(s)		(RuleEntry *) newEntry(s, sizeof(RuleEntry))
#define newCacheEntry(s)	(CacheEntry *) newEntry(s, sizeof(CacheEntry))
#define newLabelEntry(s)	(LabelEntry *) newEntry(s, sizeof(LabelEntry))
#define newSignalEntry(s)	(SignalEntry *) newEntry(s, sizeof(SignalEntry))
#define newPredEntry(s)     (PredEntry *) newEntry(s,sizeof(PredEntry))

typedef struct _UserAction {
			char *action;
			int file, line;
		} UserAction;


					/* L e x i c a l  C l a s s */

/* to switch lex classes, switch ExprStr and Texpr (hash table) */
typedef struct _lc {
			char *classnum, **exprs;
			Entry **htable;
		} LClass;

typedef struct _exprOrder {
			char *expr;
			int lclass;
		} Expr;


typedef Graph Attrib;

						/* M a x i m u m s */

/* MR20 Note G. Hobbelt These values are superceded by values in hash.h */

#ifndef HashTableSize
#define HashTableSize	253
#endif
#ifndef StrTableSize
#define StrTableSize	15000	/* all tokens, nonterminals, rexprs stored here */
#endif
#define MaxLexClasses	50		/* how many automatons */
/* TokenStart and EofToken are ignored if #tokdefs meta-op is used */
#define TokenStart		2		/* MUST be in 1 + EofToken */
#define EofToken		1		/* Always predefined to be 1 */

#ifndef MaxNumFiles
#define MaxNumFiles		99
#endif

/**** MR9 JVincent@novell.com  Move to pcctscfg.h */
/**** #define MaxFileName		300	****/ /* MR9  Move to pcctscfg.h */ /* largest file name size */

#define MaxRuleName		100		/* largest rule name size */
#define TSChunk			100		/* how much to expand TokenStr/ExprStr each time */
#define TIChunk			TSChunk	/* expand TokenInd by same as TokenStr to mirror them */
#define FoStackSize		100		/* deepest FOLLOW recursion possible */

#define MaxClassDeclStuff   256    /* MR10 */

#define NumPredefinedSignals 3

           /* S t a n d a r d  S i g n a l s */

#define sigNoSignal				0
#define sigMismatchedToken		1
#define sigNoViableAlt			2
#define sigNoSemViableAlt		3



/* AST token types */
#define ASTexclude		0
#define ASTchild		1
#define ASTroot			2
#define ASTinclude		3		/* include subtree made by rule ref */


#define PredictionVariable				"zzpr_expr"
#define PredictionLexClassSuffix		"_zzpred"

#define WildCardString					"WildCard"

#if 0
    /*  Removed in version 1.33MR19
        Don't understand why this never caused problems before
    */

////	#ifndef ANTLRm
////	#define ANTLRm(st, f, _m)	zzbufsize = ZZLEXBUFSIZE;\
////						zzmode(_m);					\
////						zzenterANTLR(f);			\
////						st; ++zzasp;				\
////						zzleaveANTLR(f);
////	#endif						

#endif

#include "proto.h"
#include "pcctscfg.h"   /* MR14 */
#include <string.h>
