/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef ARTSMIDI_H
#define ARTSMIDI_H

#include "common.h"

namespace Arts {
enum MidiCommandStatus {mcsCommandMask = 240, mcsChannelMask = 15, mcsNoteOff = 128, mcsNoteOn = 144, mcsKeyPressure = 160, mcsParameter = 176, mcsProgram = 192, mcsChannelPressure = 208, mcsPitchWheel = 224};
enum MidiClientDirection {mcdPlay = 0, mcdRecord = 1};
enum MidiClientType {mctDestination = 0, mctApplication = 1};
};
namespace Arts {
class TimeStamp : public Arts::Type {
public:
	TimeStamp();
	TimeStamp(long _a_sec, long _a_usec);
	TimeStamp(Arts::Buffer& stream);
	TimeStamp(const TimeStamp& copyType);
	TimeStamp& operator=(const TimeStamp& assignType);
	long sec;
	long usec;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class MidiCommand : public Arts::Type {
public:
	MidiCommand();
	MidiCommand(Arts::mcopbyte _a_status, Arts::mcopbyte _a_data1, Arts::mcopbyte _a_data2);
	MidiCommand(Arts::Buffer& stream);
	MidiCommand(const MidiCommand& copyType);
	MidiCommand& operator=(const MidiCommand& assignType);
	Arts::mcopbyte status;
	Arts::mcopbyte data1;
	Arts::mcopbyte data2;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class MidiEvent : public Arts::Type {
public:
	MidiEvent();
	MidiEvent(const Arts::TimeStamp& _a_time, const Arts::MidiCommand& _a_command);
	MidiEvent(Arts::Buffer& stream);
	MidiEvent(const MidiEvent& copyType);
	MidiEvent& operator=(const MidiEvent& assignType);
	Arts::TimeStamp time;
	Arts::MidiCommand command;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class MidiClientInfo : public Arts::Type {
public:
	MidiClientInfo();
	MidiClientInfo(long _a_ID, const std::vector<long>& _a_connections, Arts::MidiClientDirection _a_direction, Arts::MidiClientType _a_type, const std::string& _a_title, const std::string& _a_autoRestoreID);
	MidiClientInfo(Arts::Buffer& stream);
	MidiClientInfo(const MidiClientInfo& copyType);
	MidiClientInfo& operator=(const MidiClientInfo& assignType);
	long ID;
	std::vector<long> connections;
	Arts::MidiClientDirection direction;
	Arts::MidiClientType type;
	std::string title;
	std::string autoRestoreID;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

};
namespace Arts {
class MidiPort;
class MidiClient;
class MidiManager;
class MidiTest;
class RawMidiPort;

class MidiPort_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static MidiPort_base *_create(const std::string& subClass = "Arts::MidiPort");
	static MidiPort_base *_fromString(std::string objectref);
	static MidiPort_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline MidiPort_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::TimeStamp time() = 0;
	virtual void processCommand(const Arts::MidiCommand& command) = 0;
	virtual void processEvent(const Arts::MidiEvent& event) = 0;
};

class MidiPort_stub : virtual public MidiPort_base, virtual public Arts::Object_stub {
protected:
	MidiPort_stub();

public:
	MidiPort_stub(Arts::Connection *connection, long objectID);

	Arts::TimeStamp time();
	void processCommand(const Arts::MidiCommand& command);
	void processEvent(const Arts::MidiEvent& event);
};

class MidiPort_skel : virtual public MidiPort_base, virtual public Arts::Object_skel {
public:
	MidiPort_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MidiPort : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MidiPort_base *_cache;
	inline MidiPort_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MidiPort_base *)_pool->base->_cast(MidiPort_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MidiPort(MidiPort_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MidiPort_base _base_class;

	inline MidiPort() : Arts::Object(_Creator), _cache(0) {}
	inline MidiPort(const Arts::SubClass& s) :
		Arts::Object(MidiPort_base::_create(s.string())), _cache(0) {}
	inline MidiPort(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MidiPort_base::_fromString(r.string())):(MidiPort_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MidiPort(const Arts::DynamicCast& c) : Arts::Object(MidiPort_base::_fromString(c.object().toString())), _cache(0) {}
	inline MidiPort(const MidiPort& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MidiPort(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MidiPort null() {return MidiPort((MidiPort_base*)0);}
	inline static MidiPort _from_base(MidiPort_base* b) {return MidiPort(b);}
	inline MidiPort& operator=(const MidiPort& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline MidiPort_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::TimeStamp time();
	inline void processCommand(const Arts::MidiCommand& command);
	inline void processEvent(const Arts::MidiEvent& event);
};

class MidiClient_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static MidiClient_base *_create(const std::string& subClass = "Arts::MidiClient");
	static MidiClient_base *_fromString(std::string objectref);
	static MidiClient_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline MidiClient_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::MidiClientInfo info() = 0;
	virtual std::string title() = 0;
	virtual void title(const std::string& newValue) = 0;
	virtual void addInputPort(Arts::MidiPort port) = 0;
	virtual Arts::MidiPort addOutputPort() = 0;
	virtual void removePort(Arts::MidiPort port) = 0;
};

class MidiClient_stub : virtual public MidiClient_base, virtual public Arts::Object_stub {
protected:
	MidiClient_stub();

public:
	MidiClient_stub(Arts::Connection *connection, long objectID);

	Arts::MidiClientInfo info();
	std::string title();
	void title(const std::string& newValue);
	void addInputPort(Arts::MidiPort port);
	Arts::MidiPort addOutputPort();
	void removePort(Arts::MidiPort port);
};

class MidiClient_skel : virtual public MidiClient_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void title_changed(const std::string& newValue) {
		_emit_changed("title_changed",newValue);
	}

public:
	MidiClient_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MidiClient : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MidiClient_base *_cache;
	inline MidiClient_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MidiClient_base *)_pool->base->_cast(MidiClient_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MidiClient(MidiClient_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MidiClient_base _base_class;

	inline MidiClient() : Arts::Object(_Creator), _cache(0) {}
	inline MidiClient(const Arts::SubClass& s) :
		Arts::Object(MidiClient_base::_create(s.string())), _cache(0) {}
	inline MidiClient(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MidiClient_base::_fromString(r.string())):(MidiClient_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MidiClient(const Arts::DynamicCast& c) : Arts::Object(MidiClient_base::_fromString(c.object().toString())), _cache(0) {}
	inline MidiClient(const MidiClient& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MidiClient(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MidiClient null() {return MidiClient((MidiClient_base*)0);}
	inline static MidiClient _from_base(MidiClient_base* b) {return MidiClient(b);}
	inline MidiClient& operator=(const MidiClient& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline MidiClient_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::MidiClientInfo info();
	inline std::string title();
	inline void title(const std::string& _newValue);
	inline void addInputPort(Arts::MidiPort port);
	inline Arts::MidiPort addOutputPort();
	inline void removePort(Arts::MidiPort port);
};

class MidiManager_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static MidiManager_base *_create(const std::string& subClass = "Arts::MidiManager");
	static MidiManager_base *_fromString(std::string objectref);
	static MidiManager_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline MidiManager_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::vector<Arts::MidiClientInfo> * clients() = 0;
	virtual Arts::MidiClient addClient(Arts::MidiClientDirection direction, Arts::MidiClientType type, const std::string& title, const std::string& autoRestoreID) = 0;
	virtual void connect(long clientID, long destinationID) = 0;
	virtual void disconnect(long clientID, long destinationID) = 0;
};

class MidiManager_stub : virtual public MidiManager_base, virtual public Arts::Object_stub {
protected:
	MidiManager_stub();

public:
	MidiManager_stub(Arts::Connection *connection, long objectID);

	std::vector<Arts::MidiClientInfo> * clients();
	Arts::MidiClient addClient(Arts::MidiClientDirection direction, Arts::MidiClientType type, const std::string& title, const std::string& autoRestoreID);
	void connect(long clientID, long destinationID);
	void disconnect(long clientID, long destinationID);
};

class MidiManager_skel : virtual public MidiManager_base, virtual public Arts::Object_skel {
public:
	MidiManager_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MidiManager : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MidiManager_base *_cache;
	inline MidiManager_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MidiManager_base *)_pool->base->_cast(MidiManager_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MidiManager(MidiManager_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MidiManager_base _base_class;

	inline MidiManager() : Arts::Object(_Creator), _cache(0) {}
	inline MidiManager(const Arts::SubClass& s) :
		Arts::Object(MidiManager_base::_create(s.string())), _cache(0) {}
	inline MidiManager(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MidiManager_base::_fromString(r.string())):(MidiManager_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MidiManager(const Arts::DynamicCast& c) : Arts::Object(MidiManager_base::_fromString(c.object().toString())), _cache(0) {}
	inline MidiManager(const MidiManager& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MidiManager(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MidiManager null() {return MidiManager((MidiManager_base*)0);}
	inline static MidiManager _from_base(MidiManager_base* b) {return MidiManager(b);}
	inline MidiManager& operator=(const MidiManager& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline MidiManager_base* _base() {return _cache?_cache:_method_call();}

	inline std::vector<Arts::MidiClientInfo> * clients();
	inline Arts::MidiClient addClient(Arts::MidiClientDirection direction, Arts::MidiClientType type, const std::string& title, const std::string& autoRestoreID);
	inline void connect(long clientID, long destinationID);
	inline void disconnect(long clientID, long destinationID);
};

class MidiTest_base : virtual public Arts::MidiPort_base {
public:
	static unsigned long _IID; // interface ID

	static MidiTest_base *_create(const std::string& subClass = "Arts::MidiTest");
	static MidiTest_base *_fromString(std::string objectref);
	static MidiTest_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline MidiTest_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class MidiTest_stub : virtual public MidiTest_base, virtual public Arts::MidiPort_stub {
protected:
	MidiTest_stub();

public:
	MidiTest_stub(Arts::Connection *connection, long objectID);

};

class MidiTest_skel : virtual public MidiTest_base, virtual public Arts::MidiPort_skel {
public:
	MidiTest_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MidiTest : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MidiTest_base *_cache;
	inline MidiTest_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MidiTest_base *)_pool->base->_cast(MidiTest_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MidiTest(MidiTest_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MidiTest_base _base_class;

	inline MidiTest() : Arts::Object(_Creator), _cache(0) {}
	inline MidiTest(const Arts::SubClass& s) :
		Arts::Object(MidiTest_base::_create(s.string())), _cache(0) {}
	inline MidiTest(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MidiTest_base::_fromString(r.string())):(MidiTest_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MidiTest(const Arts::DynamicCast& c) : Arts::Object(MidiTest_base::_fromString(c.object().toString())), _cache(0) {}
	inline MidiTest(const MidiTest& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MidiTest(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MidiTest null() {return MidiTest((MidiTest_base*)0);}
	inline static MidiTest _from_base(MidiTest_base* b) {return MidiTest(b);}
	inline MidiTest& operator=(const MidiTest& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::MidiPort() const { return Arts::MidiPort(*_pool); }
	inline MidiTest_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::TimeStamp time();
	inline void processCommand(const Arts::MidiCommand& command);
	inline void processEvent(const Arts::MidiEvent& event);
};

class RawMidiPort_base : virtual public Arts::MidiPort_base {
public:
	static unsigned long _IID; // interface ID

	static RawMidiPort_base *_create(const std::string& subClass = "Arts::RawMidiPort");
	static RawMidiPort_base *_fromString(std::string objectref);
	static RawMidiPort_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline RawMidiPort_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string device() = 0;
	virtual void device(const std::string& newValue) = 0;
	virtual bool input() = 0;
	virtual void input(bool newValue) = 0;
	virtual bool output() = 0;
	virtual void output(bool newValue) = 0;
	virtual bool running() = 0;
	virtual void running(bool newValue) = 0;
	virtual bool open() = 0;
};

class RawMidiPort_stub : virtual public RawMidiPort_base, virtual public Arts::MidiPort_stub {
protected:
	RawMidiPort_stub();

public:
	RawMidiPort_stub(Arts::Connection *connection, long objectID);

	std::string device();
	void device(const std::string& newValue);
	bool input();
	void input(bool newValue);
	bool output();
	void output(bool newValue);
	bool running();
	void running(bool newValue);
	bool open();
};

class RawMidiPort_skel : virtual public RawMidiPort_base, virtual public Arts::MidiPort_skel {
protected:
	// emitters for change notifications
	inline void device_changed(const std::string& newValue) {
		_emit_changed("device_changed",newValue);
	}
	inline void input_changed(bool newValue) {
		_emit_changed("input_changed",newValue);
	}
	inline void output_changed(bool newValue) {
		_emit_changed("output_changed",newValue);
	}
	inline void running_changed(bool newValue) {
		_emit_changed("running_changed",newValue);
	}

public:
	RawMidiPort_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class RawMidiPort : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	RawMidiPort_base *_cache;
	inline RawMidiPort_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(RawMidiPort_base *)_pool->base->_cast(RawMidiPort_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline RawMidiPort(RawMidiPort_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef RawMidiPort_base _base_class;

	inline RawMidiPort() : Arts::Object(_Creator), _cache(0) {}
	inline RawMidiPort(const Arts::SubClass& s) :
		Arts::Object(RawMidiPort_base::_create(s.string())), _cache(0) {}
	inline RawMidiPort(const Arts::Reference &r) :
		Arts::Object(r.isString()?(RawMidiPort_base::_fromString(r.string())):(RawMidiPort_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline RawMidiPort(const Arts::DynamicCast& c) : Arts::Object(RawMidiPort_base::_fromString(c.object().toString())), _cache(0) {}
	inline RawMidiPort(const RawMidiPort& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline RawMidiPort(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static RawMidiPort null() {return RawMidiPort((RawMidiPort_base*)0);}
	inline static RawMidiPort _from_base(RawMidiPort_base* b) {return RawMidiPort(b);}
	inline RawMidiPort& operator=(const RawMidiPort& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::MidiPort() const { return Arts::MidiPort(*_pool); }
	inline RawMidiPort_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::TimeStamp time();
	inline void processCommand(const Arts::MidiCommand& command);
	inline void processEvent(const Arts::MidiEvent& event);
	inline std::string device();
	inline void device(const std::string& _newValue);
	inline bool input();
	inline void input(bool _newValue);
	inline bool output();
	inline void output(bool _newValue);
	inline bool running();
	inline void running(bool _newValue);
	inline bool open();
};

// Forward wrapper calls to _base classes:

inline Arts::TimeStamp Arts::MidiPort::time()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->time():static_cast<Arts::MidiPort_base*>(_method_call())->time();
}

inline void Arts::MidiPort::processCommand(const Arts::MidiCommand& command)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processCommand(command):static_cast<Arts::MidiPort_base*>(_method_call())->processCommand(command);
}

inline void Arts::MidiPort::processEvent(const Arts::MidiEvent& event)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processEvent(event):static_cast<Arts::MidiPort_base*>(_method_call())->processEvent(event);
}

inline Arts::MidiClientInfo Arts::MidiClient::info()
{
	return _cache?static_cast<Arts::MidiClient_base*>(_cache)->info():static_cast<Arts::MidiClient_base*>(_method_call())->info();
}

inline std::string Arts::MidiClient::title()
{
	return _cache?static_cast<Arts::MidiClient_base*>(_cache)->title():static_cast<Arts::MidiClient_base*>(_method_call())->title();
}

inline void Arts::MidiClient::title(const std::string& _newValue)
{
	 _cache?static_cast<Arts::MidiClient_base*>(_cache)->title(_newValue):static_cast<Arts::MidiClient_base*>(_method_call())->title(_newValue);
}

inline void Arts::MidiClient::addInputPort(Arts::MidiPort port)
{
	 _cache?static_cast<Arts::MidiClient_base*>(_cache)->addInputPort(port):static_cast<Arts::MidiClient_base*>(_method_call())->addInputPort(port);
}

inline Arts::MidiPort Arts::MidiClient::addOutputPort()
{
	return _cache?static_cast<Arts::MidiClient_base*>(_cache)->addOutputPort():static_cast<Arts::MidiClient_base*>(_method_call())->addOutputPort();
}

inline void Arts::MidiClient::removePort(Arts::MidiPort port)
{
	 _cache?static_cast<Arts::MidiClient_base*>(_cache)->removePort(port):static_cast<Arts::MidiClient_base*>(_method_call())->removePort(port);
}

inline std::vector<Arts::MidiClientInfo> * Arts::MidiManager::clients()
{
	return _cache?static_cast<Arts::MidiManager_base*>(_cache)->clients():static_cast<Arts::MidiManager_base*>(_method_call())->clients();
}

inline Arts::MidiClient Arts::MidiManager::addClient(Arts::MidiClientDirection direction, Arts::MidiClientType type, const std::string& title, const std::string& autoRestoreID)
{
	return _cache?static_cast<Arts::MidiManager_base*>(_cache)->addClient(direction, type, title, autoRestoreID):static_cast<Arts::MidiManager_base*>(_method_call())->addClient(direction, type, title, autoRestoreID);
}

inline void Arts::MidiManager::connect(long clientID, long destinationID)
{
	 _cache?static_cast<Arts::MidiManager_base*>(_cache)->connect(clientID, destinationID):static_cast<Arts::MidiManager_base*>(_method_call())->connect(clientID, destinationID);
}

inline void Arts::MidiManager::disconnect(long clientID, long destinationID)
{
	 _cache?static_cast<Arts::MidiManager_base*>(_cache)->disconnect(clientID, destinationID):static_cast<Arts::MidiManager_base*>(_method_call())->disconnect(clientID, destinationID);
}

inline Arts::TimeStamp Arts::MidiTest::time()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->time():static_cast<Arts::MidiPort_base*>(_method_call())->time();
}

inline void Arts::MidiTest::processCommand(const Arts::MidiCommand& command)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processCommand(command):static_cast<Arts::MidiPort_base*>(_method_call())->processCommand(command);
}

inline void Arts::MidiTest::processEvent(const Arts::MidiEvent& event)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processEvent(event):static_cast<Arts::MidiPort_base*>(_method_call())->processEvent(event);
}

inline Arts::TimeStamp Arts::RawMidiPort::time()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->time():static_cast<Arts::MidiPort_base*>(_method_call())->time();
}

inline void Arts::RawMidiPort::processCommand(const Arts::MidiCommand& command)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processCommand(command):static_cast<Arts::MidiPort_base*>(_method_call())->processCommand(command);
}

inline void Arts::RawMidiPort::processEvent(const Arts::MidiEvent& event)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processEvent(event):static_cast<Arts::MidiPort_base*>(_method_call())->processEvent(event);
}

inline std::string Arts::RawMidiPort::device()
{
	return _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->device():static_cast<Arts::RawMidiPort_base*>(_method_call())->device();
}

inline void Arts::RawMidiPort::device(const std::string& _newValue)
{
	 _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->device(_newValue):static_cast<Arts::RawMidiPort_base*>(_method_call())->device(_newValue);
}

inline bool Arts::RawMidiPort::input()
{
	return _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->input():static_cast<Arts::RawMidiPort_base*>(_method_call())->input();
}

inline void Arts::RawMidiPort::input(bool _newValue)
{
	 _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->input(_newValue):static_cast<Arts::RawMidiPort_base*>(_method_call())->input(_newValue);
}

inline bool Arts::RawMidiPort::output()
{
	return _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->output():static_cast<Arts::RawMidiPort_base*>(_method_call())->output();
}

inline void Arts::RawMidiPort::output(bool _newValue)
{
	 _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->output(_newValue):static_cast<Arts::RawMidiPort_base*>(_method_call())->output(_newValue);
}

inline bool Arts::RawMidiPort::running()
{
	return _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->running():static_cast<Arts::RawMidiPort_base*>(_method_call())->running();
}

inline void Arts::RawMidiPort::running(bool _newValue)
{
	 _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->running(_newValue):static_cast<Arts::RawMidiPort_base*>(_method_call())->running(_newValue);
}

inline bool Arts::RawMidiPort::open()
{
	return _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->open():static_cast<Arts::RawMidiPort_base*>(_method_call())->open();
}

};
#endif /* ARTSMIDI_H */
