// -*- c++ -*-
//  Generated by gtkmmproc from ./../clock.gen_h -- DO NOT MODIFY!
#ifndef _GNOMEMM_CLOCK_H
#define _GNOMEMM_CLOCK_H

/* $Id: clock.gen_h,v 1.7 2001/02/08 19:31:28 murrayc Exp $ */


/* clock.gen_h
 *
 * Copyright (C) 1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/label.h>
#include <libgnomeui/gtk-clock.h>

namespace Gtk {
class Clock;
class Clock_Class;
}
namespace Gtk { Gtk::Clock *wrap (GtkClock *o); }
namespace Gtk
{
//: A small text clock widget.
//- The GtkClock widget provides an easy way of providing a textual
//- clock in your application. It supports realtime display, as well as count
//- up and count down modes. The clock widget could conceivably be used in
//- such applications as an application's status bar, or as the basis for
//- a panel applet, etc.
//-
//- Three modes of operation are supported. These are realtime - which
//- displays the current time, count-up/increasing - which counts up from an
//- initial value (like a stopwatch), and count-down/decreasing - which
//- counts down from an initial value.
//-
//- Note, however, that the accuracy of the gtkclock widget is limited
//- to 1 second.
class Clock : public Label
{

public:
  typedef Clock          CppObjectType;
  typedef Clock_Class    CppClassType;
  typedef GtkClock           BaseObjectType;
  typedef GtkClockClass      BaseClassType;

private:
  friend class Clock_Class;
  static CppClassType clock_class;

  Clock(const Clock&);
  Clock& operator=(const Clock&); // not implemented

protected:
  void   initialize_class();
  explicit Clock(GtkClock *castitem);

public:
  static GtkType get_type();
  GtkClock* gtkobj()             { return (GtkClock*)(gtkobject); }
  const GtkClock* gtkobj() const { return (GtkClock*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~Clock();

private:

public:
  enum Type
    {
      INCREASING = GTK_CLOCK_INCREASING,
      DECREASING = GTK_CLOCK_DECREASING,
      REALTIME   = GTK_CLOCK_REALTIME
    };

  Clock(Type type = REALTIME);



  //: Set the  of a GtkClock widget.
  //- The syntax of the
  //- string is identical to that of the function strftime(3). Further
  //- information about time  strings can be found on this man
  //- page. The widget defaults to a  string of "%H:%M" in
  //- realtime mode, or "%H:%M:%S" in count-up or count-down
  //- modes.

  void set_format(const Gtk::string& fmt);

  //: Set the current time as displayed by the clock.
  //- Works only in count-up and
  //- count-down modes. This function has no effect in realtime
  //- mode, as the clock time is determined by the system clock in
  //- realtime mode.

  void set_seconds(time_t seconds);

  //: Set the interval at which the GtkClock widget is updated.
  //- The seconds parameter is used to determine how often the time
  //- shown on the widget is updated. The default value is to update
  //- every second, but you may wish to increase this value. If you set
  //- the update interval to 0, the clock is never updated.

  void set_update_interval(gint seconds);

  //: Start the clock counting.
  //- The clock will begin counting up or down from the time when this
  //- function is called, until gtk_clock_stop is called. This function
  //- has no effect in the realtime mode.

  void start();

  //: Stop the clock counting.
  //- The clock ceases counting up or down, and the last time reached
  //- remains on the display. This function has no effect in the realtime
  //- mode (you can't start and stop real time! :-).

  void stop();

public:

protected:
  // impl functions

};

}


#endif
