/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimpdrawable_pdb.h
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#ifndef __GIMP_DRAWABLE_PDB_H__
#define __GIMP_DRAWABLE_PDB_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* For information look into the C source or the html documentation */


gboolean      gimp_drawable_merge_shadow    (gint32         drawable_ID,
					     gboolean       undo);
gboolean      gimp_drawable_fill            (gint32         drawable_ID,
					     GimpFillType   fill_type);
gboolean      gimp_drawable_update          (gint32         drawable_ID,
					     gint           x,
					     gint           y,
					     gint           width,
					     gint           height);
gboolean      gimp_drawable_mask_bounds     (gint32         drawable_ID,
					     gint          *x1,
					     gint          *y1,
					     gint          *x2,
					     gint          *y2);
gint32        gimp_drawable_image           (gint32         drawable_ID);
GimpImageType gimp_drawable_type            (gint32         drawable_ID);
gboolean      gimp_drawable_has_alpha       (gint32         drawable_ID);
GimpImageType gimp_drawable_type_with_alpha (gint32         drawable_ID);
gboolean      gimp_drawable_is_rgb          (gint32         drawable_ID);
gboolean      gimp_drawable_is_gray         (gint32         drawable_ID);
gboolean      gimp_drawable_is_indexed      (gint32         drawable_ID);
gint          gimp_drawable_bytes           (gint32         drawable_ID);
gint          gimp_drawable_width           (gint32         drawable_ID);
gint          gimp_drawable_height          (gint32         drawable_ID);
gboolean      gimp_drawable_offsets         (gint32         drawable_ID,
					     gint          *offset_x,
					     gint          *offset_y);
gboolean      gimp_drawable_is_layer        (gint32         drawable_ID);
gboolean      gimp_drawable_is_layer_mask   (gint32         drawable_ID);
gboolean      gimp_drawable_is_channel      (gint32         drawable_ID);
gboolean      _gimp_drawable_thumbnail      (gint32         drawable_ID,
					     gint           width,
					     gint           height,
					     gint          *ret_width,
					     gint          *ret_height,
					     gint          *bpp,
					     gint          *thumbnail_data_count,
					     guint8       **thumbnail_data);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GIMP_DRAWABLE_PDB_H__ */
