Please read the README file in this directory first.
.ex
.Id $Id: procmail.man,v 1.89 2001/06/28 22:43:08 guenther Exp $
.TH PROCMAIL 1 \*(Dt BuGless
.na
.SH NAME
procmail \- autonomous mail processor
.SH SYNOPSIS
.B procmail
.RB [ \-@PRESERVOPT@@TEMPFAILOPT@@OVERRIDEOPT@@BERKELEYOPT@ ]
.RB [ "\-@FROMWHOPT@ \fIfromwhom\fP" ]
.if n .ti +0.5i
.RI [ "parameter\fB=\fPvalue " | " rcfile" ]
\&.\|.\|.
.br
.B procmail
.RB [ \-@TEMPFAILOPT@@OVERRIDEOPT@@BERKELEYOPT@ ]
.RB [ "\-@FROMWHOPT@ \fIfromwhom\fP" ]
.RB [ "\-@ARGUMENTOPT@ \fIargument\fP" ]
\&.\|.\|.
.if n .ti +0.5i
.B \-@DELIVEROPT@
.I recipient
\&.\|.\|.
.br
.B procmail
.RB [ \-@PRESERVOPT@@TEMPFAILOPT@@BERKELEYOPT@ ]
.B \-@MAILFILTOPT@
.RI [ "parameter\fB=\fPvalue" ]
\&.\|.\|.
.I rcfile
.if n .ti +0.5i
.RI [ argument ]
\&.\|.\|.@LMTPusage@.br
.B procmail
.B \-@VERSIONOPT@
.ad
.SH DESCRIPTION
For a quick start, see
.B NOTES
at the end.
.PP
.B Procmail
should be invoked automatically over the
.B @DOT_FORWARD@
file mechanism as soon as mail arrives.  Alternatively, when installed by
a system administrator, it can be invoked from within the mailer immediately.
When invoked, it first sets some environment variables to default values,
reads the mail message from stdin until an EOF, separates the body from the
header, and then, if no command line arguments are present, it starts to look
for a file named
.BR @PROCMAILRC@ .
According to the processing recipes in this file,
the mail message that just arrived gets distributed into the right folder
(and more).  If no rcfile is found, or processing of the rcfile falls off
the end, procmail will store the mail in the default system
mailbox.@ETCRC_desc@
.PP
If running suid root or with root privileges, procmail will be able to
perform as a functionally enhanced, backwards compatible mail delivery agent.
.PP
Procmail can also be used as a general purpose mail filter, i.e., provisions
have been made to enable procmail to be invoked in a special sendmail rule.
.PP
The rcfile format is described in detail in the
.BR procmailrc (5)
man page.
.PP
The weighted scoring technique is described in detail in the
.BR procmailsc (5)
man page.
.PP
Examples for rcfile recipes can be looked up in the
.BR procmailex (5)
man page.
.SS Signals
.TP 1.2i
.B TERMINATE
Terminate prematurely and requeue the mail.
.TP
.B HANGUP
Terminate prematurely and bounce the mail.
.TP
.B INTERRUPT
Terminate prematurely and bounce the mail.
.TP
.B QUIT
Terminate prematurely and silently lose the mail.
.TP
.B ALARM
Force a timeout (see
.BR TIMEOUT).
.TP
.B USR1
Equivalent to a
.BR VERBOSE =off.
.TP
.B USR2
Equivalent to a
.BR VERBOSE =on.
.SH OPTIONS
.TP 0.5i
.B \-@VERSIONOPT@
Procmail will print its version number, display its compile time
configuration and exit.
.TP
.B \-@PRESERVOPT@
Preserve any old environment.  Normally procmail clears the environment
upon startup@KEEPENV@.  However, in any case: any default values will override
any preexisting environment variables, i.e., procmail will not pay any attention
to any predefined environment variables, it will happily overwrite them
with its own defaults.  For the list of environment variables that procmail
will preset see the
.BR procmailrc (5)
man page.  If both \-@PRESERVOPT@ and \-@MAILFILTOPT@ are specified, the
list of preset environment variables shrinks to just: LOGNAME, HOME, SHELL,
ORGMAIL and MAILDIR.
.TP
.B \-@TEMPFAILOPT@
Make procmail fail softly, i.e., if procmail cannot deliver the mail to
any of the destinations you gave, the mail will not bounce, but will return
to the mailqueue.  Another delivery-attempt will be made at some time in
the future.
.TP
.I "\fB\-@FROMWHOPT@\fP fromwhom"
Causes procmail to regenerate the leading `@FROM@' line with
.I fromwhom
as the sender (instead of \-@FROMWHOPT@ one could use the alternate and
obsolete \-@ALTFROMWHOPT@).  If
.I fromwhom
consists merely of a single `@REFRESH_TIME@', then procmail will only
update the timestamp on the `@FROM@' line (if present, if not, it will
generate a new one).
.TP
.B \-@OVERRIDEOPT@
Instead of allowing anyone to generate `@FROM@' lines, simply override
the fakes.
.TP
.B \-@BERKELEYOPT@
Assume traditional Berkeley mailbox format, ignore any
.B Content-Length:
fields.
.TP
.I "\fB\-@ARGUMENTOPT@\fP argument"
This will set $1 to be equal to
.IR argument .
Each succeeding
.I "\fB\-@ARGUMENTOPT@\fP argument"
will set the next number variable ($2, $3, etc).  It can be used
to pass meta information along to procmail.  This is typically done
by passing along the $@x information from the sendmail mailer rule.
.TP
.I "\fB\-@DELIVEROPT@\fP recipient .\|.\|."
This turns on explicit delivery mode, delivery will be to the local user
.IR recipient .
This, of course, only is possible if procmail has root
privileges@SETRUID@.
Procmail will setuid to the intended recipients and delivers the mail as
if it were invoked by the recipient with no arguments (i.e., if no rcfile
is found, delivery is like ordinary mail).  This option is incompatible with
.BR \-@PRESERVOPT@ .
.TP
.B \-@MAILFILTOPT@
Turns procmail into a general purpose mail filter.  In this mode one rcfile
must be specified on the command line.  After the rcfile, procmail will
accept an unlimited number of arguments.@ETCRCS_desc@
For some advanced usage of this option you should look in the
.B EXAMPLES
section below.@LMTPOPTdesc@.SH ARGUMENTS
Any arguments containing an '=' are considered to be environment variable
assignments, they will
.I all
be evaluated after the default values have been
assigned and before the first rcfile is opened.
.PP
Any other arguments are presumed to be rcfile paths (either absolute,
or if they start with `@chCURDIR@@MCDIRSEP@' relative to the current
directory;
.B any other relative
path is relative to $HOME, unless the
.B \-@MAILFILTOPT@
option has been given, in which case all relative paths are relative to the
current directory); procmail will start with the first one it finds on the
command line.  The following ones will only be parsed if the preceding ones
have a not matching HOST-directive entry, or in case they should not exist.
.PP
If no rcfiles are specified, it looks for
.BR @PROCMAILRC@ .
If not even that can be found, processing will continue according to
the default settings of the environment variables and the ones specified
on the command line.
.SH EXAMPLES
Examples for rcfile recipes can be looked up in the
.BR procmailex (5)
man page.
A small sample rcfile can be found in the
.B NOTES
section below.
.PP
Skip the rest of this EXAMPLES section unless you are a system administrator
who is vaguely familiar with sendmail.cf syntax.
.PP
The
.B \-@MAILFILTOPT@
option is typically used when procmail is called from within a rule in the
sendmail.cf file.  In order to be able to do this it is convenient to create
an extra `procmail' mailer in your sendmail.cf file (in addition to the perhaps
already present `local' mailer that starts up procmail).  To create such a
`procmail' mailer I'd suggest something like:
.Sx 2
Mprocmail, P=@BINDIR@/procmail, F=mSDFMhun, S=11, R=21,
        A=procmail \-@MAILFILTOPT@ $h $g $u
.Ex
This enables you to use rules like the following (most likely in ruleset 0)
to filter mail through the procmail mailer (please note the leading tab
to continue the rule, and the tab to separate the comments):
.Sx 4
R$*<@some.where>$*
        $#procmail $@/etc/procmailrcs/some.rc $:$1@some.where.procmail$2
R$*<@$*.procmail>$*
        $1<@$2>$3       Already filtered, map back
.Ex
And /etc/procmailrcs/some.rc could be as simple as:
.Sx 9
SENDER = "<$1>"                 # fix for empty sender addresses
SHIFT = 1                       # remove it from $@

:0                              # sink all junk mail
* ^Subject:.*junk
/dev/null

:0 w                            # pass along all other mail
! \-oi \-f "$SENDER" "$@"
.Ex
Do watch out when sending mail from within the /etc/procmailrcs/some.rc file,
if you send mail to addresses which match the first rule again, you could
be creating an endless mail loop.
.SH FILES
.TP 2.3i
.B /etc/passwd
to set the recipient's LOGNAME, HOME and SHELL variable defaults
.TP
.B @MAILSPOOLDIR@$LOGNAME
system mailbox; both the system mailbox and the immediate directory
it is in will be created every time procmail starts and either one is
not present@ETCRC_files@@ETCRCS_files@
.TP
.B @PROCMAILRC@
default rcfile
.TP
.B @MAILSPOOLDIR@$LOGNAME@DEFlockext@
lockfile for the system mailbox (not automatically used by procmail, unless
$DEFAULT equals @MAILSPOOLDIR@$LOGNAME and procmail is delivering to $DEFAULT)
.TP
.B @DEFsendmail@
default mail forwarder
.TP
.B @UNIQ_PREFIX@????`hostname`
temporary `unique' zero-length files created by procmail
.SH "SEE ALSO"
.na
.nh
.BR procmailrc (5),
.BR procmailsc (5),
.BR procmailex (5),
.BR sh (1),
.BR csh (1),
.BR mail (1),
.BR mailx (1),
.BR binmail (1),
.BR uucp (1),
.BR aliases (5),
.BR sendmail (8),
.BR egrep (1),
.BR grep (1),
.BR biff (1),
.BR comsat (8),
.BR lockfile (1),
.BR formail (1),
.BR cron (1)
.hy
.ad
.SH DIAGNOSTICS
.TP 2.3i
Autoforwarding mailbox found
The system mailbox had its suid or sgid bit set, procmail terminates with
EX_NOUSER assuming that this mailbox must not be delivered to.
.TP
Bad substitution of "x"
Not a valid environment variable name specified.
.TP
Closing brace unexpected
There was no corresponding opening brace (nesting block).
.TP
Conflicting options
Not all option combinations are useful
.TP
Conflicting x suppressed
Flag x is not compatible with some other flag on this recipe.
.TP
Couldn't create "x"
The system mailbox was missing and could not/will not be created.
.TP
Couldn't create maildir part "x"
The maildir folder "x" is missing one or more required subdirectories and
procmail could not create them.
.TP
Couldn't create or rename temp file "x"
An error occurred in the mechanics of  delivering to the directory folder "x".
.TP
Couldn't determine implicit lockfile from "x"
There were no `>>' redirectors to be found, using simply `$LOCKEXT' as
locallockfile.
.TP
Couldn't read "x"
Procmail was unable to open an rcfile or it was not a regular file, or
procmail couldn't open an MH directory to find the highest numbered file.
.TP
Couldn't unlock "x"
Lockfile was already gone, or write permission to the directory where the
lockfile is has been denied.
.TP
Deadlock attempted on "x"
The locallockfile specified on this recipe is equal to a still active
$LOCKFILE.@ETCRCS_error@
.TP
Descriptor "x" was not open
As procmail was started, stdin, stdout or stderr was not connected (possibly
an attempt to subvert security)
.TP
Enforcing stricter permissions on "x"
The system mailbox of the recipient was found to be unsecured, procmail
secured it.
.TP
Error while writing to "x"
Nonexistent subdirectory, no write permission, pipe died or disk full.
.TP
Exceeded LINEBUF
Buffer overflow detected, LINEBUF was too small, PROCMAIL_OVERFLOW has
been set.
.TP
MAILDIR is not an absolute path
.TP
MAILDIR path too long
.TP
ORGMAIL is not an absolute path
.TP
ORGMAIL path too long
.TP
default rcfile is not an absolute path
.TP
default rcfile path too long
The specified item's full path, when expanded, was longer than LINEBUF
or didn't start with a file separator.
.TP
Excessive output quenched from "x"
The program or filter "x" tried to produce too much output for the current
LINEBUF, the rest was discarded.
.TP
Extraneous x ignored
The action line or other flags on this recipe makes flag x meaningless.
.TP
Failed forking "x"
Process table is full (and NORESRETRY has been exhausted).
.TP
Failed to execute "x"
Program not in path, or not executable.
.TP
Forced unlock denied on "x"
No write permission in the directory where
.B lockfile
"x" resides, or more than one procmail trying to force a lock at exactly the
same time.
.TP
Forcing lock on "x"
.B Lockfile
"x" is going to be removed by force because of a timeout (see also:
.BR LOCKTIMEOUT ).
.TP
Incomplete recipe
The start of a recipe was found, but it stranded in an EOF.
.TP
Insufficient privileges
Procmail either needs root privileges, or must have the
right (e)uid
.B and
(e)gid to run in delivery mode.  The mail will bounce.
.TP
Invalid regexp "x"
The regular expression "x" contains errors (most likely some missing or
extraneous parens).
.TP
Kernel-lock failed
While trying to use the kernel-supported locking calls, one of them failed
(usually indicates an OS error), procmail ignores this error and proceeds.
.TP
Kernel-unlock failed
See above.
.TP
Lock failure on "x"
Can only occur if you specify some real weird (and illegal) lockfilenames
or if the
.B lockfile
could not be created because of insufficient permissions or nonexistent
subdirectories.
.TP
Lost "x"
Procmail tried to clone itself but could not find back rcfile "x" (it either
got removed or it was a relative path and you changed directory since
procmail opened it last time).
.TP
Missing action
The current recipe was found to be incomplete.
.TP
Missing closing brace
A nesting block was started, but never finished.
.TP
Missing name
The \-@FROMWHOPT@ option needs an extra argument.
.TP
Missing argument
You specified the \-@ARGUMENTOPT@ option but forgot the argument.
.TP
Missing rcfile
You specified the \-@MAILFILTOPT@ option, procmail expects the name of an
rcfile as argument.
.TP
Missing recipient
You specified the \-@DELIVEROPT@ option or called procmail under a different
name, it expects one or more recipients as arguments.@WARN_RESTRICT_EXEC@
.TP
No space left to finish writing "x"
The filesystem containing "x" does not have enough free space to permit
delivery of the message to the file.
.TP
Out of memory
The system is out of swap space (and NORESRETRY has been exhausted).
.TP
Processing continued
The unrecognised options on the command line are ignored, proceeding as
usual.
.TP
Program failure (nnn) of "x"
Program that was started by procmail returned nnn instead of
EXIT_SUCCESS (=@EX_OK@);
if nnn is negative, then this is the signal the program died on.
.TP
Quota exceeded while writing "x"
The filesize quota for the recipient on the filesystem containing "x"
does not permit delivering the message to the file.
.TP
Renaming bogus "x" into "x"
The system mailbox of the recipient was found to be bogus, procmail performed
evasive actions.
.TP
Rescue of unfiltered data succeeded/failed
A filter returned unsuccessfully, procmail tried to get back the original text.
.TP
Skipped: "x"
Couldn't do anything with "x" in the rcfile (syntax error), ignoring it.
.TP
Suspicious rcfile "x"
The owner of the rcfile was not the recipient or root, the file was
world writable, or the directory that contained it was world writable,
or this was the default rcfile (@PROCMAILRC@) and either it was group
writable or the directory that contained it was group writable (the
rcfile was not used).
.TP
Terminating prematurely whilst waiting for .\|.\|.
Procmail received a signal while it was waiting for .\|.\|.
.TP
Timeout, terminating "x"
Timeout has occurred on program or filter "x".
.TP
Timeout, was waiting for "x"
Timeout has occurred on program, filter or file "x".  If it was a program or
filter, then it didn't seem to be running anymore.
.TP
Truncated file to former size
The file could not be delivered to successfully, so the file was truncated
to its former size.
.TP
Truncating "x" and retrying lock
"x" does not seem to be a valid filename or the file is not empty.
.TP
Unable to treat as directory "x"
Either the suffix on "x" would indicate that it should be an MH or
maildir folder, or it was listed as an second folder into which to link,
but it already exists and is not a directory.
.TP
Unexpected EOL
Missing closing quote, or trying to escape EOF.
.TP
Unknown user "x"
The specified recipient does not have a corresponding uid.
.SH "EXTENDED DIAGNOSTICS"
Extended diagnostics can be turned on and off through setting the
VERBOSE variable.
.TP 2.3i
[pid] time & date
Procmail's pid and a timestamp.  Generated whenever procmail logs a
diagnostic and at least a second has elapsed since the last timestamp.
.TP
Acquiring kernel-lock
Procmail now tries to kernel-lock the most recently opened file (descriptor).
.TP
Assigning "x"
Environment variable assignment.
.TP
Assuming identity of the recipient, VERBOSE=off
Dropping all privileges (if any), implicitly turns off extended diagnostics.
.TP
Bypassed locking "x"
The mail spool directory was not accessible to procmail, it relied solely
on kernel locks.
.TP
Executing "x"
Starting program "x".  If it is started by procmail directly (without an
intermediate shell), procmail will show where it separated the arguments
by inserting commas.
.TP
HOST mismatched "x"
This host was called "x", HOST contained something else.
.TP
Locking "x"
Creating lockfile "x".
.TP
Linking to "x"
Creating a hardlink between directory folders.
.TP
Match on "x"
Condition matched.
.TP
Matched "x"
Assigned "x" to
.BR @MATCHVAR@ .
.TP
No match on "x"
Condition didn't match, recipe skipped.
.TP
Non-zero exitcode (nnn) by "x"
Program that was started by procmail as a condition or as the action of
a recipe with the `@WAIT_EXIT_QUIET@' flag returned nnn instead of
EXIT_SUCCESS (=@EX_OK@); the usage indicates that this is not an
entirely unexpected condition.
.TP
Notified comsat: "$LOGNAME@offset:file"
Sent comsat/biff a notice that mail arrived for user $LOGNAME at `offset'
in `file'.
.TP
Opening "x"
Opening file "x" for appending.
.TP
Rcfile: "x"
Rcfile changed to "x".
.TP
Reiterating kernel-lock
While attempting several locking methods, one of these failed.  Procmail will
reiterate until they all succeed in rapid succession.
.TP
Score: added newtotal "x"
This condition scored `added' points, which resulted in a `newtotal' score.
.TP
Unlocking "x"
Removing lockfile "x" again.
.SH WARNINGS
You should create a shell script that uses
.BR lockfile (1)
before invoking your mail shell on any mailbox file other than the system
mailbox (unless of course, your mail shell uses the same lockfiles (local
or global) you specified in your rcfile).
.PP
In the unlikely event that you absolutely need to kill procmail before it has
finished, first try and use the regular kill command (i.e.,
.I not
kill \-9, see the subsection
.I Signals
for suggestions), otherwise some
.I lockfiles
might not get removed.
.PP
Beware when using the
.B \-@TEMPFAILOPT@
option, if procmail repeatedly is unable to deliver the mail (e.g., due to
an incorrect rcfile), the system mailqueue could fill up.  This could
aggravate both the local postmaster and other users.@ETCRC_warn@@ETCRCS_warn@
.PP
Procmail is not the proper tool for sharing one mailbox among many
users, such as when you have one POP account for all mail to your
domain. It can be done if you manage to configure your MTA to add some
headers with the envelope recipient data in order to tell Procmail who
a message is for, but this is usually not the right thing to do.
Perhaps you want to investigate if your MTA offers `virtual user
tables', or see check out the `multidrop' facility of Fetchmail.
.SH BUGS
After removing a lockfile by force, procmail waits $SUSPEND seconds before
creating a new lockfile so that another process that decides to remove the
stale lockfile will not remove the newly created lock by mistake.
.PP
Procmail uses the regular TERMINATE signal to terminate any runaway filter,
but it does not check if the filter responds to that signal and it only sends
it to the filter itself, not to any of the filter's children.
.PP
A continued
.B Content-Length:
field is not handled correctly.
.PP
The embedded newlines in a continued header should be skipped when
matching instead of being treated as a single space as they are now.
.SH MISCELLANEOUS
If there is an existing
.B Content-Length:
field in the header of the mail and the
.B \-@BERKELEYOPT@
option is not specified, procmail will trim the field to report the correct
size.  Procmail does not change the fieldwidth.
.PP
If there is no
.B Content-Length:
field or the
.B \-@BERKELEYOPT@
option has been specified and procmail appends to regular mailfolders, any
lines in the body of the message that look like postmarks are prepended with
`@ESCAP@' (disarms bogus mailheaders).  The regular expression that is used
to search for these postmarks is:
.RS
`@FROM_EXPR@'
.RE
.PP
If the destination name used in explicit delivery mode is not in /etc/passwd,
procmail will proceed as if explicit delivery mode was not in effect.
If not in explicit delivery mode and
should the uid procmail is running under, have no corresponding /etc/passwd
entry, then HOME will default to @ROOT_DIR@, LOGNAME will default to the
numeric uid, SHELL will default to @BinSh@, and ORGMAIL will default to
@DEAD_LETTER@.
.PP
When in explicit delivery mode, procmail will generate a leading `@FROM@'
line if none is present.  If one is already present procmail will leave it
intact.@TRUSTED_IDS@
.PP
For security reasons procmail will only use an absolute or
$HOME-relative rcfile if it is owned by the recipient or root, not
world writable, and the directory it is contained in is not world
writable.  The @PROCMAILRC@ file has the additional constraint of not
being group-writable or in a group-writable directory.@RESTRICT_EXEC@
.PP
If @MAILSPOOLDIR@$LOGNAME is a bogus mailbox (i.e., does not belong to the
recipient, is unwritable, is a symbolic link or is a hard link), procmail will
upon startup try to rename it into a file starting
with `@BOGUSprefix@$LOGNAME.' and
ending in an inode-sequence-code.  If this turns out to be impossible,
.B ORGMAIL
will have
.I no
initial value, and hence will inhibit delivery without a proper rcfile.
.PP
If @MAILSPOOLDIR@$LOGNAME already is a valid mailbox, but has got too loose
permissions on it, procmail will correct this.  To prevent procmail from doing
this make sure the u+x bit is set.
.PP
When delivering to directories, MH folders, or maildir folders, you
.B don't
need to use lockfiles to prevent several concurrently running procmail
programs from messing up.
.PP
Delivering to MH folders is slightly more time consuming than delivering
to normal directories or mailboxes, because procmail has to search for
the next available number (instead of having the filename immediately
available).
.PP
On general failure procmail will return EX_CANTCREAT, unless option
.B \-@TEMPFAILOPT@
is specified, in which case it will return EX_TEMPFAIL.
.PP
To make `egrepping' of headers more consistent, procmail concatenates all
continued header fields; but only internally.  When delivering the mail, line
breaks will appear as before.
.PP
If procmail is called under a name not starting with `procmail' (e.g., if it
is linked to another name and invoked as such), it comes up in explicit
delivery mode, and expects the recipients' names as command line arguments
(as if \-@DELIVEROPT@ had been specified).
.PP
Comsat/biff notifications are done using @COMSATprotocol@.  They are sent off
once when procmail generates the regular logfile entry.  The notification
messages have the following extended format (or as close as you can get when
final delivery was not to a file):
.RS
$LOGNAME@offset_of_message_in_mailbox@COMSATxtrsep@absolute_path_to_mailbox
.RE
.PP
Whenever procmail itself opens a file to deliver to, it
@KERNEL_LOCKING@.
.PP
Procmail is NFS-resistant and eight-bit clean.
.br
.ne 11
.SH NOTES
Calling up procmail with the \-@HELPOPT1@ or \-@HELPOPT2@ options will cause
it to display a command-line help and recipe flag quick-reference page.
.PP
There exists an excellent newbie FAQ about mailfilters (and procmail
in particular); it is being maintained by Nancy McGough <nancym@ii.com>
and can be obtained by sending a mail to mail-server@rtfm.mit.edu with
the following in the body:
.RS
send usenet/news.answers/mail/filtering-faq
.RE
.PP
@CF_procmail@
In this case your $HOME/@DOT_FORWARD@ (beware, it
.B has
to be world readable) file should contain the line below.  Be sure to include
the single and double quotes, and unless you know your site to be running
smrsh (the SendMail Restricted SHell), it must be an
.I absolute
path.@FW_comment@
.PP
.na
.nf
@FW_content@
.fi
.ad
.PP
Procmail can also be invoked to postprocess an already filled system
mailbox.  This can be useful if you don't want to or can't use a
$HOME/@DOT_FORWARD@ file (in which case the following script could
periodically be called from within
.BR cron (1),
or whenever you start reading mail):
.Sx 17
#!/bin/sh

ORGMAIL=@MAILSPOOLDIR@$LOGNAME

if cd $HOME &&
 test \-s $ORGMAIL &&
 lockfile \-r0 \-l@DEFlocktimeout@ .newmail.lock 2>/dev/null
then
  trap "rm \-f .newmail.lock" 1 2 3 13 15
  umask 077
  lockfile \-l@DEFlocktimeout@ \-ml
  cat $ORGMAIL >>.newmail &&
   cat /dev/null >$ORGMAIL
  lockfile \-mu
  formail \-@FM_SPLIT@ procmail <.newmail &&
   rm \-f .newmail
  rm \-f .newmail.lock
fi
exit 0
.Ex
.ne 14
.SS "A sample small @PROCMAILRC@:"
.na
.nf
PATH=/bin:/usr/bin:@BINDIR@
MAILDIR=$HOME/Mail      #you'd better make sure it exists
DEFAULT=$MAILDIR/mbox   #completely optional
LOGFILE=$MAILDIR/from   #recommended

:0:
* ^From.*berg
from_me

:0
* ^Subject:.*Flame
/dev/null
.fi
.ad
.PP
Other examples for rcfile recipes can be looked up in the
.BR procmailex (5)
man page.
