/* $XConsortium: xf86Xinput.h /main/11 1996/10/27 11:05:29 kaleb $ */
/*
 * Copyright 1995-1998 by Frederic Lepied, France. <Frederic.Lepied@sugix.frmug.org>
 *                                                                            
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is  hereby granted without fee, provided that
 * the  above copyright   notice appear  in   all  copies and  that both  that
 * copyright  notice   and   this  permission   notice  appear  in  supporting
 * documentation, and that   the  name of  Frederic   Lepied not  be  used  in
 * advertising or publicity pertaining to distribution of the software without
 * specific,  written      prior  permission.     Frederic  Lepied   makes  no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.                   
 *                                                                            
 * FREDERIC  LEPIED DISCLAIMS ALL   WARRANTIES WITH REGARD  TO  THIS SOFTWARE,
 * INCLUDING ALL IMPLIED   WARRANTIES OF MERCHANTABILITY  AND   FITNESS, IN NO
 * EVENT  SHALL FREDERIC  LEPIED BE   LIABLE   FOR ANY  SPECIAL, INDIRECT   OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA  OR PROFITS, WHETHER  IN  AN ACTION OF  CONTRACT,  NEGLIGENCE OR OTHER
 * TORTIOUS  ACTION, ARISING    OUT OF OR   IN  CONNECTION  WITH THE USE    OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */

/* $XFree86: xc/programs/Xserver/hw/xfree86/common/xf86Xinput.h,v 3.14.2.5 1999/10/21 12:07:51 hohndel Exp $ */

#ifndef _xf86Xinput_h
#define _xf86Xinput_h

#ifndef NEED_EVENTS
#define NEED_EVENTS
#endif
#include "X.h"
#include "Xproto.h"
#include "inputstr.h"
#include "XI.h"
#include "XIproto.h"
#include "XIstubs.h"

#define XI86_NO_OPEN_ON_INIT    1 /* open the device only when needed */
#define XI86_CONFIGURED         2 /* the device has been configured */
#define XI86_ALWAYS_CORE	4 /* the device always controls the pointer */

#ifdef PRIVATE
#undef PRIVATE
#endif
#define PRIVATE(dev) (((LocalDevicePtr)((dev)->public.devicePrivate))->private)

#ifdef HAS_MOTION_HISTORY
#undef HAS_MOTION_HISTORY
#endif
#define HAS_MOTION_HISTORY(local) ((local)->dev->valuator && (local)->dev->valuator->numMotionEvents)

typedef struct _LocalDeviceRec {  
  char		*name;
  int           flags;
  Bool		(*device_config)(
#if NeedNestedPrototypes
    struct _LocalDeviceRec** /*array*/,
    int /*index*/,
    int /*max*/,
    LexPtr /*val*/
#endif
    );
  Bool		(*device_control)(
#if NeedNestedPrototypes
    DeviceIntPtr /*device*/,
    int /*what*/
#endif
    );
  void		(*read_input)(
#if NeedNestedPrototypes
    struct _LocalDeviceRec* /*local*/
#endif
    );
  int           (*control_proc)(
#if NeedNestedPrototypes
    struct _LocalDeviceRec* /*local*/,
    xDeviceCtl* /* control */
#endif
    );
  void          (*close_proc)(
#if NeedNestedPrototypes
    struct _LocalDeviceRec* /*local*/
#endif
    );
  int           (*switch_mode)(
#if NeedNestedPrototypes
    ClientPtr /*client*/,
    DeviceIntPtr /*dev*/,
    int /*mode*/
#endif
    );
  Bool           (*conversion_proc)(
#if NeedNestedPrototypes
    struct _LocalDeviceRec* /*local*/,
    int	/* first */,
    int /* num */,
    int /* v0 */,
    int /* v1 */,
    int /* v2 */,
    int /* v3 */,
    int /* v4 */,
    int /* v5 */,
    int* /* x */,
    int* /* y */
#endif
    );
    int			fd;
    Atom		atom;
    DeviceIntPtr	dev;
    pointer		private;
    int			private_flags;
    pointer		motion_history;
    ValuatorMotionProcPtr motion_history_proc;
    unsigned int	history_size;	/* only for configuration purpose */
    unsigned int	first;
    unsigned int	last;
    int			old_x;
    int			old_y;
    char		*type_name;
    IntegerFeedbackPtr	always_core_feedback;
    Bool           (*reverse_conversion_proc)(
#if NeedNestedPrototypes
    struct _LocalDeviceRec* /*local*/,
    int /* x */,
    int /* y */,
    int* /* valuators */
#endif
    );
    float	         dxremaind;
    float		 dyremaind;
 } LocalDeviceRec, *LocalDevicePtr;

typedef struct _DeviceAssocRec 
{
  char                  *config_section_name;
  LocalDevicePtr        (*device_allocate)(
#if NeedNestedPrototypes
    void
#endif
);
} DeviceAssocRec, *DeviceAssocPtr;

extern int
xf86IsCorePointer(
#if NeedFunctionPrototypes
	      DeviceIntPtr /*dev*/
#endif
);

extern int
xf86IsCoreKeyboard(
#if NeedFunctionPrototypes
	       DeviceIntPtr /*dev*/
#endif
);

extern void
xf86AlwaysCore(
#if NeedFunctionPrototypes
	       LocalDevicePtr	/*local*/,
	       Bool		/*always*/
#endif
);

void
xf86configExtendedInputSection(
#ifdef NeedFunctionPrototypes
		LexPtr          /* val */
#endif
);

void
xf86AddDeviceAssoc(
#ifdef NeedFunctionPrototypes
		DeviceAssocPtr	/* assoc */
#endif
);

void
InitExtInput(
#ifdef NeedFunctionPrototypes
		void
#endif
);

Bool
xf86eqInit (
#ifdef NeedFunctionPrototypes
		DevicePtr       /* pKbd */,
		DevicePtr       /* pPtr */
#endif
);

void
xf86eqEnqueue (
#ifdef NeedFunctionPrototypes
		struct _xEvent * /*event */
#endif
);

void
xf86eqProcessInputEvents (
#ifdef NeedFunctionPrototypes
		void
#endif
);

void
xf86PostMotionEvent(
#if NeedVarargsPrototypes
		DeviceIntPtr	/*device*/,
		int		/*is_absolute*/,
		int		/*first_valuator*/,
		int		/*num_valuators*/,
		...
#endif		
);

void
xf86PostProximityEvent(
#if NeedVarargsPrototypes
		   DeviceIntPtr	/*device*/,
		   int		/*is_in*/,
		   int		/*first_valuator*/,
		   int		/*num_valuators*/,
		   ...
#endif
);

void
xf86PostButtonEvent(
#if NeedVarargsPrototypes
		DeviceIntPtr	/*device*/,
		int		/*is_absolute*/,
		int		/*button*/,
		int		/*is_down*/,
		int		/*first_valuator*/,
		int		/*num_valuators*/,
		...
#endif
);

void
xf86PostKeyEvent(
#if NeedVarargsPrototypes
		 DeviceIntPtr	device,
		 unsigned int	key_code,
		 int		is_down,
		 int		is_absolute,
		 int		first_valuator,
		 int		num_valuators,
		 ...
#endif
);

void
xf86AddDeviceAssoc(
#if NeedFunctionPrototypes
		DeviceAssocPtr	/*assoc*/
#endif
);

void
xf86MotionHistoryAllocate(
#if NeedFunctionPrototypes
		      LocalDevicePtr	local
#endif
);

int
xf86GetMotionEvents(
#if NeedFunctionPrototypes
		    DeviceIntPtr	dev,
		    xTimecoord		*buff,
		    unsigned long	start,
		    unsigned long	stop,
		    ScreenPtr		pScreen
#endif
);

void
xf86XinputFinalizeInit(
#if NeedFunctionPrototypes
		       DeviceIntPtr	dev
#endif
);

Bool
xf86CheckButton(
#if NeedFunctionPrototypes
		int	button,
		int	down
#endif
);

void
xf86SwitchCoreDevice(
#if NeedFunctionPrototypes
		LocalDevicePtr	device,
		DeviceIntPtr	core
#endif
);

void
xf86DisableInputDevices(
#if NeedFunctionPrototypes
		void
#endif
);

void
xf86EnableInputDevices(
#if NeedFunctionPrototypes
		void
#endif
);

#endif /* _xf86Xinput_h */
