/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.IOException;
import java.net.URL;
import sun.net.www.MessageHeader;

public abstract class URLConnection
extends java.net.URLConnection {
    private String contentType;
    private int contentLength = -1;
    protected MessageHeader properties = new MessageHeader();

    public URLConnection(URL uRL) {
        super(uRL);
    }

    public MessageHeader getProperties() {
        return this.properties;
    }

    public void setProperties(MessageHeader messageHeader) {
        this.properties = messageHeader;
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.properties.set(string, string2);
    }

    public String getHeaderField(String string) {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
        return this.properties == null ? null : this.properties.findValue(string);
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
        MessageHeader messageHeader = this.properties;
        return messageHeader == null ? null : messageHeader.getKey(n);
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
        MessageHeader messageHeader = this.properties;
        return messageHeader == null ? null : messageHeader.getValue(n);
    }

    public String getContentType() {
        if (this.contentType == null) {
            this.contentType = this.getHeaderField("content-type");
        }
        if (this.contentType == null) {
            String string = null;
            try {
                string = java.net.URLConnection.guessContentTypeFromStream(this.getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string2 = this.properties.findValue("content-encoding");
            if (string == null && (string = this.properties.findValue("content-type")) == null) {
                string = this.url.getFile().endsWith("/") ? "text/html" : java.net.URLConnection.guessContentTypeFromName(this.url.getFile());
            }
            if (string == null || string2 != null && !string2.equalsIgnoreCase("7bit") && !string2.equalsIgnoreCase("8bit") && !string2.equalsIgnoreCase("binary")) {
                string = "content/unknown";
            }
            this.contentType = string;
        }
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public int getContentLength() {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return -1;
        }
        int n = this.contentLength;
        if (n < 0) {
            try {
                this.contentLength = n = Integer.parseInt(this.properties.findValue("content-length"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    protected void setContentLength(int n) {
        this.contentLength = n;
    }

    public boolean canCache() {
        return this.url.getFile().indexOf(63) < 0;
    }

    public void close() {
        this.url = null;
    }
}

