/*
 * Decompiled with CFR 0.152.
 */
package sun.net.nntp;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.net.nntp.NntpProtocolException;

class NntpInputStream
extends FilterInputStream {
    int column = 0;
    boolean eofOccurred = false;

    public NntpInputStream(InputStream inputStream) {
        super(inputStream);
    }

    int eof() {
        this.eofOccurred = true;
        return -1;
    }

    public int read() throws IOException {
        if (this.eofOccurred) {
            return -1;
        }
        int n = super.read();
        if (n == 46 && this.column == 0) {
            n = super.read();
            if (n == 10) {
                return this.eof();
            }
            if (n != 46) {
                throw new NntpProtocolException("Expecting '.' - got " + n);
            }
        }
        this.column = n == 10 ? 0 : ++this.column;
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        while (--n2 >= 0) {
            int n4 = this.read();
            if (n4 == -1) break;
            byArray[n++] = (byte)n4;
        }
        return n > n3 ? n - n3 : -1;
    }

    public void close() {
    }
}

