/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import sun.java2d.OutputManager;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.AlphaColorPipe;
import sun.java2d.pipe.AlphaPaintPipe;
import sun.java2d.pipe.CompositePipe;
import sun.java2d.pipe.DrawToFillConverter;
import sun.java2d.pipe.DuctusShapeRenderer;
import sun.java2d.pipe.GeneralCompositePipe;
import sun.java2d.pipe.LineStylePipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeToPolyConverter;
import sun.java2d.pipe.SimpleRenderPipe;
import sun.java2d.pipe.SpanClipRenderer;
import sun.java2d.pipe.TranslateablePipe;

public abstract class SunOutputManager
implements OutputManager {
    private static CompositePipe generalpipe = new GeneralCompositePipe();
    private static CompositePipe paintpipe = new AlphaPaintPipe();
    static final int NON_UNIFORM_SCALE_MASK = 36;

    public void validatePipe(SunGraphics2D sunGraphics2D) {
        SunOutputManager.constructAlphaPipe(sunGraphics2D);
        SunOutputManager.constructGenericPipe(sunGraphics2D);
    }

    public Object renderImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, Color color, int n, int n2, int n3, int n4, byte[] byArray, int n5, Object object) {
        new Exception().printStackTrace();
        return null;
    }

    public void drawString(SunGraphics2D sunGraphics2D, int n, String string, float f, float f2, float f3, float[] fArray, Font font, boolean bl, boolean bl2) {
        throw new NoSuchMethodError("must be implemented in child class");
    }

    public static void constructAlphaPipe(SunGraphics2D sunGraphics2D) {
        CompositePipe compositePipe;
        if (sunGraphics2D.compositeState == 3) {
            compositePipe = generalpipe;
        } else if (sunGraphics2D.paintState == 2) {
            compositePipe = paintpipe;
        } else {
            compositePipe = sunGraphics2D.getOutputManager().getColorPipe();
            if (compositePipe == null) {
                compositePipe = paintpipe;
            }
        }
        sunGraphics2D.alphapipe = compositePipe;
    }

    public static void constructGenericPipe(SunGraphics2D sunGraphics2D) {
        PixelToShapeConverter pixelToShapeConverter;
        CompositePipe compositePipe = sunGraphics2D.alphapipe;
        if (sunGraphics2D.clipState == 2) {
            sunGraphics2D.getCompBounds();
            compositePipe = new SpanClipRenderer(compositePipe, sunGraphics2D.clipRegion);
        }
        DuctusShapeRenderer ductusShapeRenderer = new DuctusShapeRenderer(compositePipe);
        PixelToShapeConverter pixelToShapeConverter2 = pixelToShapeConverter = new PixelToShapeConverter(ductusShapeRenderer);
        PixelToShapeConverter pixelToShapeConverter3 = pixelToShapeConverter;
        sunGraphics2D.drawpipe = pixelToShapeConverter2;
        sunGraphics2D.fillpipe = pixelToShapeConverter3;
        sunGraphics2D.shapepipe = ductusShapeRenderer;
    }

    public static void constructAliasedPipe(SunGraphics2D sunGraphics2D, SimpleRenderPipe simpleRenderPipe) {
        int n;
        int n2;
        boolean bl;
        if (simpleRenderPipe instanceof TranslateablePipe) {
            boolean bl2 = bl = sunGraphics2D.transformState == 2;
            if (sunGraphics2D.transformState == 1) {
                n2 = sunGraphics2D.transX;
                n = sunGraphics2D.transY;
            } else {
                n = 0;
                n2 = 0;
            }
            ((TranslateablePipe)((Object)simpleRenderPipe)).setOrigin(n2, n);
        } else {
            bl = sunGraphics2D.transformState != 0;
        }
        ShapeDrawPipe shapeDrawPipe = simpleRenderPipe instanceof ShapeDrawPipe ? (ShapeDrawPipe)((Object)simpleRenderPipe) : new ShapeToPolyConverter(simpleRenderPipe, bl);
        PixelFillPipe pixelFillPipe = !bl && simpleRenderPipe instanceof PixelFillPipe ? (PixelFillPipe)((Object)simpleRenderPipe) : new PixelToShapeConverter(shapeDrawPipe);
        if (!(sunGraphics2D.stroke instanceof BasicStroke)) {
            n = 1;
            n2 = 1;
        } else {
            boolean bl3;
            if ((sunGraphics2D.transform.getType() & 0x24) != 0) {
                bl3 = false;
            } else {
                BasicStroke basicStroke = (BasicStroke)sunGraphics2D.stroke;
                float f = (float)Math.sqrt(Math.abs(sunGraphics2D.transform.getDeterminant()));
                float f2 = basicStroke.getLineWidth();
                float[] fArray = basicStroke.getDashArray();
                if (simpleRenderPipe instanceof LineStylePipe) {
                    bl3 = true;
                    ((LineStylePipe)((Object)simpleRenderPipe)).setLineAttrs(f, f2, fArray, basicStroke.getDashPhase(), basicStroke.getEndCap(), basicStroke.getLineJoin());
                } else {
                    bl3 = f * f2 <= 1.0f && fArray == null;
                }
            }
            int n3 = n2 = !bl3 || bl ? 1 : 0;
            if (simpleRenderPipe instanceof ShapeDrawPipe) {
                n = 0;
                if (bl3) {
                    shapeDrawPipe = new ShapeToPolyConverter(simpleRenderPipe, shapeDrawPipe, bl);
                }
            } else {
                int n4 = n = !bl3 ? 1 : 0;
            }
        }
        if (n != 0) {
            shapeDrawPipe = new DrawToFillConverter(simpleRenderPipe, shapeDrawPipe, true);
        }
        PixelDrawPipe pixelDrawPipe = n2 == 0 && simpleRenderPipe instanceof PixelDrawPipe ? (PixelDrawPipe)((Object)simpleRenderPipe) : new PixelToShapeConverter(shapeDrawPipe);
        sunGraphics2D.drawpipe = pixelDrawPipe;
        sunGraphics2D.fillpipe = pixelFillPipe;
        sunGraphics2D.shapepipe = shapeDrawPipe;
    }

    public abstract AlphaColorPipe getColorPipe();

    public abstract ColorModel getPreferredModel(ColorModel var1, Raster var2, AlphaComposite var3, Color var4, boolean var5);

    public abstract Object copyArea(SunGraphics2D var1, byte[] var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, Object var11);
}

