/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.peer.ScrollbarPeer;
import sun.awt.SunToolkit;
import sun.awt.motif.MComponentPeer;

class MScrollbarPeer
extends MComponentPeer
implements ScrollbarPeer {
    boolean inUpCall = false;

    native void create(MComponentPeer var1);

    MScrollbarPeer(Scrollbar scrollbar) {
        super(scrollbar);
    }

    native void pSetValues(int var1, int var2, int var3, int var4);

    public native void setLineIncrement(int var1);

    public native void setPageIncrement(int var1);

    public Dimension getMinimumSize() {
        if (((Scrollbar)this.target).getOrientation() == 1) {
            return new Dimension(18, 50);
        }
        return new Dimension(50, 18);
    }

    void doUpCall(int n, int n2) {
        final Scrollbar scrollbar = (Scrollbar)this.target;
        final int n3 = n;
        final int n4 = n2;
        SunToolkit.executeOnEventHandlerThread(scrollbar, new Runnable(){

            public void run() {
                MScrollbarPeer.this.inUpCall = true;
                scrollbar.setValue(n3);
                MScrollbarPeer.this.notifyValueChanged(n3, n4);
                MScrollbarPeer.this.inUpCall = false;
            }
        });
    }

    public void lineUp(int n) {
        this.doUpCall(n, 2);
    }

    public void lineDown(int n) {
        this.doUpCall(n, 1);
    }

    public void pageUp(int n) {
        this.doUpCall(n, 3);
    }

    public void pageDown(int n) {
        this.doUpCall(n, 4);
    }

    public void dragAbsolute(int n) {
        this.doUpCall(n, 5);
    }

    public void print(Graphics graphics) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        Dimension dimension = scrollbar.size();
        Color color = scrollbar.getBackground();
        boolean bl = scrollbar.getOrientation() == 0;
        this.drawScrollbar(graphics, color, bl ? dimension.height : dimension.width, bl ? dimension.width : dimension.height, scrollbar.getMinimum(), scrollbar.getMaximum(), scrollbar.getValue(), scrollbar.getVisible(), bl);
        this.target.print(graphics);
    }

    public void setValues(int n, int n2, int n3, int n4) {
        if (!this.inUpCall) {
            this.pSetValues(n, n2, n3, n4);
        }
    }

    void notifyValueChanged(int n, int n2) {
        this.postEvent(new AdjustmentEvent((Scrollbar)this.target, 601, n2, n));
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }
}

