/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Shape;
import java.awt.peer.MenuBarPeer;
import sun.awt.X11GraphicsConfig;
import sun.awt.motif.MFramePeer;
import sun.awt.motif.MMenuItemPeer;
import sun.awt.motif.MToolkit;

public class MMenuBarPeer
implements MenuBarPeer {
    long pData;
    MenuBar target;
    private X11GraphicsConfig graphicsConfig = null;
    private boolean disposed = false;
    static final int GAP = 10;
    static final int W_DIFF = 12;
    static final int H_DIFF = 23;

    private static native void initIDs();

    native void create(MFramePeer var1);

    public MMenuBarPeer(MenuBar menuBar) {
        this.target = menuBar;
        MFramePeer mFramePeer = (MFramePeer)MToolkit.targetToPeer(MMenuItemPeer.getParent_NoClientCode(menuBar));
        this.create(mFramePeer);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private native void pDispose();

    protected void disposeImpl() {
        MToolkit.targetDisposedPeer(this.target, this);
        this.pDispose();
    }

    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            MMenuBarPeer mMenuBarPeer = this;
            synchronized (mMenuBarPeer) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    public void addMenu(Menu menu) {
    }

    public void delMenu(int n) {
    }

    public void addHelpMenu(Menu menu) {
    }

    void print(Graphics graphics) {
        MenuBar menuBar = this.target;
        Frame frame = (Frame)MMenuItemPeer.getParent_NoClientCode(this.target);
        Dimension dimension = frame.size();
        Insets insets = frame.insets();
        Dimension dimension2 = new Dimension(dimension.width - 12, insets.top - 23);
        Shape shape = graphics.getClip();
        graphics.setClip(0, 0, dimension2.width, dimension2.height);
        Color color = frame.getBackground();
        Color color2 = frame.getForeground();
        Color color3 = color.brighter();
        Color color4 = color.darker();
        graphics.setColor(color3);
        graphics.drawLine(0, 0, dimension2.width, 0);
        graphics.drawLine(1, 1, dimension2.width - 1, 1);
        graphics.drawLine(0, 0, 0, dimension2.height);
        graphics.drawLine(1, 1, 1, dimension2.height - 1);
        graphics.setColor(color4);
        graphics.drawLine(dimension2.width, 1, dimension2.width, dimension2.height);
        graphics.drawLine(dimension2.width - 1, 2, dimension2.width - 1, dimension2.height);
        graphics.drawLine(1, dimension2.height, dimension2.width, dimension2.height);
        graphics.drawLine(2, dimension2.height - 1, dimension2.width, dimension2.height - 1);
        int n = 10;
        int n2 = menuBar.countMenus();
        Menu menu = this.target.getHelpMenu();
        int n3 = 0;
        while (n3 < n2) {
            Menu menu2 = this.target.getMenu(n3);
            String string = menu2.getLabel();
            if (string == null) {
                string = "";
            }
            Font font = menu2.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = dimension2.height / 2 + fontMetrics.getMaxDescent();
            int n5 = fontMetrics.stringWidth(string) + 20;
            if (n >= dimension2.width) break;
            if (menu2.isEnabled()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color4);
            }
            if (menu == menu2) {
                graphics.drawString(string, dimension2.width - n5 + 10, n4);
            } else {
                graphics.drawString(string, n, n4);
                n += n5;
            }
            ++n3;
        }
        graphics.setClip(shape);
    }

    static {
        MMenuBarPeer.initIDs();
    }
}

