/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import java.util.BitSet;
import java.util.Vector;
import javax.swing.text.html.parser.ContentModel;
import javax.swing.text.html.parser.ContentModelState;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.DTDConstants;
import javax.swing.text.html.parser.Element;
import javax.swing.text.html.parser.TagElement;

final class TagStack
implements DTDConstants {
    TagElement tag;
    Element elem;
    ContentModelState state;
    TagStack next;
    BitSet inclusions;
    BitSet exclusions;
    boolean net;
    boolean pre;

    TagStack(TagElement tagElement, TagStack tagStack) {
        this.tag = tagElement;
        this.elem = tagElement.getElement();
        this.next = tagStack;
        Element element = tagElement.getElement();
        if (element.getContent() != null) {
            this.state = new ContentModelState(element.getContent());
        }
        if (tagStack != null) {
            this.inclusions = tagStack.inclusions;
            this.exclusions = tagStack.exclusions;
            this.pre = tagStack.pre;
        }
        if (tagElement.isPreformatted()) {
            this.pre = true;
        }
        if (element.inclusions != null) {
            if (this.inclusions != null) {
                this.inclusions = (BitSet)this.inclusions.clone();
                this.inclusions.or(element.inclusions);
            } else {
                this.inclusions = element.inclusions;
            }
        }
        if (element.exclusions != null) {
            if (this.exclusions != null) {
                this.exclusions = (BitSet)this.exclusions.clone();
                this.exclusions.or(element.exclusions);
            } else {
                this.exclusions = element.exclusions;
            }
        }
    }

    public Element first() {
        return this.state != null ? this.state.first() : null;
    }

    public ContentModel contentModel() {
        if (this.state == null) {
            return null;
        }
        return this.state.getModel();
    }

    boolean excluded(int n) {
        return this.exclusions != null && this.exclusions.get(this.elem.getIndex());
    }

    boolean included(Vector vector, DTD dTD) {
        int n = 0;
        while (n < this.inclusions.size()) {
            if (this.inclusions.get(n)) {
                vector.addElement(dTD.getElement(n));
                System.out.println("Element add thru' inclusions: " + dTD.getElement(n).getName());
            }
            ++n;
        }
        return !vector.isEmpty();
    }

    boolean advance(Element element) {
        if (this.exclusions != null && this.exclusions.get(element.getIndex())) {
            return false;
        }
        if (this.state != null) {
            ContentModelState contentModelState = this.state.advance(element);
            if (contentModelState != null) {
                this.state = contentModelState;
                return true;
            }
        } else if (this.elem.getType() == 19) {
            return true;
        }
        return this.inclusions != null && this.inclusions.get(element.getIndex());
    }

    boolean terminate() {
        return this.state == null || this.state.terminate();
    }

    public String toString() {
        return this.next == null ? "<" + this.tag.getElement().getName() + ">" : this.next + " <" + this.tag.getElement().getName() + ">";
    }
}

