/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapVector;
import javax.swing.text.LayoutQueue;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class AsyncBoxView
extends View {
    int axis;
    ChildVector stats = new ChildVector();
    float majorSpan;
    float minorSpan;
    protected ChildLocator locator;
    float topInset;
    float bottomInset;
    float leftInset;
    float rightInset;
    ChildState minRequest;
    ChildState prefRequest;
    boolean majorChanged;
    boolean minorChanged;
    Runnable flushTask;
    ChildState changing;

    public AsyncBoxView(Element element, int n) {
        super(element);
        this.axis = n;
        this.locator = new ChildLocator();
        this.flushTask = new FlushTask();
        this.minorSpan = 32767.0f;
    }

    public int getMajorAxis() {
        return this.axis;
    }

    public int getMinorAxis() {
        return this.axis == 0 ? 1 : 0;
    }

    public float getTopInset() {
        return this.topInset;
    }

    public void setTopInset(float f) {
        this.topInset = f;
    }

    public float getBottomInset() {
        return this.bottomInset;
    }

    public void setBottomInset(float f) {
        this.bottomInset = f;
    }

    public float getLeftInset() {
        return this.leftInset;
    }

    public void setLeftInset(float f) {
        this.leftInset = f;
    }

    public float getRightInset() {
        return this.rightInset;
    }

    public void setRightInset(float f) {
        this.rightInset = f;
    }

    protected ChildState getChildState(int n) {
        ChildVector childVector = this.stats;
        synchronized (childVector) {
            ChildState childState = this.stats.getChildState(n);
            return childState;
        }
    }

    protected LayoutQueue getLayoutQueue() {
        return LayoutQueue.getDefaultQueue();
    }

    protected ChildState createChildState(View view) {
        return new ChildState(view);
    }

    protected synchronized void majorRequirementChange(ChildState childState, float f) {
        this.majorSpan += f;
        this.majorChanged = true;
    }

    protected synchronized void minorRequirementChange(ChildState childState) {
        this.minorChanged = true;
    }

    protected synchronized void flushRequirementChanges() {
        View view;
        if ((this.majorChanged || this.minorChanged) && (view = this.getParent()) != null) {
            boolean bl;
            boolean bl2;
            if (this.axis == 0) {
                bl2 = this.majorChanged;
                bl = this.minorChanged;
            } else {
                bl = this.majorChanged;
                bl2 = this.minorChanged;
            }
            view.preferenceChanged(this, bl2, bl);
            this.majorChanged = false;
            this.minorChanged = false;
            Container container = this.getContainer();
            if (container != null) {
                container.repaint();
            }
        }
    }

    public void replace(int n, int n2, View[] viewArray) {
        ChildVector childVector = this.stats;
        synchronized (childVector) {
            LayoutQueue layoutQueue = this.getLayoutQueue();
            ChildState[] childStateArray = new ChildState[viewArray.length];
            int n3 = 0;
            while (n3 < childStateArray.length) {
                childStateArray[n3] = this.createChildState(viewArray[n3]);
                ++n3;
            }
            this.stats.replace(n, n2, childStateArray);
            if (childStateArray.length != 0) {
                int n4 = 0;
                while (n4 < childStateArray.length) {
                    layoutQueue.addTask(childStateArray[n4]);
                    ++n4;
                }
                layoutQueue.addTask(this.flushTask);
            }
        }
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n > 0) {
            View[] viewArray = new View[n];
            int n2 = 0;
            while (n2 < n) {
                viewArray[n2] = viewFactory.create(element.getElement(n2));
                ++n2;
            }
            this.replace(0, 0, viewArray);
        }
    }

    protected synchronized int getViewIndexAtPosition(int n, Position.Bias bias) {
        boolean bl = bias == Position.Bias.Backward;
        n = bl ? Math.max(0, n - 1) : n;
        Element element = this.getElement();
        return element.getElementIndex(n);
    }

    protected void updateLayout(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape) {
        if (elementChange != null) {
            int n = Math.max(elementChange.getIndex() - 1, 0);
            ChildState childState = this.getChildState(n);
            this.locator.childChanged(childState);
        }
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null && this.getViewCount() == 0) {
            ViewFactory viewFactory = this.getViewFactory();
            this.loadChildren(viewFactory);
        }
    }

    public synchronized void preferenceChanged(View view, boolean bl, boolean bl2) {
        if (view == null) {
            this.getParent().preferenceChanged(this, bl, bl2);
        } else {
            View view2;
            if (this.changing != null && (view2 = this.changing.getChildView()) == view) {
                this.changing.preferenceChanged(bl, bl2);
                return;
            }
            int n = this.getViewIndexAtPosition(view.getStartOffset(), Position.Bias.Forward);
            ChildState childState = this.getChildState(n);
            childState.preferenceChanged(bl, bl2);
            LayoutQueue layoutQueue = this.getLayoutQueue();
            layoutQueue.addTask(childState);
            layoutQueue.addTask(this.flushTask);
        }
    }

    public void setSize(float f, float f2) {
        float f3 = this.axis == 0 ? f2 - this.getTopInset() - this.getBottomInset() : f - this.getLeftInset() - this.getRightInset();
        if (f3 != this.minorSpan) {
            this.minorSpan = f3;
            int n = this.getViewCount();
            LayoutQueue layoutQueue = this.getLayoutQueue();
            int n2 = 0;
            while (n2 < n) {
                ChildState childState = this.getChildState(n2);
                childState.childSizeValid = false;
                layoutQueue.addTask(childState);
                ++n2;
            }
            layoutQueue.addTask(this.flushTask);
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        ChildLocator childLocator = this.locator;
        synchronized (childLocator) {
            this.locator.setAllocation(shape);
            this.locator.paintChildren(graphics);
        }
    }

    public float getPreferredSpan(int n) {
        if (n == this.axis) {
            return this.majorSpan;
        }
        if (this.prefRequest != null) {
            View view = this.prefRequest.getChildView();
            return view.getPreferredSpan(n);
        }
        if (n == 0) {
            return this.getLeftInset() + this.getRightInset() + 30.0f;
        }
        return this.getTopInset() + this.getBottomInset() + 30.0f;
    }

    public float getMinimumSpan(int n) {
        if (n == this.axis) {
            return this.getPreferredSpan(n);
        }
        if (this.minRequest != null) {
            View view = this.minRequest.getChildView();
            return view.getMinimumSpan(n);
        }
        if (n == 0) {
            return this.getLeftInset() + this.getRightInset() + 5.0f;
        }
        return this.getTopInset() + this.getBottomInset() + 5.0f;
    }

    public float getMaximumSpan(int n) {
        if (n == this.axis) {
            return this.getPreferredSpan(n);
        }
        return 32767.0f;
    }

    public int getViewCount() {
        ChildVector childVector = this.stats;
        synchronized (childVector) {
            int n = this.stats.size();
            return n;
        }
    }

    public View getView(int n) {
        ChildVector childVector = this.stats;
        synchronized (childVector) {
            if (n >= 0 && n < this.stats.size()) {
                ChildState childState = this.stats.getChildState(n);
                View view = childState.getChildView();
                return view;
            }
        }
        return null;
    }

    public Shape getChildAllocation(int n, Shape shape) {
        Shape shape2 = this.locator.getChildAllocation(n, shape);
        return shape2;
    }

    public int getViewIndex(int n, Position.Bias bias) {
        return this.getViewIndexAtPosition(n, bias);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        ChildState childState;
        int n2 = this.getViewIndexAtPosition(n, bias);
        Shape shape2 = this.locator.getChildAllocation(n2, shape);
        ChildState childState2 = childState = this.getChildState(n2);
        synchronized (childState2) {
            Shape shape3;
            View view = childState.getChildView();
            Shape shape4 = shape3 = view.modelToView(n, shape2, bias);
            return shape4;
        }
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        int n;
        ChildState childState;
        Shape shape2;
        int n2;
        ChildLocator childLocator = this.locator;
        synchronized (childLocator) {
            n2 = this.locator.getViewIndexAtPoint(f, f2, shape);
            shape2 = this.locator.getChildAllocation(n2, shape);
        }
        ChildState childState2 = childState = this.getChildState(n2);
        synchronized (childState2) {
            View view = childState.getChildView();
            n = view.viewToModel(f, f2, shape2, biasArray);
        }
        return n;
    }

    static class ChildVector
    extends GapVector {
        ChildVector() {
        }

        ChildVector(int n) {
            super(n);
        }

        public void replace(int n, int n2, ChildState[] childStateArray) {
            super.replace(n, n2, childStateArray, childStateArray.length);
        }

        protected Object allocateArray(int n) {
            return new ChildState[n];
        }

        protected int getArrayLength() {
            ChildState[] childStateArray = (ChildState[])this.getArray();
            return childStateArray.length;
        }

        public int size() {
            int n = this.getArrayLength() - (this.getGapEnd() - this.getGapStart());
            return n;
        }

        public ChildState getChildState(int n) {
            int n2 = this.getGapStart();
            int n3 = this.getGapEnd();
            ChildState[] childStateArray = (ChildState[])this.getArray();
            if (n < n2) {
                return childStateArray[n];
            }
            return childStateArray[n += n3 - n2];
        }
    }

    class FlushTask
    implements Runnable {
        FlushTask() {
        }

        public void run() {
            AbstractDocument abstractDocument = (AbstractDocument)AsyncBoxView.this.getDocument();
            try {
                abstractDocument.readLock();
                int n = AsyncBoxView.this.getViewCount();
                if (AsyncBoxView.this.minorChanged && n > 0) {
                    Object object;
                    LayoutQueue layoutQueue = AsyncBoxView.this.getLayoutQueue();
                    Object object2 = AsyncBoxView.this.getChildState(0);
                    Object object3 = AsyncBoxView.this.getChildState(0);
                    int n2 = 1;
                    while (n2 < n) {
                        object = AsyncBoxView.this.getChildState(n2);
                        if (((ChildState)object).min > ((ChildState)object2).min) {
                            object2 = object;
                        }
                        if (((ChildState)object).pref > ((ChildState)object3).pref) {
                            object3 = object;
                        }
                        ++n2;
                    }
                    object = AsyncBoxView.this;
                    synchronized (object) {
                        AsyncBoxView.this.minRequest = object2;
                        AsyncBoxView.this.prefRequest = object3;
                    }
                }
                AsyncBoxView.this.flushRequirementChanges();
                Object var10_9 = null;
                abstractDocument.readUnlock();
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                abstractDocument.readUnlock();
                throw throwable;
            }
        }
    }

    public class ChildState
    implements Runnable {
        private float min;
        private float pref;
        private float max;
        private float align;
        private boolean minorValid;
        private float span;
        private float offset;
        private boolean majorValid;
        private View child;
        private boolean childSizeValid;

        public ChildState(View view) {
            this.child = view;
            this.minorValid = false;
            this.majorValid = false;
            this.childSizeValid = false;
            this.child.setParent(AsyncBoxView.this);
        }

        public View getChildView() {
            return this.child;
        }

        public void run() {
            AbstractDocument abstractDocument;
            block9: {
                abstractDocument = (AbstractDocument)AsyncBoxView.this.getDocument();
                try {
                    abstractDocument.readLock();
                    if (this.minorValid && this.majorValid && this.childSizeValid) {
                        Object var6_2 = null;
                        abstractDocument.readUnlock();
                        return;
                    }
                    if (this.child.getParent() != AsyncBoxView.this) break block9;
                    AsyncBoxView asyncBoxView = AsyncBoxView.this;
                    synchronized (asyncBoxView) {
                        AsyncBoxView.this.changing = this;
                    }
                    this.updateChild();
                    AsyncBoxView asyncBoxView2 = AsyncBoxView.this;
                    synchronized (asyncBoxView2) {
                        AsyncBoxView.this.changing = null;
                    }
                    this.updateChild();
                }
                catch (Throwable throwable) {
                    Object var6_4 = null;
                    abstractDocument.readUnlock();
                    throw throwable;
                }
            }
            Object var6_3 = null;
            abstractDocument.readUnlock();
        }

        void updateChild() {
            int n;
            boolean bl = false;
            ChildState childState = this;
            synchronized (childState) {
                if (!this.minorValid) {
                    n = AsyncBoxView.this.getMinorAxis();
                    this.min = this.child.getMinimumSpan(n);
                    this.pref = this.child.getPreferredSpan(n);
                    this.max = this.child.getMaximumSpan(n);
                    this.minorValid = true;
                    bl = true;
                }
            }
            if (bl) {
                AsyncBoxView.this.minorRequirementChange(this);
            }
            n = 0;
            float f = 0.0f;
            ChildState childState2 = this;
            synchronized (childState2) {
                if (!this.majorValid) {
                    float f2 = this.span;
                    this.span = this.child.getPreferredSpan(AsyncBoxView.this.axis);
                    f = this.span - f2;
                    this.majorValid = true;
                    n = 1;
                }
            }
            if (n != 0) {
                AsyncBoxView.this.majorRequirementChange(this, f);
                AsyncBoxView.this.locator.childChanged(this);
            }
            ChildState childState3 = this;
            synchronized (childState3) {
                if (!this.childSizeValid) {
                    float f3;
                    float f4;
                    if (AsyncBoxView.this.axis == 0) {
                        f4 = this.span;
                        f3 = this.getMinorSpan();
                    } else {
                        f4 = this.getMinorSpan();
                        f3 = this.span;
                    }
                    this.childSizeValid = true;
                    this.child.setSize(f4, f3);
                }
            }
        }

        public float getMinorSpan() {
            if (this.max < AsyncBoxView.this.minorSpan) {
                return this.max;
            }
            return Math.max(this.min, AsyncBoxView.this.minorSpan);
        }

        public float getMinorOffset() {
            if (this.max < AsyncBoxView.this.minorSpan) {
                float f = this.child.getAlignment(AsyncBoxView.this.getMinorAxis());
                return (AsyncBoxView.this.minorSpan - this.max) * f;
            }
            return 0.0f;
        }

        public float getMajorSpan() {
            return this.span;
        }

        public float getMajorOffset() {
            return this.offset;
        }

        public void setMajorOffset(float f) {
            this.offset = f;
        }

        public void preferenceChanged(boolean bl, boolean bl2) {
            if (AsyncBoxView.this.axis == 0) {
                if (bl) {
                    this.majorValid = false;
                }
                if (bl2) {
                    this.minorValid = false;
                }
            } else {
                if (bl) {
                    this.minorValid = false;
                }
                if (bl2) {
                    this.majorValid = false;
                }
            }
            this.childSizeValid = false;
        }

        public boolean isLayoutValid() {
            return this.minorValid && this.majorValid && this.childSizeValid;
        }
    }

    public class ChildLocator {
        protected ChildState lastValidOffset;
        protected Rectangle lastAlloc = new Rectangle();
        protected Rectangle childAlloc = new Rectangle();

        public synchronized void childChanged(ChildState childState) {
            if (this.lastValidOffset == null) {
                this.lastValidOffset = childState;
            } else if (childState.getChildView().getStartOffset() < this.lastValidOffset.getChildView().getStartOffset()) {
                this.lastValidOffset = childState;
            }
        }

        public synchronized void paintChildren(Graphics graphics) {
            Rectangle rectangle = graphics.getClipBounds();
            float f = AsyncBoxView.this.axis == 0 ? (float)(rectangle.x - this.lastAlloc.x) : (float)(rectangle.y - this.lastAlloc.y);
            int n = this.getViewIndexAtVisualOffset(f);
            int n2 = AsyncBoxView.this.getViewCount();
            float f2 = AsyncBoxView.this.getChildState(n).getMajorOffset();
            int n3 = n;
            while (n3 < n2) {
                ChildState childState = AsyncBoxView.this.getChildState(n3);
                childState.setMajorOffset(f2);
                Shape shape = this.getChildAllocation(n3);
                if (!this.intersectsClip(shape, rectangle)) break;
                ChildState childState2 = childState;
                synchronized (childState2) {
                    View view = childState.getChildView();
                    view.paint(graphics, shape);
                }
                f2 += childState.getMajorSpan();
                ++n3;
            }
        }

        public synchronized Shape getChildAllocation(int n, Shape shape) {
            if (shape == null) {
                return null;
            }
            this.setAllocation(shape);
            ChildState childState = AsyncBoxView.this.getChildState(n);
            if (childState.getChildView().getStartOffset() > this.lastValidOffset.getChildView().getStartOffset()) {
                this.updateChildOffsetsToIndex(n);
            }
            Shape shape2 = this.getChildAllocation(n);
            return shape2;
        }

        public int getViewIndexAtPoint(float f, float f2, Shape shape) {
            this.setAllocation(shape);
            float f3 = AsyncBoxView.this.axis == 0 ? f - (float)this.lastAlloc.x : f2 - (float)this.lastAlloc.y;
            int n = this.getViewIndexAtVisualOffset(f3);
            return n;
        }

        protected Shape getChildAllocation(int n) {
            ChildState childState = AsyncBoxView.this.getChildState(n);
            if (!childState.isLayoutValid()) {
                childState.run();
            }
            if (AsyncBoxView.this.axis == 0) {
                this.childAlloc.x = this.lastAlloc.x + (int)childState.getMajorOffset();
                this.childAlloc.y = this.lastAlloc.y + (int)childState.getMinorOffset();
                this.childAlloc.width = (int)childState.getMajorSpan();
                this.childAlloc.height = (int)childState.getMinorSpan();
            } else {
                this.childAlloc.y = this.lastAlloc.y + (int)childState.getMajorOffset();
                this.childAlloc.x = this.lastAlloc.x + (int)childState.getMinorOffset();
                this.childAlloc.height = (int)childState.getMajorSpan();
                this.childAlloc.width = (int)childState.getMinorSpan();
            }
            return this.childAlloc;
        }

        protected void setAllocation(Shape shape) {
            if (shape instanceof Rectangle) {
                this.lastAlloc.setBounds((Rectangle)shape);
            } else {
                this.lastAlloc.setBounds(shape.getBounds());
            }
            AsyncBoxView.this.setSize(this.lastAlloc.width, this.lastAlloc.height);
        }

        protected int getViewIndexAtVisualOffset(float f) {
            int n = AsyncBoxView.this.getViewCount();
            if (n > 0) {
                if (this.lastValidOffset == null) {
                    this.lastValidOffset = AsyncBoxView.this.getChildState(0);
                }
                if (f > AsyncBoxView.this.majorSpan) {
                    return 0;
                }
                if (f > this.lastValidOffset.getMajorOffset()) {
                    return this.updateChildOffsets(f);
                }
                float f2 = 0.0f;
                int n2 = 0;
                while (n2 < n) {
                    ChildState childState = AsyncBoxView.this.getChildState(n2);
                    float f3 = f2 + childState.getMajorSpan();
                    if (f < f3) {
                        return n2;
                    }
                    f2 = f3;
                    ++n2;
                }
            }
            return n - 1;
        }

        int updateChildOffsets(float f) {
            float f2;
            int n = AsyncBoxView.this.getViewCount();
            int n2 = n - 1;
            int n3 = this.lastValidOffset.getChildView().getStartOffset();
            int n4 = AsyncBoxView.this.getViewIndexAtPosition(n3, Position.Bias.Forward);
            float f3 = f2 = this.lastValidOffset.getMajorOffset();
            int n5 = n4;
            while (n5 < n) {
                ChildState childState = AsyncBoxView.this.getChildState(n5);
                childState.setMajorOffset(f3);
                f3 += childState.getMajorSpan();
                if (f < f3) {
                    n2 = n5;
                    this.lastValidOffset = childState;
                    break;
                }
                ++n5;
            }
            return n2;
        }

        void updateChildOffsetsToIndex(int n) {
            int n2 = this.lastValidOffset.getChildView().getStartOffset();
            int n3 = AsyncBoxView.this.getViewIndexAtPosition(n2, Position.Bias.Forward);
            float f = this.lastValidOffset.getMajorOffset();
            int n4 = n3;
            while (n4 <= n) {
                ChildState childState = AsyncBoxView.this.getChildState(n4);
                childState.setMajorOffset(f);
                f += childState.getMajorSpan();
                ++n4;
            }
        }

        boolean intersectsClip(Shape shape, Rectangle rectangle) {
            Rectangle rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            return rectangle2.intersects(rectangle);
        }
    }
}

