/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractColorChooserPanel
extends JPanel {
    private JColorChooser chooser;
    private ChangeListener colorListener;
    private boolean dirty = true;

    public abstract void updateChooser();

    protected abstract void buildChooser();

    public abstract String getDisplayName();

    public abstract Icon getSmallDisplayIcon();

    public abstract Icon getLargeDisplayIcon();

    public void installChooserPanel(JColorChooser jColorChooser) {
        if (this.chooser != null) {
            throw new RuntimeException("This chooser panel is already installed");
        }
        this.chooser = jColorChooser;
        this.buildChooser();
        this.updateChooser();
        this.colorListener = new ModelListener();
        this.getColorSelectionModel().addChangeListener(this.colorListener);
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        this.getColorSelectionModel().removeChangeListener(this.colorListener);
        this.chooser = null;
    }

    public ColorSelectionModel getColorSelectionModel() {
        return this.chooser.getSelectionModel();
    }

    protected Color getColorFromModel() {
        return this.getColorSelectionModel().getSelectedColor();
    }

    public void paint(Graphics graphics) {
        if (this.dirty) {
            this.updateChooser();
            this.dirty = false;
        }
        super.paint(graphics);
    }

    class ModelListener
    implements ChangeListener,
    Serializable {
        ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (AbstractColorChooserPanel.this.isShowing()) {
                AbstractColorChooserPanel.this.updateChooser();
                AbstractColorChooserPanel.this.dirty = false;
            } else {
                AbstractColorChooserPanel.this.dirty = true;
            }
        }
    }
}

