/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ReplicateScaleFilter;

public class AreaAveragingScaleFilter
extends ReplicateScaleFilter {
    private static final ColorModel rgbmodel = ColorModel.getRGBdefault();
    private static final int neededHints = 6;
    private boolean passthrough;
    private float[] reds;
    private float[] greens;
    private float[] blues;
    private float[] alphas;
    private int savedy;
    private int savedyrem;

    public AreaAveragingScaleFilter(int n, int n2) {
        super(n, n2);
    }

    public void setHints(int n) {
        this.passthrough = (n & 6) != 6;
        super.setHints(n);
    }

    private void makeAccumBuffers() {
        this.reds = new float[this.destWidth];
        this.greens = new float[this.destWidth];
        this.blues = new float[this.destWidth];
        this.alphas = new float[this.destWidth];
    }

    private int[] calcRow() {
        float f = (float)this.srcWidth * (float)this.srcHeight;
        if (this.outpixbuf == null || !(this.outpixbuf instanceof int[])) {
            this.outpixbuf = new int[this.destWidth];
        }
        int[] nArray = (int[])this.outpixbuf;
        int n = 0;
        while (n < this.destWidth) {
            int n2 = Math.round(this.alphas[n] / f);
            int n3 = Math.round(this.reds[n] / f);
            int n4 = Math.round(this.greens[n] / f);
            int n5 = Math.round(this.blues[n] / f);
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > 255) {
                n3 = 255;
            }
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 255) {
                n4 = 255;
            }
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 > 255) {
                n5 = 255;
            }
            nArray[n] = n2 << 24 | n3 << 16 | n4 << 8 | n5;
            ++n;
        }
        return nArray;
    }

    private void accumPixels(int n, int n2, int n3, int n4, ColorModel colorModel, Object object, int n5, int n6) {
        int n7;
        int n8;
        if (this.reds == null) {
            this.makeAccumBuffers();
        }
        int n9 = n2;
        int n10 = this.destHeight;
        if (n9 == 0) {
            n8 = 0;
            n7 = 0;
        } else {
            n8 = this.savedy;
            n7 = this.savedyrem;
        }
        while (n9 < n2 + n4) {
            int n11;
            if (n7 == 0) {
                n11 = 0;
                while (n11 < this.destWidth) {
                    this.blues[n11] = 0.0f;
                    this.greens[n11] = 0.0f;
                    this.reds[n11] = 0.0f;
                    this.alphas[n11] = 0.0f;
                    ++n11;
                }
                n7 = this.srcHeight;
            }
            int n12 = n10 < n7 ? n10 : n7;
            n11 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = this.srcWidth;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            while (n11 < n3) {
                int n16;
                if (n14 == 0) {
                    n14 = this.destWidth;
                    n16 = object instanceof byte[] ? ((byte[])object)[n5 + n11] & 0xFF : ((int[])object)[n5 + n11];
                    n16 = colorModel.getRGB(n16);
                    f = n16 >>> 24;
                    f2 = n16 >> 16 & 0xFF;
                    f3 = n16 >> 8 & 0xFF;
                    f4 = n16 & 0xFF;
                }
                n16 = n14 < n15 ? n14 : n15;
                float f5 = (float)n16 * (float)n12;
                int n17 = n13;
                this.alphas[n17] = this.alphas[n17] + f5 * f;
                int n18 = n13;
                this.reds[n18] = this.reds[n18] + f5 * f2;
                int n19 = n13;
                this.greens[n19] = this.greens[n19] + f5 * f3;
                int n20 = n13;
                this.blues[n20] = this.blues[n20] + f5 * f4;
                if ((n14 -= n16) == 0) {
                    ++n11;
                }
                if ((n15 -= n16) != 0) continue;
                ++n13;
                n15 = this.srcWidth;
            }
            if ((n7 -= n12) == 0) {
                int[] nArray = this.calcRow();
                do {
                    this.consumer.setPixels(0, n8, this.destWidth, 1, rgbmodel, nArray, 0, this.destWidth);
                    ++n8;
                } while ((n10 -= n12) >= n12 && n12 == this.srcHeight);
            } else {
                n10 -= n12;
            }
            if (n10 != 0) continue;
            n10 = this.destHeight;
            ++n9;
            n5 += n6;
        }
        this.savedyrem = n7;
        this.savedy = n8;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (this.passthrough) {
            super.setPixels(n, n2, n3, n4, colorModel, byArray, n5, n6);
        } else {
            this.accumPixels(n, n2, n3, n4, colorModel, byArray, n5, n6);
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (this.passthrough) {
            super.setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
        } else {
            this.accumPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
        }
    }
}

