/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.peer.TextComponentPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.BreakIterator;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import sun.awt.SunToolkit;

public class TextComponent
extends Component
implements Accessible {
    String text;
    boolean editable = true;
    int selectionStart;
    int selectionEnd;
    boolean backgroundSetByClientCode = false;
    private transient boolean canAccessClipboard;
    protected transient TextListener textListener;
    private static final long serialVersionUID = -2214773872412987419L;
    private int textComponentSerializedDataVersion = 1;
    private boolean checkForEnableIM = true;
    static /* synthetic */ Class class$java$awt$event$TextListener;

    TextComponent(String string) {
        this.text = string != null ? string : "";
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.checkSystemClipboardAccess();
    }

    private void enableInputMethodsIfNecessary() {
        if (this.checkForEnableIM) {
            this.checkForEnableIM = false;
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                this.enableInputMethods(((SunToolkit)toolkit).enableInputMethodsForTextComponent());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void enableInputMethods(boolean bl) {
        this.checkForEnableIM = false;
        super.enableInputMethods(bl);
    }

    boolean areInputMethodsEnabled() {
        if (this.checkForEnableIM) {
            this.enableInputMethodsIfNecessary();
        }
        return (this.eventMask & 0x1000L) != 0L;
    }

    public void addNotify() {
        super.addNotify();
        this.enableInputMethodsIfNecessary();
    }

    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
            if (textComponentPeer != null) {
                this.text = textComponentPeer.getText();
                this.selectionStart = textComponentPeer.getSelectionStart();
                this.selectionEnd = textComponentPeer.getSelectionEnd();
            }
            super.removeNotify();
        }
    }

    public synchronized void setText(String string) {
        this.text = string != null ? string : "";
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.setText(this.text);
        }
    }

    public synchronized String getText() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.text = textComponentPeer.getText();
        }
        return this.text;
    }

    public synchronized String getSelectedText() {
        return this.getText().substring(this.getSelectionStart(), this.getSelectionEnd());
    }

    public boolean isEditable() {
        return this.editable;
    }

    public synchronized void setEditable(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        this.editable = bl;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.setEditable(bl);
        }
    }

    public Color getBackground() {
        if (!this.editable && !this.backgroundSetByClientCode) {
            return SystemColor.control;
        }
        return super.getBackground();
    }

    public void setBackground(Color color) {
        this.backgroundSetByClientCode = true;
        super.setBackground(color);
    }

    public synchronized int getSelectionStart() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.selectionStart = textComponentPeer.getSelectionStart();
        }
        return this.selectionStart;
    }

    public synchronized void setSelectionStart(int n) {
        this.select(n, this.getSelectionEnd());
    }

    public synchronized int getSelectionEnd() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.selectionEnd = textComponentPeer.getSelectionEnd();
        }
        return this.selectionEnd;
    }

    public synchronized void setSelectionEnd(int n) {
        this.select(this.getSelectionStart(), n);
    }

    public synchronized void select(int n, int n2) {
        String string = this.getText();
        if (n < 0) {
            n = 0;
        }
        if (n > string.length()) {
            n = string.length();
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n2 < n) {
            n2 = n;
        }
        this.selectionStart = n;
        this.selectionEnd = n2;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.select(n, n2);
        }
    }

    public synchronized void selectAll() {
        String string = this.getText();
        this.selectionStart = 0;
        this.selectionEnd = this.getText().length();
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.select(this.selectionStart, this.selectionEnd);
        }
    }

    public synchronized void setCaretPosition(int n) {
        TextComponentPeer textComponentPeer;
        if (n < 0) {
            throw new IllegalArgumentException("position less than zero.");
        }
        int n2 = this.getText().length();
        if (n > n2) {
            n = n2;
        }
        if ((textComponentPeer = (TextComponentPeer)this.peer) == null) {
            throw new IllegalComponentStateException("Cannot set caret position until after the peer has been created");
        }
        textComponentPeer.setCaretPosition(n);
    }

    public synchronized int getCaretPosition() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        int n = 0;
        if (textComponentPeer != null) {
            n = textComponentPeer.getCaretPosition();
        }
        return n;
    }

    public synchronized void addTextListener(TextListener textListener) {
        if (textListener == null) {
            return;
        }
        this.textListener = AWTEventMulticaster.add(this.textListener, textListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeTextListener(TextListener textListener) {
        if (textListener == null) {
            return;
        }
        this.textListener = AWTEventMulticaster.remove(this.textListener, textListener);
    }

    public EventListener[] getListeners(Class clazz) {
        TextListener textListener = null;
        if (clazz != (class$java$awt$event$TextListener == null ? (class$java$awt$event$TextListener = TextComponent.class$("java.awt.event.TextListener")) : class$java$awt$event$TextListener)) {
            return super.getListeners(clazz);
        }
        textListener = this.textListener;
        return AWTEventMulticaster.getListeners(textListener, clazz);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 900) {
            return (this.eventMask & 0x400L) != 0L || this.textListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TextEvent) {
            this.processTextEvent((TextEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processTextEvent(TextEvent textEvent) {
        if (this.textListener != null) {
            int n = textEvent.getID();
            switch (n) {
                case 900: {
                    this.textListener.textValueChanged(textEvent);
                }
            }
        }
    }

    protected String paramString() {
        String string = super.paramString() + ",text=" + this.getText();
        if (this.editable) {
            string = string + ",editable";
        }
        return string + ",selection=" + this.getSelectionStart() + "-" + this.getSelectionEnd();
    }

    private void checkSystemClipboardAccess() {
        this.canAccessClipboard = true;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkSystemClipboardAccess();
            }
            catch (SecurityException securityException) {
                this.canAccessClipboard = false;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.text = textComponentPeer.getText();
            this.selectionStart = textComponentPeer.getSelectionStart();
            this.selectionEnd = textComponentPeer.getSelectionEnd();
        }
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "textL", this.textListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        this.text = this.text != null ? this.text : "";
        this.select(this.selectionStart, this.selectionEnd);
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("textL" == string) {
                this.addTextListener((TextListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
        this.enableInputMethodsIfNecessary();
        this.checkSystemClipboardAccess();
    }

    int getIndexAtPoint(Point point) {
        return -1;
    }

    Rectangle getCharacterBounds(int n) {
        return null;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTTextComponent();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleAWTTextComponent
    extends Component.AccessibleAWTComponent
    implements AccessibleText,
    TextListener {
        public AccessibleAWTTextComponent() {
            TextComponent.this.addTextListener(this);
        }

        public void textValueChanged(TextEvent textEvent) {
            Integer n = new Integer(TextComponent.this.getCaretPosition());
            this.firePropertyChange("AccessibleText", null, n);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (TextComponent.this.isEditable()) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleText getAccessibleText() {
            return this;
        }

        public int getIndexAtPoint(Point point) {
            return TextComponent.this.getIndexAtPoint(point);
        }

        public Rectangle getCharacterBounds(int n) {
            return TextComponent.this.getCharacterBounds(n);
        }

        public int getCharCount() {
            return TextComponent.this.getText().length();
        }

        public int getCaretPosition() {
            return TextComponent.this.getCaretPosition();
        }

        public AttributeSet getCharacterAttribute(int n) {
            return null;
        }

        public int getSelectionStart() {
            return TextComponent.this.getSelectionStart();
        }

        public int getSelectionEnd() {
            return TextComponent.this.getSelectionEnd();
        }

        public String getSelectedText() {
            return TextComponent.this.getSelectedText();
        }

        public String getAtIndex(int n, int n2) {
            if (n2 < 0 || n2 >= TextComponent.this.getText().length()) {
                return null;
            }
            switch (n) {
                case 1: {
                    return TextComponent.this.getText().substring(n2, n2 + 1);
                }
                case 2: {
                    String string = TextComponent.this.getText();
                    BreakIterator breakIterator = BreakIterator.getWordInstance();
                    breakIterator.setText(string);
                    int n3 = breakIterator.following(n2);
                    return string.substring(breakIterator.previous(), n3);
                }
                case 3: {
                    String string = TextComponent.this.getText();
                    BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                    breakIterator.setText(string);
                    int n4 = breakIterator.following(n2);
                    return string.substring(breakIterator.previous(), n4);
                }
            }
            return null;
        }

        public String getAfterIndex(int n, int n2) {
            if (n2 < 0 || n2 >= TextComponent.this.getText().length()) {
                return null;
            }
            switch (n) {
                case 1: {
                    if (n2 + 1 >= TextComponent.this.getText().length()) {
                        return null;
                    }
                    return TextComponent.this.getText().substring(n2 + 1, n2 + 2);
                }
                case 2: {
                    String string = TextComponent.this.getText();
                    BreakIterator breakIterator = BreakIterator.getWordInstance();
                    breakIterator.setText(string);
                    int n3 = breakIterator.following(n2);
                    if (n3 == -1 || n3 >= string.length()) {
                        return null;
                    }
                    int n4 = breakIterator.following(n3);
                    if (n4 == -1 || n4 >= string.length()) {
                        return null;
                    }
                    return string.substring(n3, n4);
                }
                case 3: {
                    String string = TextComponent.this.getText();
                    BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                    breakIterator.setText(string);
                    int n5 = breakIterator.following(n2);
                    if (n5 == -1 || n5 >= string.length()) {
                        return null;
                    }
                    int n6 = breakIterator.following(n5);
                    if (n6 == -1 || n6 >= string.length()) {
                        return null;
                    }
                    return string.substring(n5, n6);
                }
            }
            return null;
        }

        public String getBeforeIndex(int n, int n2) {
            if (n2 < 0 || n2 > TextComponent.this.getText().length() - 1) {
                return null;
            }
            switch (n) {
                case 1: {
                    if (n2 == 0) {
                        return null;
                    }
                    return TextComponent.this.getText().substring(n2 - 1, n2);
                }
                case 2: {
                    String string = TextComponent.this.getText();
                    BreakIterator breakIterator = BreakIterator.getWordInstance();
                    breakIterator.setText(string);
                    int n3 = breakIterator.following(n2);
                    n3 = breakIterator.previous();
                    int n4 = breakIterator.previous();
                    if (n4 == -1) {
                        return null;
                    }
                    return string.substring(n4, n3);
                }
                case 3: {
                    String string = TextComponent.this.getText();
                    BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                    breakIterator.setText(string);
                    int n5 = breakIterator.following(n2);
                    n5 = breakIterator.previous();
                    int n6 = breakIterator.previous();
                    if (n6 == -1) {
                        return null;
                    }
                    return string.substring(n6, n5);
                }
            }
            return null;
        }
    }
}

