/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class FlowLayout
implements LayoutManager,
Serializable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    int align;
    int newAlign;
    int hgap;
    int vgap;
    private static final long serialVersionUID = -7262534875583282631L;
    private static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;

    public FlowLayout() {
        this(1, 5, 5);
    }

    public FlowLayout(int n) {
        this(n, 5, 5);
    }

    public FlowLayout(int n, int n2, int n3) {
        this.hgap = n2;
        this.vgap = n3;
        this.setAlignment(n);
    }

    public int getAlignment() {
        return this.newAlign;
    }

    public void setAlignment(int n) {
        this.newAlign = n;
        switch (n) {
            case 3: {
                this.align = 0;
                break;
            }
            case 4: {
                this.align = 2;
                break;
            }
            default: {
                this.align = n;
            }
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension;
            Serializable serializable;
            Dimension dimension2 = new Dimension(0, 0);
            int n = container.getComponentCount();
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                serializable = container.getComponent(n2);
                if (((Component)serializable).visible) {
                    dimension = ((Component)serializable).getPreferredSize();
                    dimension2.height = Math.max(dimension2.height, dimension.height);
                    if (bl) {
                        bl = false;
                    } else {
                        dimension2.width += this.hgap;
                    }
                    dimension2.width += dimension.width;
                }
                ++n2;
            }
            serializable = container.getInsets();
            dimension2.width += ((Insets)serializable).left + ((Insets)serializable).right + this.hgap * 2;
            dimension2.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.vgap * 2;
            dimension = dimension2;
            return dimension;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension;
            Serializable serializable;
            Dimension dimension2 = new Dimension(0, 0);
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                serializable = container.getComponent(n2);
                if (((Component)serializable).visible) {
                    dimension = ((Component)serializable).getMinimumSize();
                    dimension2.height = Math.max(dimension2.height, dimension.height);
                    if (n2 > 0) {
                        dimension2.width += this.hgap;
                    }
                    dimension2.width += dimension.width;
                }
                ++n2;
            }
            serializable = container.getInsets();
            dimension2.width += ((Insets)serializable).left + ((Insets)serializable).right + this.hgap * 2;
            dimension2.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.vgap * 2;
            dimension = dimension2;
            return dimension;
        }
    }

    private void moveComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Object object = container.getTreeLock();
        synchronized (object) {
            switch (this.newAlign) {
                case 0: {
                    n += bl ? 0 : n3;
                    break;
                }
                case 1: {
                    n += n3 / 2;
                    break;
                }
                case 2: {
                    n += bl ? n3 : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    n += n3;
                }
            }
            int n7 = n5;
            while (n7 < n6) {
                Component component = container.getComponent(n7);
                if (component.visible) {
                    if (bl) {
                        component.setLocation(n, n2 + (n4 - component.height) / 2);
                    } else {
                        component.setLocation(container.width - n - component.width, n2 + (n4 - component.height) / 2);
                    }
                    n += component.width + this.hgap;
                }
                ++n7;
            }
        }
    }

    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.width - (insets.left + insets.right + this.hgap * 2);
            int n2 = container.getComponentCount();
            int n3 = 0;
            int n4 = insets.top + this.vgap;
            int n5 = 0;
            int n6 = 0;
            boolean bl = container.getComponentOrientation().isLeftToRight();
            int n7 = 0;
            while (n7 < n2) {
                Component component = container.getComponent(n7);
                if (component.visible) {
                    Dimension dimension = component.getPreferredSize();
                    component.setSize(dimension.width, dimension.height);
                    if (n3 == 0 || n3 + dimension.width <= n) {
                        if (n3 > 0) {
                            n3 += this.hgap;
                        }
                        n3 += dimension.width;
                        n5 = Math.max(n5, dimension.height);
                    } else {
                        this.moveComponents(container, insets.left + this.hgap, n4, n - n3, n5, n6, n7, bl);
                        n3 = dimension.width;
                        n4 += this.vgap + n5;
                        n5 = dimension.height;
                        n6 = n7;
                    }
                }
                ++n7;
            }
            this.moveComponents(container, insets.left + this.hgap, n4, n - n3, n5, n6, n2, bl);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.setAlignment(this.align);
        }
        this.serialVersionOnStream = 1;
    }

    public String toString() {
        String string = "";
        switch (this.align) {
            case 0: {
                string = ",align=left";
                break;
            }
            case 1: {
                string = ",align=center";
                break;
            }
            case 2: {
                string = ",align=right";
                break;
            }
            case 3: {
                string = ",align=leading";
                break;
            }
            case 4: {
                string = ",align=trailing";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + string + "]";
    }
}

