/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.core;

import com.sun.corba.se.internal.core.MarshalInputStream;
import com.sun.corba.se.internal.core.MarshalOutputStream;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;

public final class CodeSetComponentInfo {
    public static final int ASCII = 65568;
    public static final int UNICODE = 65792;
    private CodeSetComponent forCharData = new CodeSetComponent(65568, null);
    private CodeSetComponent forWCharData = new CodeSetComponent(65792, null);
    public static final CodeSetContext myCodeSet = new CodeSetContext();

    public void read(MarshalInputStream marshalInputStream) {
        this.forCharData.read(marshalInputStream);
        this.forWCharData.read(marshalInputStream);
        if (!this.forCharData.validateWith(65568) || !this.forWCharData.validateWith(65792)) {
            throw new INV_OBJREF(1398079490, CompletionStatus.COMPLETED_NO);
        }
    }

    public void write(MarshalOutputStream marshalOutputStream) {
        this.forCharData.write(marshalOutputStream);
        this.forWCharData.write(marshalOutputStream);
    }

    public static final class CodeSetContext {
        private int char_data = 65568;
        private int wchar_data = 65792;

        public void read(MarshalInputStream marshalInputStream) {
            this.char_data = marshalInputStream.read_ulong();
            this.wchar_data = marshalInputStream.read_ulong();
        }

        public void write(MarshalOutputStream marshalOutputStream) {
            marshalOutputStream.write_ulong(this.char_data);
            marshalOutputStream.write_ulong(this.wchar_data);
        }

        public boolean validateWith(CodeSetContext codeSetContext) {
            return codeSetContext.char_data == this.char_data && codeSetContext.wchar_data == this.wchar_data;
        }
    }

    public static final class CodeSetComponent {
        private int nativeCodeSet;
        private int[] conversionCodeSets;

        public CodeSetComponent(int n, int[] nArray) {
            this.nativeCodeSet = n;
            this.conversionCodeSets = nArray == null ? new int[0] : nArray;
        }

        public void read(MarshalInputStream marshalInputStream) {
            this.nativeCodeSet = marshalInputStream.read_ulong();
            int n = marshalInputStream.read_long();
            this.conversionCodeSets = new int[n];
            marshalInputStream.read_ulong_array(this.conversionCodeSets, 0, n);
        }

        public void write(MarshalOutputStream marshalOutputStream) {
            marshalOutputStream.write_ulong(this.nativeCodeSet);
            marshalOutputStream.write_long(this.conversionCodeSets.length);
            marshalOutputStream.write_ulong_array(this.conversionCodeSets, 0, this.conversionCodeSets.length);
        }

        boolean validateWith(int n) {
            boolean bl = false;
            if (this.nativeCodeSet != n) {
                int n2 = 0;
                while (n2 < this.conversionCodeSets.length) {
                    if (this.conversionCodeSets[n2] == n) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            } else {
                bl = true;
            }
            return bl;
        }
    }
}

