/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.liveconnect;

import java.io.FilePermission;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import sun.plugin.liveconnect.JavaScriptProtectionDomain;
import sun.plugin.liveconnect.OriginNotAllowedException;
import sun.plugin.liveconnect.PrivilegedCallMethodAction;
import sun.plugin.liveconnect.PrivilegedConstructObjectAction;
import sun.plugin.liveconnect.PrivilegedGetFieldAction;
import sun.plugin.liveconnect.PrivilegedSetFieldAction;
import sun.plugin.usability.Trace;

public class SecureInvocation {
    public static Object ConstructObject(Constructor constructor, Object[] objectArray, int n) throws Exception {
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{n == 0 ? SecureInvocation.getDefaultProtectionDomain(null) : SecureInvocation.getTrustedProtectionDomain()};
        AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
        return AccessController.doPrivileged(new PrivilegedConstructObjectAction(constructor, objectArray), accessControlContext);
    }

    public static Object CallMethod(Object object, Method method, Object[] objectArray, int n) throws Exception {
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{n == 0 ? SecureInvocation.getDefaultProtectionDomain(null) : SecureInvocation.getTrustedProtectionDomain()};
        AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
        return AccessController.doPrivileged(new PrivilegedCallMethodAction(method, object, objectArray), accessControlContext);
    }

    public static Object GetField(Object object, Field field, int n) throws Exception {
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{n == 0 ? SecureInvocation.getDefaultProtectionDomain(null) : SecureInvocation.getTrustedProtectionDomain()};
        AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
        return AccessController.doPrivileged(new PrivilegedGetFieldAction(field, object), accessControlContext);
    }

    public static void SetField(Object object, Field field, Object object2, int n) throws Exception {
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{n == 0 ? SecureInvocation.getDefaultProtectionDomain(null) : SecureInvocation.getTrustedProtectionDomain()};
        AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
        AccessController.doPrivileged(new PrivilegedSetFieldAction(field, object, object2), accessControlContext);
    }

    public static Object ConstructObject(Class clazz, Constructor constructor, Object[] objectArray, String string, boolean bl, boolean bl2) throws Exception {
        try {
            SecureInvocation.checkLiveConnectCaller(clazz, string, bl);
            ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{!bl2 ? SecureInvocation.getDefaultProtectionDomain(string) : SecureInvocation.getTrustedProtectionDomain()};
            AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
            return AccessController.doPrivileged(new PrivilegedConstructObjectAction(constructor, objectArray), accessControlContext);
        }
        catch (Exception exception) {
            Trace.liveConnectPrintException(exception);
            throw exception;
        }
    }

    public static Object CallMethod(Class clazz, Object object, Method method, Object[] objectArray, String string, boolean bl, boolean bl2) throws Exception {
        try {
            SecureInvocation.checkLiveConnectCaller(clazz, string, bl);
            ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{!bl2 ? SecureInvocation.getDefaultProtectionDomain(string) : SecureInvocation.getTrustedProtectionDomain()};
            AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
            return AccessController.doPrivileged(new PrivilegedCallMethodAction(method, object, objectArray), accessControlContext);
        }
        catch (Exception exception) {
            Trace.liveConnectPrintException(exception);
            throw exception;
        }
    }

    public static Object GetField(Class clazz, Object object, Field field, String string, boolean bl, boolean bl2) throws Exception {
        try {
            SecureInvocation.checkLiveConnectCaller(clazz, string, bl);
            ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{!bl2 ? SecureInvocation.getDefaultProtectionDomain(string) : SecureInvocation.getTrustedProtectionDomain()};
            AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
            return AccessController.doPrivileged(new PrivilegedGetFieldAction(field, object), accessControlContext);
        }
        catch (Exception exception) {
            Trace.liveConnectPrintException(exception);
            throw exception;
        }
    }

    public static void SetField(Class clazz, Object object, Field field, Object object2, String string, boolean bl, boolean bl2) throws Exception {
        try {
            SecureInvocation.checkLiveConnectCaller(clazz, string, bl);
            ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{!bl2 ? SecureInvocation.getDefaultProtectionDomain(string) : SecureInvocation.getTrustedProtectionDomain()};
            AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
            AccessController.doPrivileged(new PrivilegedSetFieldAction(field, object, object2), accessControlContext);
        }
        catch (Exception exception) {
            Trace.liveConnectPrintException(exception);
            throw exception;
        }
    }

    private static ProtectionDomain getProtectionDomain(Class clazz, String string, boolean bl, boolean bl2) throws OriginNotAllowedException, MalformedURLException {
        boolean bl3 = false;
        SecureInvocation.checkLiveConnectCaller(clazz, string, bl);
        if (bl2) {
            return SecureInvocation.getTrustedProtectionDomain();
        }
        return SecureInvocation.getDefaultProtectionDomain(string);
    }

    private static void checkLiveConnectCaller(Class clazz, String string, boolean bl) throws OriginNotAllowedException, MalformedURLException {
        if (bl) {
            Trace.liveConnectPrintln("JavaScript: UniversalBrowserRead enabled");
            return;
        }
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            Trace.liveConnectPrintln("JavaScript: calling Java system code");
            return;
        }
        URL uRL = codeSource.getLocation();
        URL uRL2 = null;
        if (string != null) {
            try {
                uRL2 = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return;
            }
        }
        if (uRL != null && uRL2 != null && uRL.getProtocol().equalsIgnoreCase(uRL2.getProtocol()) && uRL.getHost().equalsIgnoreCase(uRL2.getHost()) && uRL.getPort() == uRL2.getPort()) {
            Trace.liveConnectPrintln("JavaScript: caller and callee have same origin");
            return;
        }
        throw new OriginNotAllowedException("JavaScript is not from the same origin as the Java code, caller=" + uRL2 + ", callee=" + uRL);
    }

    private static ProtectionDomain getDefaultProtectionDomain(String string) throws MalformedURLException {
        Trace.liveConnectPrintln("JavaScript: default security policy = " + string);
        URL uRL = null;
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        Policy policy = Policy.getPolicy();
        CodeSource codeSource = new CodeSource(uRL, null);
        final PermissionCollection permissionCollection = policy.getPermissions(codeSource);
        if (uRL.getProtocol().equals("file")) {
            permissionCollection.add(new FilePermission("<<ALL FILES>>", "read"));
            permissionCollection.add(new SocketPermission("localhost", "connect,accept"));
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String string = InetAddress.getLocalHost().getHostName();
                        permissionCollection.add(new SocketPermission(string, "connect,accept"));
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        return new JavaScriptProtectionDomain(permissionCollection);
    }

    private static ProtectionDomain getTrustedProtectionDomain() {
        Trace.liveConnectPrintln("JavaScript: UniversalJavaPermission enabled");
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return new JavaScriptProtectionDomain(permissions);
    }
}

