/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import sun.awt.motif.MDataTransferer;

class CompositeTransferable
implements Transferable {
    private final List transferables;
    private final DataFlavor[] flavors;

    public CompositeTransferable(List list) {
        this.transferables = list;
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Transferable transferable = (Transferable)iterator.next();
            Object[] objectArray = transferable.getTransferDataFlavors();
            hashSet.addAll(Arrays.asList(objectArray));
        }
        this.flavors = MDataTransferer.getInstance().setToSortedDataFlavorArray(hashSet);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        Iterator iterator = this.transferables.iterator();
        while (iterator.hasNext()) {
            Transferable transferable = (Transferable)iterator.next();
            if (!transferable.isDataFlavorSupported(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        IOException iOException = null;
        Iterator iterator = this.transferables.iterator();
        while (iterator.hasNext()) {
            Transferable transferable = (Transferable)iterator.next();
            if (!transferable.isDataFlavorSupported(dataFlavor)) continue;
            try {
                return transferable.getTransferData(dataFlavor);
            }
            catch (IOException iOException2) {
                if (iOException != null) continue;
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

