/*
 * Decompiled with CFR 0.152.
 */
package demos.Fonts;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AllFonts
extends AnimatingControlsSurface {
    private static Vector fonts = new Vector();
    private int nStrs;
    private int strH;
    private int fi;
    protected int fsize = 14;
    protected Vector v = new Vector();

    public AllFonts() {
        this.setBackground(Color.white);
        this.setSleepAmount(500L);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void handleThread(int n) {
    }

    public void reset(int n, int n2) {
        this.v.clear();
        Font font = ((Font)fonts.get(0)).deriveFont(0, this.fsize);
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(font);
        this.strH = fontMetrics.getAscent() + fontMetrics.getDescent();
        this.nStrs = n2 / this.strH + 1;
        this.fi = 0;
    }

    public void step(int n, int n2) {
        if (this.fi < fonts.size()) {
            this.v.addElement(((Font)fonts.get(this.fi)).deriveFont(0, this.fsize));
        }
        if (this.v.size() == this.nStrs && this.v.size() != 0 || this.fi > fonts.size()) {
            this.v.removeElementAt(0);
        }
        this.fi = this.v.size() == 0 ? 0 : (this.fi = this.fi + 1);
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        graphics2D.setColor(Color.black);
        int n3 = this.fi >= fonts.size() ? 0 : n2 - this.v.size() * this.strH - this.strH / 2;
        int n4 = 0;
        while (n4 < this.v.size()) {
            Font font = (Font)this.v.get(n4);
            int n5 = ((Component)this).getFontMetrics(font).stringWidth(font.getName());
            graphics2D.setFont(font);
            graphics2D.drawString(font.getName(), n / 2 - n5 / 2, n3 += this.strH);
            ++n4;
        }
    }

    public static void main(String[] stringArray) {
        Surface.createDemoFrame(new AllFonts());
    }

    static {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        int n = 0;
        while (n < fontArray.length) {
            if (fontArray[n].canDisplayUpTo(fontArray[n].getName()) > 0) {
                fonts.addElement(fontArray[n]);
            }
            ++n;
        }
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener,
    ChangeListener {
        AllFonts demo;
        JSlider slider;
        int[] fsize = new int[]{8, 14, 18, 24};
        JMenuItem[] menuitem = new JMenuItem[this.fsize.length];
        Font[] font = new Font[this.fsize.length];

        public DemoControls(AllFonts allFonts) {
            this.demo = allFonts;
            this.setBackground(Color.gray);
            int n = (int)allFonts.getSleepAmount();
            this.slider = new JSlider(0, 0, 999, n);
            this.slider.setBorder(new EtchedBorder());
            this.slider.setPreferredSize(new Dimension(90, 22));
            this.slider.addChangeListener(this);
            this.add(this.slider);
            JMenuBar jMenuBar = new JMenuBar();
            this.add(jMenuBar);
            JMenu jMenu = jMenuBar.add(new JMenu("Font Size"));
            int n2 = 0;
            while (n2 < this.fsize.length) {
                this.font[n2] = new Font("serif", 0, this.fsize[n2]);
                this.menuitem[n2] = jMenu.add(new JMenuItem(String.valueOf(this.fsize[n2])));
                this.menuitem[n2].setFont(this.font[n2]);
                this.menuitem[n2].addActionListener(this);
                ++n2;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            while (n < this.fsize.length) {
                if (actionEvent.getSource().equals(this.menuitem[n])) {
                    this.demo.fsize = this.fsize[n];
                    Dimension dimension = this.demo.getSize();
                    this.demo.reset(dimension.width, dimension.height);
                    break;
                }
                ++n;
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.demo.setSleepAmount(this.slider.getValue());
        }
    }
}

