/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.IOException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateStore;
import sun.plugin.security.PluginCertificateStore;
import sun.plugin.security.RootCACertificateStore;
import sun.plugin.security.SessionCertificateStore;
import sun.plugin.security.TrustDeciderDialog;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.Trace;

public class TrustDecider {
    private static CertificateStore rootStore = new RootCACertificateStore();
    private static CertificateStore permanentStore = new PluginCertificateStore();
    private static CertificateStore sessionStore = new SessionCertificateStore();

    public static boolean isAllPermissionGranted(CodeSource codeSource) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        Certificate[] certificateArray = codeSource.getCertificates();
        String string = codeSource.getLocation().toString();
        if (certificateArray == null) {
            if (TrustDecider.isBrowserMozilla()) {
                return TrustDecider.isAllPermissionGranted(codeSource, string, null, null, 0, null, 0, "");
            }
            return false;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < certificateArray.length) {
            int n3;
            Object[] objectArray;
            int n4 = n;
            CertificateExpiredException certificateExpiredException = null;
            CertificateNotYetValidException certificateNotYetValidException = null;
            while (n4 + 1 < certificateArray.length) {
                block28: {
                    if (!(certificateArray[n4] instanceof X509Certificate) || !(certificateArray[n4 + 1] instanceof X509Certificate) || !TrustDecider.isIssuerOf((X509Certificate)certificateArray[n4], (X509Certificate)certificateArray[n4 + 1])) break;
                    try {
                        ((X509Certificate)certificateArray[n4]).checkValidity();
                        ((X509Certificate)certificateArray[n4 + 1]).checkValidity();
                    }
                    catch (CertificateExpiredException certificateExpiredException2) {
                        if (certificateExpiredException == null) {
                            certificateExpiredException = certificateExpiredException2;
                        }
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException2) {
                        if (certificateNotYetValidException != null) break block28;
                        certificateNotYetValidException = certificateNotYetValidException2;
                    }
                }
                ++n4;
            }
            n2 = n4 + 1;
            if (TrustDecider.isBrowserMozilla()) {
                byte[][] byArray = TrustDecider.makeChain(certificateArray, n, n2);
                if (byArray != null) {
                    Principal principal;
                    String string2;
                    objectArray = new int[byArray.length];
                    n3 = 0;
                    while (n3 < byArray.length) {
                        objectArray[n3] = byArray[n3].length;
                        ++n3;
                    }
                    X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                    byte[] byArray2 = x509Certificate.getSignature();
                    if (TrustDecider.isAllPermissionGranted(codeSource, string, byArray, objectArray, byArray.length, byArray2, byArray2.length, string2 = (principal = x509Certificate.getSubjectDN()).getName())) {
                        return true;
                    }
                }
            } else {
                int n5;
                boolean bl = false;
                rootStore.load();
                permanentStore.load();
                sessionStore.load();
                if (!rootStore.verify(certificateArray[n4])) {
                    throw new CertificateException("Unable to verify the certificate with root CA");
                }
                if (permanentStore.contains(certificateArray[n])) {
                    return true;
                }
                if (sessionStore.contains(certificateArray[n])) {
                    return true;
                }
                if (certificateExpiredException != null) {
                    objectArray = new Object[2];
                    objectArray[0] = (int)ResourceHandler.getMessage("rsa.cert_expired_prompt_user");
                    objectArray[1] = (int)certificateExpiredException;
                    n3 = 0;
                    if (!Trace.isAutomationEnabled()) {
                        n3 = DialogFactory.showConfirmDialog(objectArray, ResourceHandler.getMessage("security_dialog.caption"));
                    } else {
                        Trace.securityPrintln("Automation: Ignore certificate expiration", 2);
                        n3 = 0;
                    }
                    if (n3 != 0) {
                        throw certificateExpiredException;
                    }
                }
                if (certificateNotYetValidException != null) {
                    objectArray = new Object[2];
                    objectArray[0] = (int)ResourceHandler.getMessage("rsa.cert_notyieldvalid_prompt_user");
                    objectArray[1] = (int)certificateNotYetValidException;
                    n3 = 0;
                    if (!Trace.isAutomationEnabled()) {
                        n3 = DialogFactory.showConfirmDialog(objectArray, ResourceHandler.getMessage("security_dialog.caption"));
                    } else {
                        Trace.securityPrintln("Automation: Ignore certificate expiration (not yield valid)", 2);
                        n3 = 0;
                    }
                    if (n3 != 0) {
                        throw certificateNotYetValidException;
                    }
                }
                if ((n5 = TrustDecider.showSecurityDialog(codeSource)) == 0) {
                    Trace.securityPrintln("User has granted the priviledges to the code for this session only", 2);
                    sessionStore.add(certificateArray[n]);
                    sessionStore.save();
                    bl = true;
                } else if (n5 == 2) {
                    Trace.securityPrintln("User has granted the priviledges to the code forever", 2);
                    permanentStore.add(certificateArray[n]);
                    permanentStore.save();
                    bl = true;
                } else {
                    Trace.securityPrintln("User has denied the priviledges to the code", 2);
                }
                return bl;
            }
            n = n2;
        }
        return false;
    }

    private static native boolean isBrowserMozilla();

    private static native boolean isAllPermissionGranted(CodeSource var0, String var1, byte[][] var2, int[] var3, int var4, byte[] var5, int var6, String var7);

    private static byte[][] makeChain(Certificate[] certificateArray, int n, int n2) throws CertificateEncodingException {
        if (n == n2) {
            return null;
        }
        byte[][] byArrayArray = new byte[n2 - n][];
        int n3 = n;
        while (n3 < n2) {
            byArrayArray[n3 - n] = certificateArray[n3].getEncoded();
            ++n3;
        }
        return byArrayArray;
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return principal2.equals(principal = x509Certificate2.getSubjectDN());
    }

    static int showSecurityDialog(CodeSource codeSource) {
        Integer n = (Integer)AccessController.doPrivileged(new PrivilegedBlockAction(codeSource));
        int n2 = 2;
        if (n != null) {
            n2 = n;
        }
        return n2;
    }

    private static class PrivilegedBlockAction
    implements PrivilegedAction {
        Certificate[] certs;

        PrivilegedBlockAction(CodeSource codeSource) {
            this.certs = codeSource.getCertificates();
        }

        public Object run() {
            TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(this.certs);
            return new Integer(trustDeciderDialog.DoModal());
        }
    }
}

