/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.Checksum;

public class Adler32
implements Checksum {
    private static int BASE = 65521;
    private int s1;
    private int s2;

    public Adler32() {
        this.reset();
    }

    public void reset() {
        this.s1 = 1;
        this.s2 = 0;
    }

    public void update(int bval) {
        this.s1 = (this.s1 + (bval & 0xFF)) % BASE;
        this.s2 = (this.s1 + this.s2) % BASE;
    }

    public void update(byte[] buffer) {
        this.update(buffer, 0, buffer.length);
    }

    public void update(byte[] buf, int off, int len) {
        int s1 = this.s1;
        int s2 = this.s2;
        while (len > 0) {
            int n = 4000;
            if (n > len) {
                n = len;
            }
            len -= n;
            while (--n >= 0) {
                s2 += (s1 += buf[off++] & 0xFF);
            }
            s1 %= BASE;
            s2 %= BASE;
        }
        this.s1 = s1;
        this.s2 = s2;
    }

    public long getValue() {
        return ((long)this.s2 << 16) + (long)this.s1;
    }
}

