/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

public class TreeSet
extends AbstractSet
implements SortedSet,
Cloneable,
Serializable {
    transient SortedMap map;
    static final long serialVersionUID = -2479143000061671589L;

    public TreeSet() {
        this.map = new TreeMap();
    }

    public TreeSet(Comparator comparator) {
        this.map = new TreeMap(comparator);
    }

    public TreeSet(Collection collection) {
        this.map = new TreeMap();
        this.addAll(collection);
    }

    public TreeSet(SortedSet sortedSet) {
        TreeMap map = new TreeMap(sortedSet.comparator());
        boolean i = false;
        Iterator itr = sortedSet.iterator();
        map.putKeysLinear(itr, sortedSet.size());
        this.map = map;
    }

    TreeSet(SortedMap backingMap) {
        this.map = backingMap;
    }

    public boolean add(Object obj) {
        return this.map.put(obj, Boolean.TRUE) == null;
    }

    public boolean addAll(Collection c) {
        boolean result = false;
        int size = c.size();
        Iterator itr = c.iterator();
        for (int i = 0; i < size; ++i) {
            result |= this.map.put(itr.next(), Boolean.TRUE) == null;
        }
        return result;
    }

    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        TreeSet copy = null;
        try {
            copy = (TreeSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        copy.map = (SortedMap)((TreeMap)this.map).clone();
        return copy;
    }

    public Comparator comparator() {
        return this.map.comparator();
    }

    public boolean contains(Object obj) {
        return this.map.containsKey(obj);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public boolean remove(Object obj) {
        return this.map.remove(obj) != null;
    }

    public Object first() {
        return this.map.firstKey();
    }

    public Object last() {
        return this.map.lastKey();
    }

    public SortedSet subSet(Object from, Object to) {
        return new TreeSet(this.map.subMap(from, to));
    }

    public SortedSet headSet(Object to) {
        return new TreeSet(this.map.headMap(to));
    }

    public SortedSet tailSet(Object from) {
        return new TreeSet(this.map.tailMap(from));
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Iterator itr = this.map.keySet().iterator();
        int size = this.map.size();
        out.writeObject(this.map.comparator());
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeObject(itr.next());
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        Comparator comparator = (Comparator)in.readObject();
        int size = in.readInt();
        TreeMap map = new TreeMap(comparator);
        map.putFromObjStream(in, size, false);
        this.map = map;
    }
}

