/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class Locale
implements Serializable,
Cloneable {
    private String country;
    private int hashcode;
    private String language;
    private String variant;
    private static Locale defaultLocale;
    private static final long serialVersionUID = 9149081749638150636L;
    public static final Locale CHINESE;
    public static final Locale ENGLISH;
    public static final Locale FRENCH;
    public static final Locale GERMAN;
    public static final Locale ITALIAN;
    public static final Locale JAPANESE;
    public static final Locale KOREAN;
    public static final Locale CANADA;
    public static final Locale CANADA_FRENCH;
    public static final Locale FRANCE;
    public static final Locale GERMANY;
    public static final Locale ITALY;
    public static final Locale JAPAN;
    public static final Locale KOREA;
    public static final Locale UK;
    public static final Locale US;
    public static final Locale SIMPLIFIED_CHINESE;
    public static final Locale TRADITIONAL_CHINESE;
    public static final Locale PRC;
    public static final Locale TAIWAN;
    public static final Locale CHINA;

    public Locale(String languageCode, String countryCode) {
        this(languageCode, countryCode, "");
    }

    public Locale(String languageCode, String countryCode, String variantCode) {
        this.language = languageCode.toLowerCase();
        this.country = countryCode.toUpperCase();
        this.variant = variantCode.toUpperCase();
        this.hashcode = languageCode.hashCode() ^ countryCode.hashCode() ^ variantCode.hashCode();
    }

    public Object clone() {
        return new Locale(this.language, this.country, this.variant);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Locale)) {
            return false;
        }
        Locale loc = (Locale)obj;
        return this.language.equals(loc.language) && this.country.equals(loc.country) && this.variant.equals(loc.variant);
    }

    public String getCountry() {
        return this.country;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getVariant() {
        return this.variant;
    }

    public int hashCode() {
        return this.hashcode;
    }

    private static synchronized Locale setDefault() {
        if (defaultLocale != null) {
            return defaultLocale;
        }
        String language = System.getProperty("user.language");
        String country = System.getProperty("user.region");
        defaultLocale = new Locale(language == null ? "en" : language, country == null ? "" : country);
        return defaultLocale;
    }

    public static Locale getDefault() {
        if (defaultLocale == null) {
            return Locale.setDefault();
        }
        return defaultLocale;
    }

    public static void setDefault(Locale newLocale) {
        defaultLocale = newLocale;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(20);
        result.append(this.language);
        if (this.country.length() > 0) {
            result.append('_');
            result.append(this.country);
            if (this.variant.length() > 0) {
                result.append('_');
                result.append(this.variant);
            }
        }
        return result.toString();
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        int tmpHashcode = this.hashcode;
        this.hashcode = -1;
        output.defaultWriteObject();
        this.hashcode = tmpHashcode;
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        this.hashcode = this.language.hashCode() ^ this.country.hashCode() ^ this.variant.hashCode();
    }

    static {
        CHINESE = new Locale("zh", "");
        ENGLISH = new Locale("en", "");
        FRENCH = new Locale("fr", "");
        GERMAN = new Locale("de", "");
        ITALIAN = new Locale("it", "");
        JAPANESE = new Locale("ja", "");
        KOREAN = new Locale("ko", "");
        CANADA = new Locale("en", "CA");
        CANADA_FRENCH = new Locale("fr", "CA");
        FRANCE = new Locale("fr", "FR");
        GERMANY = new Locale("de", "DE");
        ITALY = new Locale("it", "IT");
        JAPAN = new Locale("ja", "JP");
        KOREA = new Locale("ko", "KR");
        UK = new Locale("en", "GB");
        US = new Locale("en", "US");
        SIMPLIFIED_CHINESE = new Locale("zh", "CN");
        TRADITIONAL_CHINESE = new Locale("zh", "TW");
        PRC = SIMPLIFIED_CHINESE;
        TAIWAN = TRADITIONAL_CHINESE;
        CHINA = PRC;
    }
}

