/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArrayList
extends AbstractList
implements List,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 16;
    int size;
    transient Object[] data;

    public ArrayList(int capacity) {
        this.data = new Object[capacity];
    }

    public ArrayList() {
        this(16);
    }

    public ArrayList(Collection c) {
        this((int)((double)c.size() * 1.1));
        this.addAll(c);
    }

    public void ensureCapacity(int minCapacity) {
        int current = this.data.length;
        if (minCapacity > current) {
            Object[] newData = new Object[Math.max(current * 2, minCapacity)];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public boolean add(Object e) {
        ++this.modCount;
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.data[this.size++] = e;
        return true;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
        return this.data[index];
    }

    public int size() {
        return this.size;
    }

    public Object remove(int index) {
        ++this.modCount;
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
        Object r = this.data[index];
        if (index != (this.size += -1)) {
            System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
        }
        this.data[this.size] = null;
        return r;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        if (fromIndex != toIndex) {
            System.arraycopy(this.data, toIndex, this.data, fromIndex, this.size - toIndex);
            this.size -= toIndex - fromIndex;
        }
    }

    public void add(int index, Object e) {
        ++this.modCount;
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        if (index != this.size) {
            System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        }
        this.data[index] = e;
        ++this.size;
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    public boolean addAll(int index, Collection c) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
        ++this.modCount;
        Iterator itr = c.iterator();
        int csize = c.size();
        if (csize + this.size > this.data.length) {
            this.ensureCapacity(this.size + csize);
        }
        int end = index + csize;
        if (this.size > 0 && index != this.size) {
            System.arraycopy(this.data, index, this.data, end, csize);
        }
        this.size += csize;
        while (index < end) {
            this.data[index] = itr.next();
            ++index;
        }
        return csize > 0;
    }

    public Object clone() {
        ArrayList clone = null;
        try {
            clone = (ArrayList)super.clone();
            clone.data = new Object[this.data.length];
            System.arraycopy(this.data, 0, clone.data, 0, this.size);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public boolean contains(Object e) {
        return this.indexOf(e) != -1;
    }

    public int indexOf(Object e) {
        for (int i = 0; i < this.size; ++i) {
            if (!(e == null ? this.data[i] == null : e.equals(this.data[i]))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object e) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!(e == null ? this.data[i] == null : e.equals(this.data[i]))) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = null;
        }
        this.size = 0;
    }

    public Object set(int index, Object e) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
        Object result = this.data[index];
        this.data[index] = e;
        return result;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.size];
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    public Object[] toArray(Object[] array) {
        if (array.length < this.size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        } else if (array.length > this.size) {
            array[this.size] = null;
        }
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    public void trimToSize() {
        Object[] newData = new Object[this.size];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        this.data = newData;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            out.writeObject(this.data[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        int capacity = in.readInt();
        this.data = new Object[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.data[i] = in.readObject();
        }
    }
}

