/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;

public class SimpleDateFormat
extends DateFormat {
    private transient Vector tokens;
    private DateFormatSymbols formatData;
    private Date defaultCenturyStart;
    private String pattern;
    private int serialVersionOnStream;
    private static final long serialVersionUID = 4774881970558875024L;
    private static final String standardChars = "GyMdkHmsSEDFwWahKz";

    private /* synthetic */ void finit$() {
        this.defaultCenturyStart = new Date(System.currentTimeMillis() - 1734197248L);
        this.serialVersionOnStream = 1;
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.defaultCenturyStart = new Date(System.currentTimeMillis() - 1734197248L);
            this.serialVersionOnStream = 1;
        }
        this.tokens = new Vector();
        this.compileFormat(this.pattern);
    }

    private void compileFormat(String pattern) {
        FieldSizePair current = null;
        for (int i = 0; i < pattern.length(); ++i) {
            char thisChar = pattern.charAt(i);
            int field = this.formatData.getLocalPatternChars().indexOf(thisChar);
            if (field == -1) {
                current = null;
                if (Character.isLetter(thisChar)) {
                    this.tokens.addElement(new FieldSizePair(this, -1, 0));
                    continue;
                }
                if (thisChar == '\'') {
                    int pos = pattern.indexOf(39, i + 1);
                    if (pos == -1) {
                        this.tokens.addElement(new FieldSizePair(this, -1, 0));
                    }
                    if (pos + 1 < pattern.length() && pattern.charAt(pos + 1) == '\'') {
                        this.tokens.addElement(pattern.substring(i + 1, pos + 1));
                    } else {
                        this.tokens.addElement(pattern.substring(i + 1, pos));
                    }
                    i = pos;
                    continue;
                }
                this.tokens.addElement(new Character(thisChar));
                continue;
            }
            if (current != null && field == current.field) {
                ++current.size;
                continue;
            }
            current = new FieldSizePair(this, field, 1);
            this.tokens.addElement(current);
        }
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        Enumeration e = this.tokens.elements();
        while (e.hasMoreElements()) {
            output.append(e.nextElement().toString());
        }
        return output.toString();
    }

    public SimpleDateFormat() {
        this.finit$();
        Locale locale = Locale.getDefault();
        this.calendar = new GregorianCalendar(locale);
        this.tokens = new Vector();
        this.formatData = new DateFormatSymbols(locale);
        this.pattern = this.formatData.dateFormats[2] + ' ' + this.formatData.timeFormats[2];
        this.compileFormat(this.pattern);
        this.numberFormat = NumberFormat.getInstance(locale);
    }

    public SimpleDateFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public SimpleDateFormat(String pattern, Locale locale) {
        this.finit$();
        this.calendar = new GregorianCalendar(locale);
        this.tokens = new Vector();
        this.formatData = new DateFormatSymbols(locale);
        this.compileFormat(pattern);
        this.pattern = pattern;
        this.numberFormat = NumberFormat.getInstance(locale);
    }

    public SimpleDateFormat(String pattern, DateFormatSymbols formatData) {
        this.finit$();
        this.calendar = new GregorianCalendar();
        this.calendar.setTimeZone(TimeZone.getDefault());
        this.tokens = new Vector();
        this.formatData = formatData;
        this.compileFormat(pattern);
        this.pattern = pattern;
        this.numberFormat = NumberFormat.getInstance();
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        String localChars = this.formatData.getLocalPatternChars();
        return this.applyLocalizedPattern(this.pattern, standardChars, localChars);
    }

    public void applyPattern(String pattern) {
        this.tokens = new Vector();
        this.compileFormat(pattern);
        this.pattern = pattern;
    }

    public void applyLocalizedPattern(String pattern) {
        String localChars = this.formatData.getLocalPatternChars();
        pattern = this.applyLocalizedPattern(pattern, localChars, standardChars);
        this.applyPattern(pattern);
    }

    private String applyLocalizedPattern(String pattern, String oldChars, String newChars) {
        int len = pattern.length();
        StringBuffer buf = new StringBuffer(len);
        boolean quoted = false;
        for (int i = 0; i < len; ++i) {
            int j;
            char ch = pattern.charAt(i);
            if (ch == '\'') {
                quoted ^= true;
            }
            if (!quoted && (j = oldChars.indexOf(ch)) >= 0) {
                ch = newChars.charAt(j);
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public Date get2DigitYearStart() {
        return this.defaultCenturyStart;
    }

    public void set2DigitYearStart(Date date) {
        this.defaultCenturyStart = date;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return this.formatData;
    }

    public void setDateFormatSymbols(DateFormatSymbols formatData) {
        this.formatData = formatData;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SimpleDateFormat)) {
            return false;
        }
        SimpleDateFormat sdf = (SimpleDateFormat)o;
        if (!this.toPattern().equals(sdf.toPattern())) {
            return false;
        }
        if (!this.get2DigitYearStart().equals(sdf.get2DigitYearStart())) {
            return false;
        }
        return this.getDateFormatSymbols().equals(sdf.getDateFormatSymbols());
    }

    public StringBuffer format(Date date, StringBuffer buffer, FieldPosition pos) {
        Calendar theCalendar = (Calendar)this.calendar.clone();
        theCalendar.setTime(date);
        Enumeration e = this.tokens.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof FieldSizePair) {
                FieldSizePair p = (FieldSizePair)o;
                int beginIndex = buffer.length();
                switch (p.field) {
                    case 0: {
                        buffer.append(this.formatData.eras[theCalendar.get(0)]);
                        break;
                    }
                    case 1: {
                        String temp = String.valueOf(theCalendar.get(1));
                        if (p.size < 4) {
                            buffer.append(temp.substring(temp.length() - 2));
                            break;
                        }
                        buffer.append(temp);
                        break;
                    }
                    case 2: {
                        if (p.size < 3) {
                            this.withLeadingZeros(theCalendar.get(2) + 1, p.size, buffer);
                            break;
                        }
                        if (p.size < 4) {
                            buffer.append(this.formatData.shortMonths[theCalendar.get(2)]);
                            break;
                        }
                        buffer.append(this.formatData.months[theCalendar.get(2)]);
                        break;
                    }
                    case 3: {
                        this.withLeadingZeros(theCalendar.get(5), p.size, buffer);
                        break;
                    }
                    case 4: {
                        this.withLeadingZeros((theCalendar.get(11) + 23) % 24 + 1, p.size, buffer);
                        break;
                    }
                    case 5: {
                        this.withLeadingZeros(theCalendar.get(11), p.size, buffer);
                        break;
                    }
                    case 6: {
                        this.withLeadingZeros(theCalendar.get(12), p.size, buffer);
                        break;
                    }
                    case 7: {
                        this.withLeadingZeros(theCalendar.get(13), p.size, buffer);
                        break;
                    }
                    case 8: {
                        this.withLeadingZeros(theCalendar.get(14), p.size, buffer);
                        break;
                    }
                    case 9: {
                        if (p.size < 4) {
                            buffer.append(this.formatData.shortWeekdays[theCalendar.get(7)]);
                            break;
                        }
                        buffer.append(this.formatData.weekdays[theCalendar.get(7)]);
                        break;
                    }
                    case 10: {
                        this.withLeadingZeros(theCalendar.get(6), p.size, buffer);
                        break;
                    }
                    case 11: {
                        this.withLeadingZeros(theCalendar.get(8), p.size, buffer);
                        break;
                    }
                    case 12: {
                        this.withLeadingZeros(theCalendar.get(3), p.size, buffer);
                        break;
                    }
                    case 13: {
                        this.withLeadingZeros(theCalendar.get(4), p.size, buffer);
                        break;
                    }
                    case 14: {
                        buffer.append(this.formatData.ampms[theCalendar.get(9)]);
                        break;
                    }
                    case 15: {
                        this.withLeadingZeros((theCalendar.get(10) + 11) % 12 + 1, p.size, buffer);
                        break;
                    }
                    case 16: {
                        this.withLeadingZeros(theCalendar.get(10), p.size, buffer);
                        break;
                    }
                    case 17: {
                        TimeZone zone = theCalendar.getTimeZone();
                        boolean isDST = theCalendar.get(16) != 0;
                        String zoneID = zone.getDisplayName(isDST, p.size > 3 ? 1 : 0);
                        buffer.append(zoneID);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal pattern character");
                    }
                }
                if (pos == null || p.field != pos.getField()) continue;
                pos.setBeginIndex(beginIndex);
                pos.setEndIndex(buffer.length());
                continue;
            }
            buffer.append(o.toString());
        }
        return buffer;
    }

    private void withLeadingZeros(int value, int length, StringBuffer buffer) {
        String valStr = String.valueOf(value);
        length -= valStr.length();
        while (length > 0) {
            buffer.append('0');
            --length;
        }
        buffer.append(valStr);
    }

    private final boolean expect(String source, ParsePosition pos, char ch) {
        boolean r;
        int x = pos.getIndex();
        boolean bl = r = x < source.length() && source.charAt(x) == ch;
        if (r) {
            pos.setIndex(x + 1);
        } else {
            pos.setErrorIndex(x);
        }
        return r;
    }

    public Date parse(String dateStr, ParsePosition pos) {
        int fmt_max = this.pattern.length();
        this.calendar.clear();
        int quote_start = -1;
        for (int fmt_index = 0; fmt_index < fmt_max; ++fmt_index) {
            int value;
            int calendar_field;
            char ch = this.pattern.charAt(fmt_index);
            if (ch == '\'') {
                int index = pos.getIndex();
                if (fmt_index < fmt_max - 1 && this.pattern.charAt(fmt_index + 1) == '\'') {
                    if (!this.expect(dateStr, pos, ch)) {
                        return null;
                    }
                    ++fmt_index;
                    continue;
                }
                quote_start = quote_start < 0 ? fmt_index : -1;
                continue;
            }
            if (quote_start != -1 || (ch < 'a' || ch > 'z') && (ch < 'A' || ch > 'Z')) {
                if (this.expect(dateStr, pos, ch)) continue;
                return null;
            }
            int first = fmt_index;
            while (++fmt_index < fmt_max && this.pattern.charAt(fmt_index) == ch) {
            }
            int count = fmt_index - first;
            --fmt_index;
            boolean is_numeric = true;
            String[] match = null;
            int offset = 0;
            int zone_number = 0;
            switch (ch) {
                case 'd': {
                    calendar_field = 5;
                    break;
                }
                case 'D': {
                    calendar_field = 6;
                    break;
                }
                case 'F': {
                    calendar_field = 8;
                    break;
                }
                case 'E': {
                    is_numeric = false;
                    offset = 1;
                    calendar_field = 7;
                    match = count <= 3 ? this.formatData.getShortWeekdays() : this.formatData.getWeekdays();
                    break;
                }
                case 'w': {
                    calendar_field = 3;
                    break;
                }
                case 'W': {
                    calendar_field = 4;
                    break;
                }
                case 'M': {
                    calendar_field = 2;
                    if (count <= 2) {
                        offset = -1;
                        break;
                    }
                    is_numeric = false;
                    match = count <= 3 ? this.formatData.getShortMonths() : this.formatData.getMonths();
                    break;
                }
                case 'y': {
                    calendar_field = 1;
                    if (count > 2) break;
                    offset = 1900;
                    break;
                }
                case 'K': {
                    calendar_field = 10;
                    break;
                }
                case 'h': {
                    calendar_field = 10;
                    break;
                }
                case 'H': {
                    calendar_field = 11;
                    break;
                }
                case 'k': {
                    calendar_field = 11;
                    break;
                }
                case 'm': {
                    calendar_field = 12;
                    break;
                }
                case 's': {
                    calendar_field = 13;
                    break;
                }
                case 'S': {
                    calendar_field = 14;
                    break;
                }
                case 'a': {
                    is_numeric = false;
                    calendar_field = 9;
                    match = this.formatData.getAmPmStrings();
                    break;
                }
                case 'z': {
                    is_numeric = false;
                    calendar_field = 16;
                    String[][] zoneStrings = this.formatData.getZoneStrings();
                    int zoneCount = zoneStrings.length;
                    int index = pos.getIndex();
                    boolean found_zone = false;
                    for (int j = 0; j < zoneCount; ++j) {
                        int k;
                        String[] strings = zoneStrings[j];
                        for (k = 1; k < strings.length && !dateStr.startsWith(strings[k], index); ++k) {
                        }
                        if (k == strings.length) continue;
                        if (k > 2) {
                            // empty if block
                        }
                        zone_number = 0;
                        this.calendar.setTimeZone(new SimpleTimeZone(1, strings[0]));
                        pos.setIndex(index + strings[k].length());
                        break;
                    }
                    if (found_zone) break;
                    pos.setErrorIndex(pos.getIndex());
                    return null;
                }
                default: {
                    pos.setErrorIndex(pos.getIndex());
                    return null;
                }
            }
            if (is_numeric) {
                this.numberFormat.setMinimumIntegerDigits(count);
                Number n = this.numberFormat.parse(dateStr, pos);
                if (pos == null || !(n instanceof Long)) {
                    return null;
                }
                value = n.intValue() + offset;
            } else if (match != null) {
                int i;
                int index = pos.getIndex();
                for (i = offset; i < match.length && !dateStr.startsWith(match[i], index); ++i) {
                }
                if (i == match.length) {
                    pos.setErrorIndex(index);
                    return null;
                }
                pos.setIndex(index + match[i].length());
                value = i;
            } else {
                value = zone_number;
            }
            this.calendar.set(calendar_field, value);
        }
        try {
            return this.calendar.getTime();
        }
        catch (IllegalArgumentException x) {
            pos.setErrorIndex(pos.getIndex());
            return null;
        }
    }

    class FieldSizePair {
        private /* synthetic */ SimpleDateFormat this$0;
        public int field;
        public int size;

        public FieldSizePair(SimpleDateFormat this$0, int f, int s) {
            this.this$0 = this$0;
            this.field = f;
            this.size = s;
        }
    }
}

