/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CollationElementIterator;
import java.text.RuleBasedCollator;

public final class CollationKey
implements Comparable {
    private String originalText;
    private int[] key;

    public int compareTo(CollationKey target) {
        int max = Math.min(this.key.length, target.key.length);
        for (int i = 0; i < max; ++i) {
            if (this.key[i] == target.key[i]) continue;
            return this.key[i] - target.key[i];
        }
        return this.key.length - target.key.length;
    }

    public int compareTo(Object o) {
        return this.compareTo((CollationKey)o);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CollationKey)) {
            return false;
        }
        CollationKey ck = (CollationKey)obj;
        if (this.key.length != ck.key.length) {
            return false;
        }
        for (int i = 0; i < this.key.length; ++i) {
            if (this.key[i] == ck.key[i]) continue;
            return false;
        }
        return true;
    }

    public String getSourceString() {
        return this.originalText;
    }

    public int hashCode() {
        long h = this.originalText.hashCode();
        for (int i = this.key.length - 1; i >= 0; --i) {
            h ^= (long)(this.key[i] * (i + 1));
        }
        return (int)(h >> 32) ^ (int)h;
    }

    public byte[] toByteArray() {
        byte[] r = new byte[4 * this.key.length];
        int off = 0;
        for (int i = 0; i < this.key.length; ++i) {
            r[off++] = (byte)(this.key[i] >>> 24) & 0xFFFFFFFF;
            r[off++] = (byte)(this.key[i] >>> 16) & 0xFFFFFFFF;
            r[off++] = (byte)(this.key[i] >>> 8) & 0xFFFFFFFF;
            r[off++] = (byte)this.key[i] & 0xFFFFFFFF;
        }
        return r;
    }

    CollationKey(CollationElementIterator iter, String originalText, int strength) {
        this.originalText = originalText;
        int size = 0;
        while (RuleBasedCollator.next(iter, strength) != -1) {
            ++size;
        }
        iter.reset();
        this.key = new int[size];
        for (int i = 0; i < size; ++i) {
            this.key[i] = RuleBasedCollator.next(iter, strength);
        }
    }
}

