/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Vector;

public class ChoiceFormat
extends NumberFormat {
    private String[] choiceFormats;
    private double[] choiceLimits;
    private static final int mantissaBits = 52;
    private static final int exponentBits = 11;
    private static final long serialVersionUID = 1795184449645032964L;

    public void applyPattern(String newPattern) {
        Double d;
        int index = 0;
        int max = newPattern.length();
        Vector stringVec = new Vector();
        Vector limitVec = new Vector();
        StringBuffer buf = new StringBuffer();
        while (true) {
            char c;
            int dstart = ++index;
            while (index < max && (c = newPattern.charAt(index)) != '#' && c != '\u2064' && c != '<') {
                ++index;
            }
            if (index == max) {
                throw new IllegalArgumentException("unexpected end of text");
            }
            d = new Double(newPattern.substring(dstart, index));
            if (newPattern.charAt(index) == '<') {
                d = new Double(ChoiceFormat.nextDouble(d));
            }
            limitVec.addElement(d);
            ++index;
            buf.setLength(0);
            while (index < max) {
                char c2 = newPattern.charAt(index);
                if (c2 == '\'' && index < max + 1 && newPattern.charAt(index + 1) == '\'') {
                    buf.append(c2);
                    ++index;
                } else if (c2 == '\'' && index < max + 2) {
                    buf.append(newPattern.charAt(index + 1));
                    index += 2;
                } else {
                    if (c2 == '|') break;
                    buf.append(c2);
                }
                ++index;
            }
            stringVec.addElement(buf.toString());
            if (index == max) break;
        }
        this.choiceFormats = new String[stringVec.size()];
        stringVec.copyInto(this.choiceFormats);
        this.choiceLimits = new double[limitVec.size()];
        for (int i = 0; i < this.choiceLimits.length; ++i) {
            d = (Double)limitVec.elementAt(i);
            this.choiceLimits[i] = d;
        }
    }

    public ChoiceFormat(String newPattern) {
        this.applyPattern(newPattern);
    }

    public ChoiceFormat(double[] choiceLimits, String[] choiceFormats) {
        this.setChoices(choiceLimits, choiceFormats);
    }

    public Object clone() {
        return new ChoiceFormat(this.choiceLimits, this.choiceFormats);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChoiceFormat)) {
            return false;
        }
        ChoiceFormat cf = (ChoiceFormat)obj;
        if (this.choiceLimits.length != cf.choiceLimits.length) {
            return false;
        }
        for (int i = this.choiceLimits.length - 1; i >= 0; --i) {
            if (this.choiceLimits[i] == cf.choiceLimits[i] && this.choiceFormats[i].equals(cf.choiceFormats[i])) continue;
            return false;
        }
        return true;
    }

    public StringBuffer format(long num, StringBuffer appendBuf, FieldPosition pos) {
        return this.format((double)num, appendBuf, pos);
    }

    public StringBuffer format(double num, StringBuffer appendBuf, FieldPosition pos) {
        int index;
        if (this.choiceLimits.length == 0) {
            return appendBuf;
        }
        if (!Double.isNaN(num) && num >= this.choiceLimits[0]) {
            for (index = 0; !(index >= this.choiceLimits.length - 1 || this.choiceLimits[index] <= num && index != this.choiceLimits.length - 2 && num < this.choiceLimits[index + 1]); ++index) {
            }
        }
        return appendBuf.append(this.choiceFormats[index]);
    }

    public Object[] getFormats() {
        return (Object[])this.choiceFormats.clone();
    }

    public double[] getLimits() {
        return (double[])this.choiceLimits.clone();
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.choiceLimits.length; ++i) {
            long v = Double.doubleToLongBits(this.choiceLimits[i]);
            hash ^= (int)v ^ (int)(v >>> 32);
            hash ^= this.choiceFormats[i].hashCode();
        }
        return hash;
    }

    public static final double nextDouble(double d) {
        return ChoiceFormat.nextDouble(d, true);
    }

    public static double nextDouble(double d, boolean next) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return d;
        }
        long bits = Double.doubleToLongBits(d);
        long mantMask = 0xFFFFFFFFFFFFFL;
        long mantissa = bits & mantMask;
        long expMask = 2047;
        long exponent = bits >>> 52 & expMask;
        if (next ^ bits < 0L) {
            if (mantissa == 0xFFFFFFFFFFFFFL) {
                mantissa = 0L;
                if (++exponent >= 0x10000000000000L) {
                    if (bits > 0L) {
                        return Double.POSITIVE_INFINITY;
                    }
                    return Double.NEGATIVE_INFINITY;
                }
            } else {
                ++mantissa;
            }
        } else {
            if (exponent == 0L && mantissa == 0L) {
                if (next) {
                    return Double.MIN_VALUE;
                }
                return -4.9E-324;
            }
            if (mantissa == 0L) {
                mantissa = 0xFFFFFFFFFFFFFL;
                exponent += (long)-1;
            } else {
                mantissa += (long)-1;
            }
        }
        long result = bits < 0L ? 1L : 0L;
        result = result << 11 | exponent;
        result = result << 52 | mantissa;
        return Double.longBitsToDouble(result);
    }

    public Number parse(String sourceStr, ParsePosition pos) {
        int index = pos.getIndex();
        for (int i = 0; i < this.choiceLimits.length; ++i) {
            if (!sourceStr.startsWith(this.choiceFormats[i], index)) continue;
            pos.setIndex(index + this.choiceFormats[i].length());
            return new Double(this.choiceLimits[i]);
        }
        pos.setErrorIndex(index);
        return new Double(Double.NaN);
    }

    public static final double previousDouble(double d) {
        return ChoiceFormat.nextDouble(d, false);
    }

    public void setChoices(double[] choiceLimits, String[] choiceFormats) {
        if (choiceLimits == null || choiceFormats == null) {
            throw new NullPointerException();
        }
        if (choiceLimits.length != choiceFormats.length) {
            throw new IllegalArgumentException();
        }
        this.choiceFormats = (String[])choiceFormats.clone();
        this.choiceLimits = (double[])choiceLimits.clone();
    }

    private final void quoteString(StringBuffer dest, String text) {
        int max = text.length();
        for (int i = 0; i < max; ++i) {
            char c = text.charAt(i);
            if (c == '\'') {
                dest.append(c);
                dest.append(c);
                continue;
            }
            if (c == '#' || c == '|' || c == '\u2064' || c == '<') {
                dest.append('\'');
                dest.append(c);
                dest.append('\'');
                continue;
            }
            dest.append(c);
        }
    }

    public String toPattern() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.choiceLimits.length; ++i) {
            result.append(this.choiceLimits[i]);
            result.append('#');
            this.quoteString(result, this.choiceFormats[i]);
        }
        return result.toString();
    }
}

