/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

public abstract class MessageDigest {
    private String name;

    protected MessageDigest(String algorithm) {
        this.name = algorithm;
    }

    public static MessageDigest getInstance(String algorithm) throws NoSuchAlgorithmException {
        String name = "MessageDigest." + algorithm;
        Provider[] provs = Security.getProviders();
        for (int i = 0; i < provs.length; ++i) {
            String val = provs[i].getProperty(name);
            if (val == null) continue;
            try {
                return (MessageDigest)Class.forName(val).newInstance();
            }
            catch (Throwable _) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static MessageDigest getInstance(String algorithm, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        String name = "MessageDigest." + algorithm;
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        String val = p.getProperty(name);
        if (val != null) {
            try {
                return (MessageDigest)Class.forName(val).newInstance();
            }
            catch (Throwable _) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public void update(byte input) {
        this.engineUpdate(input);
    }

    public void update(byte[] input, int offset, int len) {
        this.engineUpdate(input, offset, len);
    }

    public void update(byte[] input) {
        this.engineUpdate(input, 0, input.length);
    }

    public byte[] digest() {
        return this.engineDigest();
    }

    public byte[] digest(byte[] input) {
        this.update(input);
        return this.engineDigest();
    }

    public String toString() {
        return "[MessageDigest: " + this.name + "]";
    }

    public static boolean isEqual(byte[] digesta, byte[] digestb) {
        if (digesta == digestb) {
            return true;
        }
        if (digesta.length != digestb.length) {
            return false;
        }
        for (int i = digesta.length - 1; i >= 0; --i) {
            if (digesta[i] == digestb[i]) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.engineReset();
    }

    public final String getAlgorithm() {
        return this.name;
    }

    protected abstract void engineUpdate(byte var1);

    protected abstract void engineUpdate(byte[] var1, int var2, int var3);

    protected abstract byte[] engineDigest();

    protected abstract void engineReset();

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

