/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;

public class ServerSocket {
    static SocketImplFactory factory;
    SocketImpl impl = factory == null ? new PlainSocketImpl() : factory.createSocketImpl();
    static final byte[] zeros;
    static final InetAddress ANY_IF;

    public ServerSocket(int port) throws IOException {
        this(port, 50);
    }

    public ServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, ANY_IF);
    }

    public ServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkListen(port);
        }
        this.impl.create(true);
        this.impl.bind(bindAddr == null ? ANY_IF : bindAddr, port);
        this.impl.listen(backlog);
    }

    public InetAddress getInetAddress() {
        return this.impl.getInetAddress();
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public Socket accept() throws IOException {
        Socket s = new Socket(Socket.factory == null ? new PlainSocketImpl() : Socket.factory.createSocketImpl());
        this.implAccept(s);
        return s;
    }

    protected final void implAccept(Socket s) throws IOException {
        this.impl.accept(s.impl);
    }

    public void close() throws IOException {
        this.impl.close();
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Invalid timeout: " + timeout);
        }
        this.impl.setOption(4102, new Integer(timeout));
    }

    public synchronized int getSoTimeout() throws SocketException {
        Object timeout = this.impl.getOption(4102);
        if (timeout instanceof Integer) {
            return (Integer)timeout;
        }
        return 0;
    }

    public String toString() {
        return "ServerSocket" + this.impl.toString();
    }

    public static synchronized void setSocketFactory(SocketImplFactory fac) throws IOException {
        factory = fac;
    }

    static {
        zeros = new byte[]{0, 0, 0, 0};
        ANY_IF = new InetAddress(zeros, null);
    }
}

