/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Enumeration;
import java.util.Vector;

public class ThreadGroup {
    static ThreadGroup root = new ThreadGroup();
    static boolean had_uncaught_exception = false;
    private ThreadGroup parent;
    private String name;
    private Vector threads;
    private Vector groups;
    private boolean daemon_flag;
    private int maxpri;

    private /* synthetic */ void finit$() {
        this.threads = new Vector();
        this.groups = new Vector();
        this.daemon_flag = false;
        this.maxpri = 10;
    }

    private ThreadGroup() {
        this.finit$();
        this.name = "main";
    }

    public ThreadGroup(String name) {
        this(Thread.currentThread().getThreadGroup(), name);
    }

    public ThreadGroup(ThreadGroup parent, String name) {
        this.finit$();
        parent.checkAccess();
        this.parent = parent;
        if (parent.isDestroyed()) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.maxpri = parent.maxpri;
        this.daemon_flag = parent.daemon_flag;
        parent.addGroup(this);
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        return this.parent;
    }

    public final synchronized void setMaxPriority(int maxpri) {
        this.checkAccess();
        if (maxpri < this.maxpri && maxpri >= 1 && maxpri <= 10) {
            this.maxpri = maxpri;
        }
    }

    public final int getMaxPriority() {
        return this.maxpri;
    }

    public final void setDaemon(boolean daemon) {
        this.checkAccess();
        this.daemon_flag = daemon;
    }

    public final boolean isDaemon() {
        return this.daemon_flag;
    }

    public synchronized boolean isDestroyed() {
        return this.parent == null && this != root;
    }

    public final boolean parentOf(ThreadGroup tg) {
        while (tg != null) {
            if (tg == this) {
                return true;
            }
            tg = tg.parent;
        }
        return false;
    }

    public synchronized int activeCount() {
        int i;
        int total = 0;
        for (i = 0; i < this.threads.size(); ++i) {
            if (!((Thread)this.threads.elementAt(i)).isAlive()) continue;
            ++total;
        }
        for (i = 0; i < this.groups.size(); ++i) {
            ThreadGroup g = (ThreadGroup)this.groups.elementAt(i);
            total += g.activeCount();
        }
        return total;
    }

    public synchronized int activeGroupCount() {
        int total = this.groups.size();
        for (int i = 0; i < this.groups.size(); ++i) {
            ThreadGroup g = (ThreadGroup)this.groups.elementAt(i);
            total += g.activeGroupCount();
        }
        return total;
    }

    public int enumerate(Thread[] threads) {
        return this.enumerate(threads, 0, true);
    }

    public int enumerate(Thread[] threads, boolean useDescendants) {
        return this.enumerate(threads, 0, useDescendants);
    }

    private synchronized int enumerate(Thread[] list, int next_index, boolean recurse) {
        Enumeration e = this.threads.elements();
        while (e.hasMoreElements() && next_index < list.length) {
            Thread t = (Thread)e.nextElement();
            if (!t.isAlive()) continue;
            list[next_index++] = t;
        }
        if (recurse && next_index != list.length) {
            e = this.groups.elements();
            while (e.hasMoreElements() && next_index < list.length) {
                ThreadGroup g = (ThreadGroup)e.nextElement();
                next_index = g.enumerate(list, next_index, true);
            }
        }
        return next_index;
    }

    public int enumerate(ThreadGroup[] groups) {
        return this.enumerate(groups, 0, true);
    }

    public int enumerate(ThreadGroup[] groups, boolean recurse) {
        return this.enumerate(groups, 0, recurse);
    }

    private synchronized int enumerate(ThreadGroup[] list, int next_index, boolean recurse) {
        Enumeration e = this.groups.elements();
        while (e.hasMoreElements() && next_index < list.length) {
            ThreadGroup g = (ThreadGroup)e.nextElement();
            list[next_index++] = g;
            if (!recurse || next_index == list.length) continue;
            next_index = g.enumerate(list, next_index, true);
        }
        return next_index;
    }

    public final synchronized void interrupt() {
        int i;
        this.checkAccess();
        for (i = 0; i < this.threads.size(); ++i) {
            Thread t = (Thread)this.threads.elementAt(i);
            t.interrupt();
        }
        for (i = 0; i < this.groups.size(); ++i) {
            ThreadGroup tg = (ThreadGroup)this.groups.elementAt(i);
            tg.interrupt();
        }
    }

    public final synchronized void stop() {
        int i;
        this.checkAccess();
        for (i = 0; i < this.threads.size(); ++i) {
            Thread t = (Thread)this.threads.elementAt(i);
            t.stop();
        }
        for (i = 0; i < this.groups.size(); ++i) {
            ThreadGroup tg = (ThreadGroup)this.groups.elementAt(i);
            tg.stop();
        }
    }

    public final synchronized void suspend() {
        int i;
        this.checkAccess();
        for (i = 0; i < this.threads.size(); ++i) {
            Thread t = (Thread)this.threads.elementAt(i);
            t.suspend();
        }
        for (i = 0; i < this.groups.size(); ++i) {
            ThreadGroup tg = (ThreadGroup)this.groups.elementAt(i);
            tg.suspend();
        }
    }

    public final synchronized void resume() {
        int i;
        this.checkAccess();
        for (i = 0; i < this.threads.size(); ++i) {
            Thread t = (Thread)this.threads.elementAt(i);
            t.resume();
        }
        for (i = 0; i < this.groups.size(); ++i) {
            ThreadGroup tg = (ThreadGroup)this.groups.elementAt(i);
            tg.resume();
        }
    }

    private synchronized void checkDestroy() {
        if (!this.threads.isEmpty()) {
            throw new IllegalThreadStateException("ThreadGroup has threads");
        }
        for (int i = 0; i < this.groups.size(); ++i) {
            ThreadGroup tg = (ThreadGroup)this.groups.elementAt(i);
            tg.checkDestroy();
        }
    }

    public final synchronized void destroy() {
        this.checkAccess();
        if (this.isDestroyed()) {
            throw new IllegalThreadStateException("Already destroyed.");
        }
        this.checkDestroy();
        if (this.parent != null) {
            this.parent.removeGroup(this);
        }
        this.parent = null;
        for (int i = 0; i < this.groups.size(); ++i) {
            ThreadGroup tg = (ThreadGroup)this.groups.elementAt(i);
            tg.destroy();
        }
    }

    public void list() {
        this.list("");
    }

    private synchronized void list(String indentation) {
        int i;
        System.out.print(indentation);
        System.out.println(this.toString());
        String sub = indentation + "    ";
        for (i = 0; i < this.threads.size(); ++i) {
            Thread t = (Thread)this.threads.elementAt(i);
            System.out.print(sub);
            System.out.println(t.toString());
        }
        for (i = 0; i < this.groups.size(); ++i) {
            ThreadGroup tg = (ThreadGroup)this.groups.elementAt(i);
            tg.list(sub);
        }
    }

    public void uncaughtException(Thread thread, Throwable t) {
        if (this.parent != null) {
            this.parent.uncaughtException(thread, t);
        } else if (!(t instanceof ThreadDeath)) {
            if (thread != null) {
                System.out.print("Exception in thread \"" + thread.getName() + "\" ");
            }
            try {
                t.printStackTrace();
            }
            catch (Throwable x) {
                System.out.println(t);
                System.err.println("*** Got " + x.toString() + " while trying to print stack trace");
            }
            had_uncaught_exception = true;
        }
    }

    public boolean allowThreadSuspension(boolean allow) {
        return false;
    }

    public String toString() {
        return "java.lang.ThreadGroup[name=" + this.name + ",maxpri=" + this.maxpri + "]";
    }

    public final void checkAccess() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkAccess(this);
        }
    }

    final synchronized void addThread(Thread t) {
        if (this.isDestroyed()) {
            throw new IllegalThreadStateException("ThreadGroup is destroyed");
        }
        this.threads.addElement(t);
    }

    final synchronized void removeThread(Thread t) {
        if (this.isDestroyed()) {
            throw new IllegalThreadStateException();
        }
        this.threads.removeElement(t);
        if (this.daemon_flag && this.groups.size() == 0 && this.threads.size() == 0) {
            if (this.parent != null) {
                this.parent.removeGroup(this);
            }
            this.parent = null;
        }
    }

    final synchronized void addGroup(ThreadGroup g) {
        this.groups.addElement(g);
    }

    final synchronized void removeGroup(ThreadGroup g) {
        this.groups.removeElement(g);
        if (this.daemon_flag && this.groups.size() == 0 && this.threads.size() == 0) {
            if (this.parent != null) {
                this.parent.removeGroup(this);
            }
            this.parent = null;
        }
    }

    static {
        had_uncaught_exception = false;
    }
}

