/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer
extends Number
implements Comparable {
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final int MIN_VALUE = -2147483648;
    public static final Class TYPE;
    private int value;
    private static final long serialVersionUID = 1360826667806852920L;

    public Integer(int val) {
        this.value = val;
    }

    public Integer(String str) {
        this.value = Integer.parseInt(str, 10);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int compareTo(Integer anotherInteger) {
        if (this.value == anotherInteger.value) {
            return 0;
        }
        if (this.value > anotherInteger.value) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.compareTo((Integer)o);
    }

    public static Integer decode(String str) {
        boolean isNeg = false;
        int index = 0;
        int radix = 10;
        int len = str.length();
        if (len == 0) {
            throw new NumberFormatException();
        }
        if (str.charAt(0) == '-') {
            radix = 10;
            ++index;
            isNeg = true;
        } else if (str.charAt(index) == '#') {
            radix = 16;
            ++index;
        } else if (str.charAt(index) == '0') {
            if (len == 1) {
                return new Integer(0);
            }
            if (str.charAt(++index) == 'x') {
                radix = 16;
                ++index;
            } else {
                radix = 8;
            }
        }
        if (index >= len) {
            throw new NumberFormatException();
        }
        return new Integer(Integer.parseInt(str, index, len, isNeg, radix));
    }

    public boolean equals(Object obj) {
        return obj instanceof Integer && ((Integer)obj).value == this.value;
    }

    public static Integer getInteger(String prop) {
        return Integer.getInteger(prop, null);
    }

    public static Integer getInteger(String prop, int defval) {
        Integer val = Integer.getInteger(prop, null);
        if (val == null) {
            return new Integer(defval);
        }
        return val;
    }

    public static Integer getInteger(String prop, Integer defobj) {
        try {
            String val = System.getProperty(prop);
            if (val != null) {
                return Integer.decode(val);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defobj;
    }

    public int hashCode() {
        return this.value;
    }

    public static int parseInt(String str) {
        return Integer.parseInt(str, 10);
    }

    public static int parseInt(String str, int radix) {
        int len = str.length();
        if (len == 0 || radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        boolean isNeg = false;
        int index = 0;
        if (str.charAt(index) == '-') {
            if (len > 1) {
                isNeg = true;
                ++index;
            } else {
                throw new NumberFormatException();
            }
        }
        return Integer.parseInt(str, index, len, isNeg, radix);
    }

    private static int parseInt(String str, int index, int len, boolean isNeg, int radix) {
        int val = 0;
        int max = Integer.MAX_VALUE / radix;
        if (isNeg && Integer.MAX_VALUE % radix == radix - 1) {
            ++max;
        }
        while (index < len) {
            if (val < 0 || val > max) {
                throw new NumberFormatException();
            }
            int digval = Character.digit(str.charAt(index), radix);
            if (digval < 0) {
                throw new NumberFormatException();
            }
            if (!((val = val * radix + digval) >= 0 || isNeg && val == Integer.MIN_VALUE)) {
                throw new NumberFormatException();
            }
            ++index;
        }
        if (isNeg) {
            return -val;
        }
        return val;
    }

    public static String toBinaryString(int num) {
        return Integer.toUnsignedString(num, 1);
    }

    public static String toHexString(int num) {
        return Integer.toUnsignedString(num, 4);
    }

    public static String toOctalString(int num) {
        return Integer.toUnsignedString(num, 3);
    }

    private static String toUnsignedString(int num, int exp) {
        int radix = 1 << (exp & 0x1F);
        int mask = radix - 1;
        char[] buffer = new char[32];
        int i = 32;
        do {
            buffer[--i] = Character.forDigit(num & mask, radix);
        } while ((num >>>= exp & 0x1F) != 0);
        return String.valueOf(buffer, i, 32 - i);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static String toString(int num) {
        boolean isNeg;
        char[] buffer = new char[11];
        int i = 11;
        if (num < 0) {
            isNeg = true;
            if ((num = -num) < 0) {
                buffer[--i] = 56;
                num = 0xCCCCCCC;
            }
        } else {
            isNeg = false;
        }
        do {
            buffer[--i] = (char)(48 + num % 10);
        } while ((num /= 10) > 0);
        if (isNeg) {
            buffer[--i] = 45;
        }
        return String.valueOf(buffer, i, 11 - i);
    }

    public static String toString(int num, int radix) {
        boolean isNeg;
        if (radix == 10 || radix < 2 || radix > 36) {
            return Integer.toString(num);
        }
        char[] buffer = new char[33];
        int i = 33;
        if (num < 0) {
            isNeg = true;
            if ((num = -num) < 0) {
                buffer[--i] = Character.forDigit(-(num + radix) % radix, radix);
                num = -(num / radix);
            }
        } else {
            isNeg = false;
        }
        do {
            buffer[--i] = Character.forDigit(num % radix, radix);
        } while ((num /= radix) > 0);
        if (isNeg) {
            buffer[--i] = 45;
        }
        return String.valueOf(buffer, i, 33 - i);
    }

    public static Integer valueOf(String str) {
        return new Integer(Integer.parseInt(str, 10));
    }

    public static Integer valueOf(String str, int radix) {
        return new Integer(Integer.parseInt(str, radix));
    }
}

