/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class DataInputStream
extends FilterInputStream
implements DataInput {
    boolean ignoreInitialNewline;

    private /* synthetic */ void finit$() {
        this.ignoreInitialNewline = false;
    }

    public DataInputStream(InputStream in) {
        super(in);
        this.finit$();
    }

    public final int read(byte[] b) throws IOException {
        return this.in.read(b, 0, b.length);
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    public final boolean readBoolean() throws IOException {
        int b = this.in.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b != 0;
    }

    public final byte readByte() throws IOException {
        int i = this.in.read();
        if (i < 0) {
            throw new EOFException();
        }
        return (byte)i;
    }

    public final char readChar() throws IOException {
        int a = this.in.read();
        int b = this.in.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (char)(a << 8 | b & 0xFF);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int numread = this.in.read(b, off, len);
            if (numread < 0) {
                throw new EOFException();
            }
            len -= numread;
            off += numread;
        }
    }

    public final int readInt() throws IOException {
        int a = this.in.read();
        int b = this.in.read();
        int c = this.in.read();
        int d = this.in.read();
        if (d < 0) {
            throw new EOFException();
        }
        return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
    }

    public final String readLine() throws IOException {
        StringBuffer strb = new StringBuffer();
        block0: while (true) {
            int c = 0;
            char ch = ' ';
            boolean getnext = true;
            while (getnext) {
                getnext = false;
                c = this.in.read();
                if (c < 0) {
                    if (strb.length() > 0) {
                        return strb.toString();
                    }
                    return null;
                }
                ch = (char)c;
                if ((ch = (char)(ch & 0xFF)) != 10) continue;
                if (!this.ignoreInitialNewline) break block0;
                this.ignoreInitialNewline = false;
                getnext = true;
            }
            if (ch == '\r') {
                int next_c = 0;
                int next_ch = 32;
                if (this.in instanceof BufferedInputStream) {
                    next_c = this.in.read();
                    next_ch = (char)(next_c & 0xFF);
                    if (next_ch == 10 || next_c < 0) break;
                    BufferedInputStream bin = (BufferedInputStream)this.in;
                    if (bin.pos <= 0) break;
                    bin.pos += -1;
                    break;
                }
                if (this.markSupported()) {
                    next_c = this.in.read();
                    next_ch = (char)(next_c & 0xFF);
                    if (next_ch == 10 || next_c < 0) break;
                    this.mark(1);
                    if ((this.in.read() & 0xFF) == 10) break;
                    this.reset();
                    break;
                }
                this.ignoreInitialNewline = true;
                break;
            }
            strb.append(ch);
        }
        if (strb.length() > 0) {
            return strb.toString();
        }
        return "";
    }

    public final long readLong() throws IOException {
        int a = this.in.read();
        int b = this.in.read();
        int c = this.in.read();
        int d = this.in.read();
        int e = this.in.read();
        int f = this.in.read();
        int g = this.in.read();
        int h = this.in.read();
        if (h < 0) {
            throw new EOFException();
        }
        return (long)(a & 0xFF) << 56 | (long)(b & 0xFF) << 48 | (long)(c & 0xFF) << 40 | (long)(d & 0xFF) << 32 | (long)(e & 0xFF) << 24 | (long)(f & 0xFF) << 16 | (long)(g & 0xFF) << 8 | (long)(h & 0xFF);
    }

    public final short readShort() throws IOException {
        int a = this.in.read();
        int b = this.in.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (short)((short)a << 8 | (short)b & 0xFF);
    }

    public final int readUnsignedByte() throws IOException {
        int i = this.in.read();
        if (i < 0) {
            throw new EOFException();
        }
        return i & 0xFF;
    }

    public final int readUnsignedShort() throws IOException {
        int a = this.in.read();
        int b = this.in.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (a & 0xFF) << 8 | b & 0xFF;
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static final String readUTF(DataInput in) throws IOException {
        int UTFlen = in.readUnsignedShort();
        byte[] buf = new byte[UTFlen];
        StringBuffer strbuf = new StringBuffer();
        in.readFully(buf, 0, UTFlen);
        int i = 0;
        while (i < UTFlen) {
            if ((buf[i] & 0x80) == 0) {
                strbuf.append((char)(buf[i++] & 0xFF));
                continue;
            }
            if ((buf[i] & 0xE0) == 192) {
                if (i + 1 >= UTFlen || (buf[i + 1] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                strbuf.append((char)((buf[i++] & 0x1F) << 6 | buf[i++] & 0x3F));
                continue;
            }
            if ((buf[i] & 0xF0) == 224) {
                if (i + 2 >= UTFlen || (buf[i + 1] & 0xC0) != 128 || (buf[i + 2] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                strbuf.append((char)((buf[i++] & 0xF) << 12 | (buf[i++] & 0x3F) << 6 | buf[i++] & 0x3F));
                continue;
            }
            throw new UTFDataFormatException();
        }
        return strbuf.toString();
    }

    public final int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        try {
            return (int)this.in.skip(n);
        }
        catch (EOFException eOFException) {
            return n;
        }
    }
}

