/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    Reader in;
    char[] buffer;
    int pos;
    int limit;
    int markPos;

    private /* synthetic */ void finit$() {
        this.markPos = -1;
    }

    public BufferedReader(Reader in) {
        this(in, 8192);
    }

    public BufferedReader(Reader in, int size) {
        super(in.lock);
        this.finit$();
        this.in = in;
        this.buffer = new char[size];
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                this.in = null;
                this.buffer = null;
            }
            finally {
                Object var3_2 = null;
            }
            return;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block8: {
                try {
                    this.checkStatus();
                    if (this.pos + readLimit > this.limit) {
                        char[] old_buffer = this.buffer;
                        int extraBuffSpace = 0;
                        if (this.pos > this.limit) {
                            extraBuffSpace = 1;
                        }
                        if (readLimit + extraBuffSpace > this.limit) {
                            this.buffer = new char[readLimit + extraBuffSpace];
                        }
                        this.limit -= this.pos;
                        if (this.limit >= 0) {
                            System.arraycopy(old_buffer, this.pos, this.buffer, 0, this.limit);
                            this.pos = 0;
                        }
                    }
                    if (this.limit < 0) {
                        this.pos = 1;
                        this.markPos = 0;
                        this.limit = 0;
                        break block8;
                    }
                    this.markPos = this.pos;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    throw throwable;
                }
            }
            Object var4_6 = null;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                try {
                    this.checkStatus();
                    if (this.markPos < 0) {
                        throw new IOException("mark never set or invalidated");
                    }
                    if (this.limit <= 0) break block4;
                    this.pos = this.markPos;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    throw throwable;
                }
            }
            Object var3_2 = null;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.checkStatus();
                boolean bl = this.pos < this.limit || this.in.ready();
                Object var4_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] buf, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.checkStatus();
                boolean retAtEndOfBuffer = false;
                int avail = this.limit - this.pos;
                if (count > avail) {
                    if (avail > 0) {
                        count = avail;
                    } else {
                        if (this.limit == this.buffer.length) {
                            this.markPos = -1;
                        }
                        if (this.pos > this.limit) {
                            retAtEndOfBuffer = true;
                            this.pos += -1;
                        }
                        if (this.markPos < 0) {
                            if (count >= this.buffer.length && !retAtEndOfBuffer) {
                                return this.in.read(buf, offset, count);
                            }
                            this.limit = 0;
                            this.pos = 0;
                        }
                        avail = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit);
                        if (retAtEndOfBuffer && avail > 0 && this.buffer[this.limit] == '\n') {
                            --avail;
                            ++this.limit;
                        }
                        if (avail < count) {
                            if (avail <= 0) {
                                return avail;
                            }
                            count = avail;
                        }
                        this.limit += avail;
                    }
                }
                System.arraycopy(this.buffer, this.pos, buf, offset, count);
                this.pos += count;
                return count;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                throw throwable;
            }
        }
    }

    private int fill() throws IOException {
        int count;
        this.checkStatus();
        boolean retAtEndOfBuffer = false;
        if (this.pos > this.limit) {
            retAtEndOfBuffer = true;
            this.pos += -1;
        }
        if (this.markPos >= 0 && this.limit == this.buffer.length) {
            this.markPos = -1;
        }
        if (this.markPos < 0) {
            this.limit = 0;
            this.pos = 0;
        }
        if ((count = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) > 0) {
            this.limit += count;
        }
        if (retAtEndOfBuffer && this.buffer[this.pos] == '\n') {
            --count;
            ++this.pos;
        }
        return count;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char c;
            try {
                this.checkStatus();
                if (this.pos >= this.limit && this.fill() <= 0) {
                    int n = -1;
                    Object var4_4 = null;
                    return n;
                }
                c = this.buffer[this.pos++];
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                throw throwable;
            }
            Object var4_5 = null;
            return c;
        }
    }

    private int lineEnd(int limit) {
        char ch;
        int i;
        for (i = this.pos; i < limit && (ch = this.buffer[i]) != '\n' && ch != '\r'; ++i) {
        }
        return i;
    }

    /*
     * WARNING - void declaration
     */
    public String readLine() throws IOException {
        int i;
        this.checkStatus();
        if (this.pos > this.limit) {
            int ch = this.read();
            if (ch < 0) {
                return null;
            }
            if (ch != 10) {
                this.pos += -1;
            }
        }
        if ((i = this.lineEnd(this.limit)) < this.limit) {
            void sbuf;
            String str = new String(this.buffer, this.pos, i - this.pos);
            this.pos = i + 1;
            if (this.buffer[i] == '\r' && (this.pos == this.limit || this.buffer[this.pos] == '\n')) {
                ++this.pos;
            }
            return sbuf;
        }
        StringBuffer sbuf = new StringBuffer(200);
        sbuf.append(this.buffer, this.pos, i - this.pos);
        this.pos = i;
        boolean eof = false;
        while (true) {
            int ch;
            if ((ch = this.read()) < 0) {
                eof = true;
                break;
            }
            if (ch == 10 || ch == 13) {
                if (ch != 13 || this.pos != this.limit && this.buffer[this.pos] != '\n') break;
                ++this.pos;
                break;
            }
            i = this.lineEnd(this.limit);
            sbuf.append(this.buffer, this.pos - 1, i - (this.pos - 1));
            this.pos = i;
        }
        if (sbuf.length() == 0 && eof) {
            return null;
        }
        return sbuf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long skip(long count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                int avail;
                this.checkStatus();
                if (count <= 0L) {
                    return 0L;
                }
                if (this.pos > this.limit) {
                    int ch = this.read();
                    if (ch < 0) {
                        return 0L;
                    }
                    this.pos += -1;
                }
                if (count < (long)(avail = this.limit - this.pos)) {
                    this.pos += (int)count;
                    return count;
                }
                this.pos = this.limit;
                long todo = count - (long)avail;
                if (todo > (long)this.buffer.length) {
                    this.markPos = -1;
                    todo -= this.in.skip(todo);
                    return count - todo;
                } else {
                    while (todo > 0L) {
                        avail = this.fill();
                        if (avail <= 0) return count - todo;
                        if ((long)avail > todo) {
                            avail = (int)todo;
                        }
                        this.pos += avail;
                        todo -= (long)avail;
                    }
                    return count - todo;
                }
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                throw throwable;
            }
        }
    }

    private void checkStatus() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }
}

