/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PropertyChangeSupport
implements Serializable {
    transient Hashtable propertyListeners;
    transient Vector listeners;
    Hashtable children;
    Object source;
    int propertyChangeSupportSerializedDataVersion;
    private static final long serialVersionUID = 6401253773779951803L;

    private /* synthetic */ void finit$() {
        this.propertyListeners = new Hashtable();
        this.listeners = new Vector();
        this.propertyChangeSupportSerializedDataVersion = 2;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.children = this.propertyListeners.isEmpty() ? null : this.propertyListeners;
        stream.defaultWriteObject();
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            PropertyChangeListener l = (PropertyChangeListener)e.nextElement();
            if (!(l instanceof Serializable)) continue;
            stream.writeObject(l);
        }
        stream.writeObject(null);
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        PropertyChangeListener l;
        stream.defaultReadObject();
        Hashtable hashtable = this.propertyListeners = this.children == null ? new Hashtable() : this.children;
        while ((l = (PropertyChangeListener)stream.readObject()) != null) {
            this.addPropertyChangeListener(l);
        }
    }

    public PropertyChangeSupport(Object source) {
        this.finit$();
        this.source = source;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addElement(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        Hashtable hashtable = this.propertyListeners;
        synchronized (hashtable) {
            try {
                Vector v = (Vector)this.propertyListeners.get(propertyName);
                try {
                    v.addElement(l);
                }
                catch (NullPointerException e) {
                    v = new Vector();
                    v.addElement(l);
                    this.propertyListeners.put(propertyName, v);
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removeElement(l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        Hashtable hashtable = this.propertyListeners;
        synchronized (hashtable) {
            try {
                Vector v = (Vector)this.propertyListeners.get(propertyName);
                try {
                    v.removeElement(l);
                    if (v.size() == 0) {
                        this.propertyListeners.remove(propertyName);
                    }
                }
                catch (NullPointerException e) {
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
        }
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((PropertyChangeListener)this.listeners.elementAt(i)).propertyChange(event);
        }
        Vector moreListeners = (Vector)this.propertyListeners.get(event.getPropertyName());
        if (moreListeners != null) {
            for (int i = 0; i < moreListeners.size(); ++i) {
                ((PropertyChangeListener)moreListeners.elementAt(i)).propertyChange(event);
            }
        }
    }

    public void firePropertyChange(String propertyName, Object oldVal, Object newVal) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, oldVal, newVal));
    }

    public void firePropertyChange(String propertyName, boolean oldVal, boolean newVal) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, new Boolean(oldVal), new Boolean(newVal)));
    }

    public void firePropertyChange(String propertyName, int oldVal, int newVal) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, new Integer(oldVal), new Integer(newVal)));
    }

    public boolean hasListeners(String propertyName) {
        return this.listeners.size() > 0 || this.propertyListeners.get(propertyName) != null;
    }
}

