/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.gcj.awt.Buffers;
import java.awt.Point;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public abstract class ColorModel
implements Transparency {
    protected int pixel_bits;
    protected int transferType;
    int[] bits;
    ColorSpace cspace;
    int transparency;
    boolean hasAlpha;
    boolean isAlphaPremultiplied;

    static int[] nArray(int value, int times) {
        int[] array = new int[times];
        Arrays.fill(array, value);
        return array;
    }

    static byte[] nArray(byte value, int times) {
        byte[] array = new byte[times];
        Arrays.fill(array, value);
        return array;
    }

    public ColorModel(int bits) {
        this(bits * 4, ColorModel.nArray(bits, 4), null, true, false, 3, Buffers.smallestAppropriateTransferType(bits * 4));
    }

    protected ColorModel(int pixel_bits, int[] bits, ColorSpace cspace, boolean hasAlpha, boolean isAlphaPremultiplied, int transparency, int transferType) {
        this.pixel_bits = pixel_bits;
        this.bits = bits;
        this.cspace = cspace;
        this.hasAlpha = hasAlpha;
        this.isAlphaPremultiplied = isAlphaPremultiplied;
        this.transparency = transparency;
        this.transferType = transferType;
    }

    public static ColorModel getRGBdefault() {
        return new DirectColorModel(8, 0xFF0000, 65280, 255, -16777216);
    }

    public final boolean hasAlpha() {
        return this.hasAlpha;
    }

    public final boolean isAlphaPremultiplied() {
        return this.isAlphaPremultiplied;
    }

    public int getPixelSize() {
        return this.pixel_bits;
    }

    public int getComponentSize(int componentIdx) {
        return this.bits[componentIdx];
    }

    public int[] getComponentSize() {
        return this.bits;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public int getNumComponents() {
        return this.getNumColorComponents() + (this.hasAlpha ? 1 : 0);
    }

    public int getNumColorComponents() {
        return this.cspace.getNumComponents();
    }

    public abstract int getRed(int var1);

    public abstract int getGreen(int var1);

    public abstract int getBlue(int var1);

    public abstract int getAlpha(int var1);

    public int getRGB(int pixel) {
        return (this.getAlpha(pixel) & 0xFF) << 24 | (this.getRed(pixel) & 0xFF) << 16 | (this.getGreen(pixel) & 0xFF) << 8 | (this.getBlue(pixel) & 0xFF) << 0;
    }

    final int getPixelFromArray(Object inData) {
        DataBuffer data = Buffers.createBufferFromData(this.transferType, inData, 1);
        Object da = Buffers.getData(data);
        return data.getElem(0);
    }

    public int getRed(Object inData) {
        return this.getRed(this.getPixelFromArray(inData));
    }

    public int getGreen(Object inData) {
        return this.getGreen(this.getPixelFromArray(inData));
    }

    public int getBlue(Object inData) {
        return this.getBlue(this.getPixelFromArray(inData));
    }

    public int getAlpha(Object inData) {
        return this.getBlue(this.getPixelFromArray(inData));
    }

    public int getRGB(Object inData) {
        return (this.getAlpha(inData) & 0xFF) << 24 | (this.getRed(inData) & 0xFF) << 16 | (this.getGreen(inData) & 0xFF) << 8 | (this.getBlue(inData) & 0xFF) << 0;
    }

    public Object getDataElements(int rgb, Object pixel) {
        throw new UnsupportedOperationException();
    }

    public int[] getComponents(int pixel, int[] components, int offset) {
        throw new UnsupportedOperationException();
    }

    public int[] getComponents(Object pixel, int[] components, int offset) {
        throw new UnsupportedOperationException();
    }

    public int[] getUnnormalizedComponents(float[] normComponents, int normOffset, int[] components, int offset) {
        int numComponents = this.getNumComponents();
        if (components == null) {
            components = new int[offset + numComponents];
        }
        for (int i = 0; i < numComponents; ++i) {
            float in = normComponents[normOffset++];
            int out = (int)(in * (float)((2 << (this.getComponentSize(i) & 0x1F)) - 1));
            components[offset++] = out;
        }
        return components;
    }

    public float[] getNormalizedComponents(int[] components, int offset, float[] normComponents, int normOffset) {
        int numComponents = this.getNumComponents();
        if (normComponents == null) {
            normComponents = new float[normOffset + numComponents];
        }
        for (int i = 0; i < numComponents; ++i) {
            float in = components[offset++];
            float out = in / (float)((2 << (this.getComponentSize(i) & 0x1F)) - 1);
            normComponents[normOffset++] = out;
        }
        return normComponents;
    }

    public int getDataElement(int[] components, int offset) {
        throw new UnsupportedOperationException();
    }

    public Object getDataElements(int[] components, int offset, Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColorModel)) {
            return false;
        }
        ColorModel o = (ColorModel)obj;
        return this.pixel_bits == o.pixel_bits && this.transferType == o.transferType && this.transparency == o.transparency && this.hasAlpha == o.hasAlpha && this.bits.equals(o.bits) && this.cspace.equals(o.cspace);
    }

    public final ColorSpace getColorSpace() {
        return this.cspace;
    }

    public ColorModel coerceData(WritableRaster raster, boolean isAlphaPremultiplied) {
        if (this.isAlphaPremultiplied == isAlphaPremultiplied) {
            return this;
        }
        int w = raster.getWidth();
        int h = raster.getHeight();
        int x = raster.getMinX();
        int y = raster.getMinY();
        int size = w * h;
        int numColors = this.getNumColorComponents();
        int numComponents = this.getNumComponents();
        int alphaScale = (1 << (this.getComponentSize(numColors) & 0x1F)) - 1;
        double[] pixels = raster.getPixels(x, y, w, h, (double[])null);
        for (int i = 0; i < size; ++i) {
            double alpha = pixels[i * numComponents + numColors] * (double)alphaScale;
            for (int c = 0; c < numColors; ++c) {
                int offset = i * numComponents + c;
                pixels[offset] = isAlphaPremultiplied ? pixels[offset] / alpha : pixels[offset] * alpha;
            }
        }
        raster.setPixels(0, 0, w, h, pixels);
        return null;
    }

    public boolean isCompatibleRaster(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        return this.isCompatibleSampleModel(sampleModel);
    }

    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        return new WritableRaster(this.createCompatibleSampleModel(w, h), new Point(0, 0));
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        throw new UnsupportedOperationException();
    }

    public boolean isCompatibleSampleModel(SampleModel sm) {
        return sm.getTransferType() == this.transferType;
    }

    public void finalize() {
    }

    public WritableRaster getAlphaRaster(WritableRaster raster) {
        return null;
    }

    String stringParam() {
        return "pixel_bits=" + this.pixel_bits + ", cspace=" + this.cspace + ", transferType=" + this.transferType + ", transparency=" + this.transparency + ", hasAlpha=" + this.hasAlpha + ", isAlphaPremultiplied=" + this.isAlphaPremultiplied;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.stringParam() + "]";
    }
}

