/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollbarPeer;

public class Scrollbar
extends Component
implements Adjustable {
    private AdjustmentListener listeners;
    private int orientation;
    private int value;
    private int visible;
    private int minimum;
    private int maximum;
    private int unit;
    private int block;

    public Scrollbar() {
        this(1, 0, 10, 0, 100);
    }

    public Scrollbar(int orientation) {
        this(orientation, 0, 10, 0, 100);
    }

    public Scrollbar(int orientation, int value, int visible, int minimum, int maximum) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException();
        }
        if (maximum < minimum) {
            maximum = minimum;
        }
        if (value < minimum) {
            value = minimum;
        }
        if (value > maximum) {
            value = maximum;
        }
        this.orientation = orientation;
        this.value = value;
        this.visible = visible;
        this.minimum = minimum;
        this.maximum = maximum;
        this.unit = 1;
        this.block = 0;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createScrollbar(this);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException();
        }
        this.orientation = orientation;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.setValues(value, this.visible, this.minimum, this.maximum);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.setValues(this.value, this.visible, minimum, this.maximum);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.setValues(this.value, this.visible, this.minimum, maximum);
    }

    public int getVisibleAmount() {
        return this.visible;
    }

    public int getVisible() {
        return this.visible;
    }

    public void setVisibleAmount(int visible) {
        this.setValues(this.value, visible, this.minimum, this.maximum);
    }

    public void setUnitIncrement(int v) {
        this.unit = v;
        if (this.peer != null) {
            ScrollbarPeer sp = (ScrollbarPeer)this.peer;
            sp.setLineIncrement(v);
        }
    }

    public void setLineIncrement(int v) {
        this.setUnitIncrement(v);
    }

    public int getUnitIncrement() {
        return this.unit;
    }

    public int getLineIncrement() {
        return this.unit;
    }

    public void setBlockIncrement(int v) {
        this.block = v;
        if (this.peer != null) {
            ScrollbarPeer sp = (ScrollbarPeer)this.peer;
            sp.setPageIncrement(v);
        }
    }

    public void setPageIncrement(int v) {
        this.setBlockIncrement(v);
    }

    public int getBlockIncrement() {
        return this.block;
    }

    public int getPageIncrement() {
        return this.block;
    }

    public synchronized void setValues(int value, int visible, int minimum, int maximum) {
        if (maximum < minimum) {
            maximum = minimum;
        }
        if (value < minimum) {
            value = minimum;
        }
        if (value > maximum) {
            value = maximum;
        }
        this.value = value;
        this.visible = visible;
        this.minimum = minimum;
        this.maximum = maximum;
        if (this.peer != null) {
            ScrollbarPeer sp = (ScrollbarPeer)this.peer;
            sp.setValues(value, visible, minimum, maximum);
        }
    }

    public void addAdjustmentListener(AdjustmentListener l) {
        this.listeners = AWTEventMulticaster.add(this.listeners, l);
    }

    public void removeAdjustmentListener(AdjustmentListener l) {
        this.listeners = AWTEventMulticaster.remove(this.listeners, l);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    protected void processAdjustmentEvent(AdjustmentEvent e) {
        if (this.listeners != null) {
            this.listeners.adjustmentValueChanged(e);
        }
    }

    protected String paramString() {
        return "Scrollbar[" + (this.orientation == 1 ? "VERTICAL" : "HORIZONTAL") + "," + this.value + "," + this.visible + "," + this.minimum + "," + this.maximum + "," + this.unit + "," + this.block + "]";
    }
}

